/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl.test.util;

import java.io.File;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import org.wildfly.security.ssl.test.util.CAGenerationTool;

public abstract class CommonIdentity {
    protected final CAGenerationTool caGenerationTool;
    private final X509Certificate certificate;

    CommonIdentity(CAGenerationTool caGenerationTool, X509Certificate certificate) {
        this.caGenerationTool = caGenerationTool;
        this.certificate = certificate;
    }

    public X509Certificate getCertificate() {
        this.caGenerationTool.assertNotClosed();
        return this.certificate;
    }

    public String getKeyStoreType() {
        return this.caGenerationTool.getKeyStoreType();
    }

    public abstract KeyStore loadKeyStore();

    public abstract File getKeyStoreFile();

    public X509ExtendedKeyManager createKeyManager() {
        this.caGenerationTool.assertNotClosed();
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(this.loadKeyStore(), CAGenerationTool.PASSWORD);
            for (KeyManager current : keyManagerFactory.getKeyManagers()) {
                if (!(current instanceof X509ExtendedKeyManager)) continue;
                return (X509ExtendedKeyManager)current;
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalStateException("Unable to obtain X509ExtendedKeyManager.", e);
        }
        throw new IllegalStateException("Unable to obtain X509ExtendedKeyManager.");
    }
}

