/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.KeyStoreBackedSecurityRealm;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.keystore.WildFlyElytronKeyStoreProvider;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.interfaces.BCryptPassword;
import org.wildfly.security.password.interfaces.UnixMD5CryptPassword;

public class KeyStoreBackedSecurityRealmTest {
    private static final Provider[] providers = new Provider[]{WildFlyElytronKeyStoreProvider.getInstance(), WildFlyElytronPasswordProvider.getInstance()};

    @BeforeClass
    public static void register() {
        for (Provider provider : providers) {
            Security.addProvider(provider);
        }
    }

    @AfterClass
    public static void remove() {
        for (Provider provider : providers) {
            Security.removeProvider(provider.getName());
        }
    }

    @Test
    public void testPasswordFileKeyStore() throws Exception {
        InputStream stream = this.getClass().getResourceAsStream("passwd");
        KeyStore keyStore = KeyStore.getInstance("PasswordFile");
        keyStore.load(stream, null);
        Assert.assertEquals((String)"Invalid number of keystore entries", (long)2L, (long)keyStore.size());
        KeyStoreBackedSecurityRealm realm = new KeyStoreBackedSecurityRealm(keyStore);
        RealmIdentity realmIdentity = realm.getRealmIdentity((Principal)new NamePrincipal("elytron"));
        Assert.assertEquals((String)"Invalid credential support", (Object)SupportLevel.SUPPORTED, (Object)realmIdentity.getCredentialAcquireSupport(PasswordCredential.class, "crypt-md5", null));
        Assert.assertEquals((String)"Invalid credential support", (Object)SupportLevel.UNSUPPORTED, (Object)realmIdentity.getCredentialAcquireSupport(PasswordCredential.class, "bcrypt", null));
        Password password = ((PasswordCredential)realmIdentity.getCredential(PasswordCredential.class, null)).getPassword();
        Assert.assertNotNull((String)"Invalid null password", (Object)password);
        Assert.assertTrue((String)"Invalid password type", (boolean)(password instanceof UnixMD5CryptPassword));
        Assert.assertTrue((String)"Error validating credential", (boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("passwd12#$".toCharArray())));
        Assert.assertFalse((String)"Error validating credential", (boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("wrongpass".toCharArray())));
        realmIdentity = realm.getRealmIdentity((Principal)new NamePrincipal("javajoe"));
        Assert.assertEquals((String)"Invalid credential support", (Object)SupportLevel.SUPPORTED, (Object)realmIdentity.getCredentialAcquireSupport(PasswordCredential.class, "bcrypt", null));
        Assert.assertEquals((String)"Invalid credential support", (Object)SupportLevel.UNSUPPORTED, (Object)realmIdentity.getCredentialAcquireSupport(PasswordCredential.class, "crypt-md5", null));
        password = ((PasswordCredential)realmIdentity.getCredential(PasswordCredential.class, null)).getPassword();
        Assert.assertNotNull((String)"Invalid null password", (Object)password);
        Assert.assertTrue((String)"Invalid password type", (boolean)(password instanceof BCryptPassword));
        Assert.assertTrue((String)"Error validating credential", (boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("$#21pass".toCharArray())));
        Assert.assertFalse((String)"Error validating credential", (boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("wrongpass".toCharArray())));
    }
}

