/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.function.Supplier;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.auth.util.ElytronAuthenticator;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;

public class ElytronAuthenticatorTest {
    private static final int SERVER_PORT = 50831;
    private MockWebServer server;

    @Before
    public void onBefore() throws Exception {
        this.server = new MockWebServer();
        this.server.setDispatcher(new Dispatcher(){

            public MockResponse dispatch(RecordedRequest recordedRequest) throws InterruptedException {
                String authorization = recordedRequest.getHeader("Authorization");
                if (authorization == null) {
                    return new MockResponse().setResponseCode(401).addHeader("WWW-Authenticate", (Object)"Basic realm=elytron.org");
                }
                return new MockResponse().setBody(authorization);
            }
        });
        this.server.start(50831);
    }

    @After
    public void onAfter() throws Exception {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    @Test
    public void testBasicAuthentication() throws Exception {
        String userName = "elytron";
        AuthenticationConfiguration configuration = AuthenticationConfiguration.empty().useName(userName);
        String userPassword = "dont_tell_me";
        AuthenticationContext context = AuthenticationContext.captureCurrent().with(MatchRule.ALL, configuration.usePassword(this.createPassword(configuration, userPassword)));
        String response = (String)context.run(() -> {
            Authenticator.setDefault((Authenticator)new ElytronAuthenticator());
            HttpURLConnection connection = (HttpURLConnection)HttpURLConnection.class.cast(new URL("http://localhost:50831").openConnection());
            try (InputStream inputStream = connection.getInputStream();){
                String string = new BufferedReader(new InputStreamReader(inputStream)).lines().findFirst().orElse(null);
                return string;
            }
        });
        Assert.assertEquals((Object)("Basic " + CodePointIterator.ofString((String)(userName + ":" + userPassword)).asUtf8().base64Encode().drainToString()), (Object)response);
    }

    private Password createPassword(AuthenticationConfiguration configuration, String userPassword) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PasswordFactory factory = PasswordFactory.getInstance((String)"clear", (Supplier)((AuthenticationContextConfigurationClient)AuthenticationContextConfigurationClient.ACTION.run()).getProviderSupplier(configuration));
        return factory.generatePassword((KeySpec)new ClearPasswordSpec(userPassword.toCharArray()));
    }
}

