/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.pem.Pem;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;
import org.wildfly.security.x500.cert.X509CertificateBuilder;

public class PemTest {
    private SelfSignedX509CertificateAndSigningKey createIssuerCertificate() {
        X500Principal DN = new X500Principal("O=Root Certificate Authority, EMAILADDRESS=elytron@wildfly.org, C=UK, ST=Elytron, CN=Elytron CA");
        SelfSignedX509CertificateAndSigningKey certificate = SelfSignedX509CertificateAndSigningKey.builder().setDn(DN).setKeyAlgorithmName("RSA").setSignatureAlgorithmName("SHA256withRSA").addExtension(false, "BasicConstraints", "CA:true,pathlen:2147483647").build();
        return certificate;
    }

    private X509Certificate createSubjectCertificate(SelfSignedX509CertificateAndSigningKey issuerCertificate) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        KeyPair generatedKeys = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = generatedKeys.getPublic();
        X500Principal issuerDN = new X500Principal("O=Root Certificate Authority, EMAILADDRESS=elytron@wildfly.org, C=UK, ST=Elytron, CN=Elytron CA");
        X500Principal subjectDN = new X500Principal("O=Elytron, OU=Elytron, C=UK, ST=Elytron, CN=Firefly");
        X509Certificate subjectCertificate = new X509CertificateBuilder().setIssuerDn(issuerDN).setSubjectDn(subjectDN).setSignatureAlgorithmName("SHA256withRSA").setSigningKey(issuerCertificate.getSigningKey()).setPublicKey(publicKey).build();
        return subjectCertificate;
    }

    private byte[] createPemAsBytes(X509Certificate certificate) {
        ByteStringBuilder target = new ByteStringBuilder();
        Pem.generatePemX509Certificate((ByteStringBuilder)target, (X509Certificate)certificate);
        return target.toArray();
    }

    @Test
    public void testEncodeDecodeRSAPublicKey() throws Exception {
        this.assertParsing(KeyPairGenerator.getInstance("RSA").generateKeyPair().getPublic());
    }

    @Test
    public void testEncodeDecodeDSAPublicKey() throws Exception {
        this.assertParsing(KeyPairGenerator.getInstance("DSA").generateKeyPair().getPublic());
    }

    @Test
    public void testEncodeDecodeECPublicKey() throws Exception {
        this.assertParsing(KeyPairGenerator.getInstance("EC").generateKeyPair().getPublic());
    }

    @Test
    public void testParsePemX509Certificate01() throws Exception {
        SelfSignedX509CertificateAndSigningKey issuerCertificate = this.createIssuerCertificate();
        X509Certificate subjectCertificate = this.createSubjectCertificate(issuerCertificate);
        byte[] pemBytes = this.createPemAsBytes(subjectCertificate);
        Assert.assertNotNull((Object)Pem.parsePemX509Certificate((CodePointIterator)CodePointIterator.ofUtf8Bytes((byte[])pemBytes)));
    }

    @Test
    public void testParsePemX509CertificateCacert() throws Exception {
        SelfSignedX509CertificateAndSigningKey certificate = this.createIssuerCertificate();
        byte[] pemBytes = this.createPemAsBytes(certificate.getSelfSignedCertificate());
        Assert.assertNotNull((Object)Pem.parsePemX509Certificate((CodePointIterator)CodePointIterator.ofUtf8Bytes((byte[])pemBytes)));
    }

    private void assertParsing(PublicKey publicKey) {
        ByteStringBuilder publicKeyPem = new ByteStringBuilder();
        Pem.generatePemPublicKey((ByteStringBuilder)publicKeyPem, (PublicKey)publicKey);
        PublicKey parsedKey = Pem.parsePemPublicKey((CodePointIterator)CodePointIterator.ofUtf8Bytes((byte[])publicKeyPem.toArray()));
        Assert.assertNotNull((Object)parsedKey);
        Assert.assertArrayEquals((byte[])publicKey.getEncoded(), (byte[])parsedKey.getEncoded());
    }

    @Test
    public void testGeneratePemX509Certificate() throws Exception {
        String expectedPemCertificate = "-----BEGIN CERTIFICATE-----" + System.lineSeparator() + "MIIDjTCCAnWgAwIBAgIJANOjc2u+sqarMA0GCSqGSIb3DQEBBQUAMH0xEzARBgNV" + System.lineSeparator() + "BAMMCkVseXRyb24gQ0ExEDAOBgNVBAgMB0VseXRyb24xCzAJBgNVBAYTAlVLMSIw" + System.lineSeparator() + "IAYJKoZIhvcNAQkBFhNlbHl0cm9uQHdpbGRmbHkub3JnMSMwIQYDVQQKDBpSb290" + System.lineSeparator() + "IENlcnRpZmljYXRlIEF1dGhvcml0eTAeFw0xNjAxMjgxOTA3MTRaFw0yNjAxMjUx" + System.lineSeparator() + "OTA3MTRaMH0xEzARBgNVBAMMCkVseXRyb24gQ0ExEDAOBgNVBAgMB0VseXRyb24x" + System.lineSeparator() + "CzAJBgNVBAYTAlVLMSIwIAYJKoZIhvcNAQkBFhNlbHl0cm9uQHdpbGRmbHkub3Jn" + System.lineSeparator() + "MSMwIQYDVQQKDBpSb290IENlcnRpZmljYXRlIEF1dGhvcml0eTCCASIwDQYJKoZI" + System.lineSeparator() + "hvcNAQEBBQADggEPADCCAQoCggEBANid0js/NWlA8HUtysx/AWHy/u8bnifacoGO" + System.lineSeparator() + "FjozbfElfSa601CATKp1eGqV0B6s179XuIj6UMwJqK6oM05eFZm353Tt7+G5C2/u" + System.lineSeparator() + "gaU7HW9hMVf91Si3OK6CunK9EWj19OrUBx7eO376cwPUulCs51puTKAjezMCKbTS" + System.lineSeparator() + "RJPdPwZiB/I+LqZdopa2eQgQzsJqIGf93YWjpX3UHnqObuvaieUdTIyM89LR1Vej" + System.lineSeparator() + "rASdz5aWD62A5si/gl4t+1pRywDiFkQ8PWhLkm7QIoainchF2UtsSOZgG5aKqtd9" + System.lineSeparator() + "c63N+3uwxMP5qSf0UoYJiQ925mjlNKoUOWj27fQAqMvV9EX2NLkCAwEAAaMQMA4w" + System.lineSeparator() + "DAYDVR0TBAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEA0mZZlY10nniGr3OLYZ5V" + System.lineSeparator() + "8QvlEShllrwg3KlKPU5Lk/U0zG1stYWGeorkmYIuyVevxrHCIYpEAf3fmbZRbZlC" + System.lineSeparator() + "lEE4gVK6QCISqbkdPQrgdPSEq7hyLt/Ays0RsRApiddMQ/humMxFZgIfYXPiA4c4" + System.lineSeparator() + "6pjjMKLbikcd1lKAmcJSynixFoThqn8gAOkHbZZ9+/S0Bi+HLt1gVnbAsmrKqtdi" + System.lineSeparator() + "14d/WJdpLxpUmgAA39oVl5oasG8ImIXnXIU7tyE9pNBDtfOcxwpF/Cnh6kqcGoHL" + System.lineSeparator() + "ArwwQuSo6w9fpOQ1AsbjTz4xnWHTPewWCfcfKS6qmEn93c0Dfs/FVc1f2QEXdsLH" + System.lineSeparator() + "Mg==" + System.lineSeparator() + "-----END CERTIFICATE-----" + System.lineSeparator();
        X509Certificate certificate = Pem.parsePemX509Certificate((CodePointIterator)CodePointIterator.ofString((String)expectedPemCertificate));
        ByteStringBuilder target = new ByteStringBuilder();
        Pem.generatePemX509Certificate((ByteStringBuilder)target, (X509Certificate)certificate);
        Assert.assertEquals((Object)expectedPemCertificate, (Object)new String(target.toArray(), StandardCharsets.UTF_8));
    }
}

