/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ldap;

import java.security.Permission;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.AggregateSecurityRealm;
import org.wildfly.security.auth.realm.LegacyPropertiesSecurityRealm;
import org.wildfly.security.auth.realm.ldap.AttributeMapping;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.ldap.AbstractAttributeMappingSuiteChild;
import org.wildfly.security.ldap.LdapTestSuite;
import org.wildfly.security.permission.PermissionVerifier;

public class RoleMappingSuiteChild
extends AbstractAttributeMappingSuiteChild {
    @Test
    public void testRoleMappingWithMemberOf() throws Exception {
        this.assertAttributes("userWithMemberOfRoles", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected a single attribute.", (long)1L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("Roles"), "roleByMemberOf");
        }, AttributeMapping.fromIdentity().from("memberOf").extractRdn("CN").to("Roles").build());
    }

    @Test
    public void testRoleMappingWithMemberOfAttribute() throws Exception {
        this.assertAttributes("userWithMemberOfRoles", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected a single attribute.", (long)1L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("Roles"), "roleByMemberOfDescription");
        }, AttributeMapping.fromReference((String)"memberOf").from("description").to("Roles").build());
    }

    @Test
    public void testRoleMappingWithMemberOfRecursive() throws Exception {
        this.assertAttributes("userWithMemberOfRoles", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected a single attribute.", (long)1L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("Roles"), "roleByMemberOfDescription", "roleOfRoleByMemberOfDescription");
        }, AttributeMapping.fromReference((String)"memberOf").roleRecursion(3).from("description").to("Roles").build());
    }

    @Test
    public void testRoleMappingFromSpecificBaseDN() throws Exception {
        this.assertAttributes("userWithRoles", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected a single attribute.", (long)1L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("Roles"), "RoleFromRolesOu");
        }, AttributeMapping.fromFilter((String)"(&(objectClass=groupOfNames)(member={1}))").from("CN").searchDn("ou=Roles,dc=elytron,dc=wildfly,dc=org").to("Roles").build());
    }

    @Test
    public void testRoleMappingRecursiveFromBaseDN() throws Exception {
        this.assertAttributes("userWithRoles", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected a single attribute.", (long)1L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("Roles"), "RoleFromRolesOu", "RoleFromBaseDN");
        }, AttributeMapping.fromFilter((String)"(&(objectClass=groupOfNames)(member={1}))").from("CN").to("Roles").build());
    }

    @Test
    public void testRoleMappingNoRecursiveOnlyFromBaseDN() throws Exception {
        this.assertAttributes("userWithRoles", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected a single attribute.", (long)1L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("Roles"), "RoleFromBaseDN");
        }, AttributeMapping.fromFilter((String)"(&(objectClass=groupOfNames)(member={1}))").from("CN").to("Roles").searchRecursively(false).build());
    }

    @Test
    public void testRecursiveRoles() throws Exception {
        this.assertAttributes("jduke", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected a single attribute.", (long)1L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("Roles"), "R1", "R2");
        }, AttributeMapping.fromFilter((String)"(&(objectClass=groupOfNames)(member={1}))").from("cn").roleRecursion(1).to("Roles").build());
    }

    @Test
    public void testRecursiveRolesCycle() throws Exception {
        this.assertAttributes("jduke", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected a single attribute.", (long)1L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("Roles"), "R1", "R2", "R3");
        }, AttributeMapping.fromFilter((String)"(&(objectClass=groupOfNames)(member={1}))").from("cn").roleRecursion(10).to("Roles").build());
    }

    @Test
    public void testRecursiveRolesMoreWaysToOneRole() throws Exception {
        this.assertAttributes("ranvir", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected a single attribute.", (long)1L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("Roles"), "MWR1", "MWR2", "MWR3");
        }, AttributeMapping.fromFilter((String)"(&(objectClass=groupOfNames)(member={1}))").from("cn").roleRecursion(1).to("Roles").build());
    }

    @Test
    public void testRecursiveRolesByName() throws Exception {
        this.assertAttributes("falith", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected a single attribute.", (long)1L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("Roles"), "RN1", "RN2");
        }, AttributeMapping.fromFilter((String)"description={0}").from("cn").roleRecursionName("cn").roleRecursion(1).to("Roles").build());
    }

    @Test
    public void testAuthorizationWithDifferentAuthenticationRealm() throws Exception {
        SecurityDomain.Builder builder = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)new AggregateSecurityRealm((SecurityRealm)LegacyPropertiesSecurityRealm.builder().setUsersStream(this.getClass().getResourceAsStream("/org/wildfly/security/auth/realm/nonldap.properties")).setPlainText(true).build(), (SecurityRealm)LdapSecurityRealmBuilder.builder().setDirContextSupplier(LdapTestSuite.dirContextFactory.create()).identityMapping().setSearchDn("dc=elytron,dc=wildfly,dc=org").searchRecursive().setRdnIdentifier("uid").map(new AttributeMapping[]{AttributeMapping.fromFilter((String)"description={0}").from("cn").roleRecursionName("cn").roleRecursion(2).to("Roles").build()}).build().build())).build();
        builder.setPermissionMapper((permissionMappable, roles) -> PermissionVerifier.from((Permission)new LoginPermission()));
        this.assertAttributes(builder.build(), "hybridUser", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected a single attribute.", (long)1L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("Roles"), "RN3");
        });
    }
}

