/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.Collections;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.WildFlyElytronProvider;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.DistributedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;

public class DistributedSecurityRealmTest {
    private static final Provider provider = new WildFlyElytronProvider();
    SecurityRealm realm1;
    SecurityRealm realm2;
    SecurityRealm realm3;
    SecurityRealm evidenceRealm;
    char[] pass1 = "pass1".toCharArray();
    char[] pass2 = "pass2".toCharArray();
    char[] pass3 = "pass3".toCharArray();
    DistributedSecurityRealm realm;

    @BeforeClass
    public static void registerProvider() {
        Security.insertProviderAt(provider, 1);
    }

    @AfterClass
    public static void removeProvider() {
        Security.removeProvider(provider.getName());
    }

    @Before
    public void setup() throws Exception {
        this.realm1 = DistributedSecurityRealmTest.createRealmWithIdentity("user1", (Credential)DistributedSecurityRealmTest.createPasswordCredential(this.pass1));
        this.realm2 = DistributedSecurityRealmTest.createRealmWithIdentity("user2", (Credential)DistributedSecurityRealmTest.createPasswordCredential(this.pass2));
        this.realm3 = DistributedSecurityRealmTest.createRealmWithIdentity("user3", (Credential)DistributedSecurityRealmTest.createPasswordCredential(this.pass3));
        this.evidenceRealm = new SimpleEvidenceRealm();
        this.realm = new DistributedSecurityRealm(new SecurityRealm[]{this.realm1, this.realm2, this.evidenceRealm, this.realm3});
    }

    @Test
    public void testNoIdentity() throws Exception {
        RealmIdentity identity = this.realm.getRealmIdentity((Principal)new NamePrincipal("user4"));
        Assert.assertFalse((boolean)identity.exists());
    }

    @Test
    public void testExistingIdentity1() throws Exception {
        RealmIdentity identity = this.realm.getRealmIdentity((Principal)new NamePrincipal("user1"));
        Assert.assertTrue((boolean)identity.exists());
        PasswordCredential credential = (PasswordCredential)identity.getCredential(PasswordCredential.class);
        Assert.assertTrue((boolean)credential.verify((Evidence)new PasswordGuessEvidence(this.pass1)));
        Assert.assertFalse((boolean)credential.verify((Evidence)new PasswordGuessEvidence(this.pass2)));
        Assert.assertFalse((boolean)credential.verify((Evidence)new PasswordGuessEvidence(this.pass3)));
        identity.dispose();
    }

    @Test
    public void testExistingIdentity2() throws Exception {
        RealmIdentity identity = this.realm.getRealmIdentity((Principal)new NamePrincipal("user2"));
        Assert.assertTrue((boolean)identity.exists());
        PasswordCredential credential = (PasswordCredential)identity.getCredential(PasswordCredential.class);
        Assert.assertFalse((boolean)credential.verify((Evidence)new PasswordGuessEvidence(this.pass1)));
        Assert.assertTrue((boolean)credential.verify((Evidence)new PasswordGuessEvidence(this.pass2)));
        Assert.assertFalse((boolean)credential.verify((Evidence)new PasswordGuessEvidence(this.pass3)));
        identity.dispose();
    }

    @Test
    public void testExistingIdentity3() throws Exception {
        RealmIdentity identity = this.realm.getRealmIdentity((Principal)new NamePrincipal("user3"));
        Assert.assertTrue((boolean)identity.exists());
        PasswordCredential credential = (PasswordCredential)identity.getCredential(PasswordCredential.class);
        Assert.assertFalse((boolean)credential.verify((Evidence)new PasswordGuessEvidence(this.pass1)));
        Assert.assertFalse((boolean)credential.verify((Evidence)new PasswordGuessEvidence(this.pass2)));
        Assert.assertTrue((boolean)credential.verify((Evidence)new PasswordGuessEvidence(this.pass3)));
        identity.dispose();
    }

    @Test
    public void testEvidence() throws Exception {
        RealmIdentity identity = this.realm.getRealmIdentity((Evidence)new SimpleEvidence("evidenceUser", true));
        Assert.assertTrue((boolean)identity.exists());
        Assert.assertEquals((Object)identity.getRealmIdentityPrincipal(), (Object)new NamePrincipal("evidenceUser"));
        identity.dispose();
    }

    @Test
    public void testBadEvidence() throws Exception {
        RealmIdentity identity = this.realm.getRealmIdentity((Evidence)new SimpleEvidence("evidenceUser", false));
        Assert.assertFalse((boolean)identity.exists());
        identity.dispose();
    }

    private static PasswordCredential createPasswordCredential(char[] password) throws Exception {
        PasswordFactory pf = PasswordFactory.getInstance((String)"clear");
        ClearPasswordSpec ps = new ClearPasswordSpec(password);
        return new PasswordCredential(pf.generatePassword((KeySpec)ps));
    }

    private static SecurityRealm createRealmWithIdentity(String identityName, Credential identityCredential) {
        SimpleMapBackedSecurityRealm realm = new SimpleMapBackedSecurityRealm();
        if (identityName != null) {
            realm.setIdentityMap(Collections.singletonMap(identityName, new SimpleRealmEntry(Collections.singletonList(identityCredential))));
        } else {
            realm.setIdentityMap(Collections.EMPTY_MAP);
        }
        return realm;
    }

    private class SimpleEvidenceRealm
    implements SecurityRealm {
        private SimpleEvidenceRealm() {
        }

        public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
            return RealmIdentity.NON_EXISTENT;
        }

        public RealmIdentity getRealmIdentity(Evidence evidence) throws RealmUnavailableException {
            return evidence instanceof SimpleEvidence ? new SimpleEvidenceRealmIdentity((SimpleEvidence)evidence) : RealmIdentity.NON_EXISTENT;
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return SimpleEvidence.class.equals(evidenceType) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
        }

        private class SimpleEvidenceRealmIdentity
        implements RealmIdentity {
            private SimpleEvidence evidence;

            public SimpleEvidenceRealmIdentity(SimpleEvidence evidence) {
                this.evidence = evidence;
            }

            public Principal getRealmIdentityPrincipal() {
                return this.evidence.getPrincipal();
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                return SupportLevel.UNSUPPORTED;
            }

            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return null;
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return SimpleEvidence.class.equals(evidenceType) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
            }

            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                return evidence instanceof SimpleEvidence && ((SimpleEvidence)evidence).isValid();
            }

            public boolean exists() throws RealmUnavailableException {
                return this.evidence.isValid();
            }
        }
    }

    private class SimpleEvidence
    implements Evidence {
        private Principal principal;
        private boolean valid;

        public SimpleEvidence(String name, boolean valid) {
            this.principal = new NamePrincipal(name);
            this.valid = valid;
        }

        public boolean isValid() {
            return this.valid;
        }

        public Principal getPrincipal() {
            return this.principal;
        }
    }
}

