/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ldap;

import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.auth.realm.ldap.AttributeMapping;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.ldap.AbstractAttributeMappingSuiteChild;

public class AttributeMappingSuiteChild
extends AbstractAttributeMappingSuiteChild {
    @Test
    public void testSingleAttributeToSpecifiedName() throws Exception {
        this.assertAttributes("userWithAttributes", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected a single attribute.", (long)1L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("firstName"), "My First Name");
        }, AttributeMapping.fromIdentity().from("cn").to("firstName").build());
    }

    @Test
    public void testSingleAttributeToLdapName() throws Exception {
        this.assertAttributes("userWithAttributes", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected a single attribute.", (long)1L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("CN"), "My First Name");
        }, AttributeMapping.fromIdentity().from("cn").build());
    }

    @Test
    public void testMultipleAttributeMapping() throws Exception {
        this.assertAttributes("userWithAttributes", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected two attributes.", (long)2L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("CN"), "My First Name");
            this.assertAttributeValue(attributes.get("lastName"), "My Last Name");
        }, AttributeMapping.fromIdentity().from("cn").build(), AttributeMapping.fromIdentity().from("sn").to("lastName").build());
    }

    @Test
    public void testAttributeFromDifferentMappings() throws Exception {
        this.assertAttributes("userWithAttributes", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected one attribute.", (long)1L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("CN"), "My First Name", "My Last Name");
        }, AttributeMapping.fromIdentity().from("cn").build(), AttributeMapping.fromIdentity().from("sn").to("CN").build());
    }

    @Test
    public void testAttributeFilterRdn() throws Exception {
        this.assertAttributes("userWithRdnAttribute", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected one attribute.", (long)1L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("businessArea"), "Finance", "cn=Manager,ou=Sales,dc=elytron,dc=wildfly,dc=org");
        }, AttributeMapping.fromFilter((String)"(&(objectClass=groupOfNames)(member={1}))").searchDn("ou=Finance,dc=elytron,dc=wildfly,dc=org").extractRdn("OU").to("businessArea").build(), AttributeMapping.fromFilter((String)"(&(objectClass=groupOfNames)(member={1}))").searchDn("ou=Sales,dc=elytron,dc=wildfly,dc=org").to("businessArea").build());
    }

    @Test
    public void testAttributeFilterAttribute() throws Exception {
        this.assertAttributes("userWithRdnAttribute", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected one attribute.", (long)1L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("roles"), "Manager", "Manager");
            Assert.assertEquals((String)"Expected two roles.", (long)2L, (long)attributes.get("roles").size());
        }, AttributeMapping.fromFilter((String)"(&(objectClass=groupOfNames)(member={1}))").from("cn").searchDn("ou=Finance,dc=elytron,dc=wildfly,dc=org").to("roles").build(), AttributeMapping.fromFilter((String)"(&(objectClass=groupOfNames)(member={1}))").from("cn").searchDn("ou=Sales,dc=elytron,dc=wildfly,dc=org").to("roles").build());
    }

    @Test
    public void testDnToSpecifiedAttribute() throws Exception {
        this.assertAttributes("userWithAttributes", (Attributes attributes) -> {
            Assert.assertEquals((String)"Expected a single attribute.", (long)1L, (long)attributes.size());
            this.assertAttributeValue(attributes.get("myDn"), "uid=userWithAttributes,dc=elytron,dc=wildfly,dc=org");
        }, AttributeMapping.fromIdentity().to("myDn").build());
    }
}

