/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.gssapi;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.security.sasl.gssapi.GssapiTestSuite;
import org.wildfly.security.sasl.gssapi.JaasUtil;
import org.wildfly.security.sasl.gssapi.SubjectWrappingSaslClient;
import org.wildfly.security.sasl.gssapi.SubjectWrappingSaslServer;
import org.wildfly.security.sasl.gssapi.WildFlyElytronSaslGssapiProvider;

@RunWith(value=Parameterized.class)
public class CommunicationSuiteChild {
    private static final String TEST_SERVER_1 = "test_server_1";
    private static final String SASL_CLIENT_FACTORY_GSSAPI = "SaslClientFactory.GSSAPI";
    private static final String SASL_SERVER_FACTORY_GSSAPI = "SaslServerFactory.GSSAPI";
    private static final String GSSAPI = "GSSAPI";
    private static final String QOP_AUTH = "auth";
    private static final String QOP_AUTH_INT = "auth-int";
    private static final String QOP_AUTH_CONF = "auth-conf";
    static final String SERVER_KEY_TAB = "serverKeyTab";
    static final String SERVER_UNBOUND_KEY_TAB = "serverUnboundKeyTab";
    private static final Provider wildFlyElytronProvider = WildFlyElytronSaslGssapiProvider.getInstance();
    private static Subject clientSubject;
    private static Subject serverSubject;
    private static Subject unboundServerSubject;
    @Parameterized.Parameter(value=0)
    public boolean serverElytron;
    @Parameterized.Parameter(value=1)
    public boolean clientElytron;
    @Parameterized.Parameter(value=2)
    public boolean authServer;
    @Parameterized.Parameter(value=3)
    public boolean unbound;
    @Parameterized.Parameter(value=4)
    public VerificationMode mode;

    @Parameterized.Parameters(name="serverElytron={0} clientElytron={1} authServer={2} unbound={3} mode={4}")
    public static Iterable<Object[]> serverElytron() {
        System.out.println("Parameters init");
        return Arrays.asList({true, true, false, false, VerificationMode.NONE}, {true, true, true, false, VerificationMode.NONE}, {true, true, false, false, VerificationMode.INTEGRITY}, {true, true, false, false, VerificationMode.CONFIDENTIALITY}, {true, true, false, true, VerificationMode.CONFIDENTIALITY}, {true, false, false, false, VerificationMode.NONE}, {true, false, true, false, VerificationMode.NONE}, {true, false, false, false, VerificationMode.INTEGRITY}, {true, false, false, false, VerificationMode.CONFIDENTIALITY}, {true, false, false, true, VerificationMode.CONFIDENTIALITY}, {false, true, false, false, VerificationMode.NONE}, {false, true, true, false, VerificationMode.NONE}, {false, true, false, false, VerificationMode.INTEGRITY}, {false, true, false, false, VerificationMode.CONFIDENTIALITY}, {false, true, false, true, VerificationMode.CONFIDENTIALITY}, {false, false, false, false, VerificationMode.NONE}, {false, false, true, false, VerificationMode.NONE}, {false, false, false, false, VerificationMode.INTEGRITY}, {false, false, false, false, VerificationMode.CONFIDENTIALITY}, {false, false, false, true, VerificationMode.CONFIDENTIALITY});
    }

    @BeforeClass
    public static void initialize() throws LoginException {
        clientSubject = JaasUtil.loginClient();
        serverSubject = JaasUtil.loginServer(GssapiTestSuite.serverKeyTab, false);
        unboundServerSubject = JaasUtil.loginServer(GssapiTestSuite.serverUnboundKeyTab, true);
        Assert.assertNotNull((Object)clientSubject);
        Assert.assertNotNull((Object)serverSubject);
        Assert.assertNotNull((Object)unboundServerSubject);
        AccessController.doPrivileged(() -> Security.insertProviderAt(wildFlyElytronProvider, 1));
    }

    @AfterClass
    public static void destroy() {
        clientSubject = null;
        serverSubject = null;
        unboundServerSubject = null;
        AccessController.doPrivileged(() -> {
            Security.removeProvider(wildFlyElytronProvider.getName());
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSasl() throws Exception {
        SaslClient client = this.getSaslClient();
        SaslServer server = this.getSaslServer();
        try {
            byte[] exchange = new byte[]{};
            while (!client.isComplete() || !server.isComplete()) {
                exchange = client.evaluateChallenge(exchange);
                if (server.isComplete()) continue;
                exchange = server.evaluateResponse(exchange);
            }
            Assert.assertTrue((boolean)client.isComplete());
            Assert.assertTrue((boolean)server.isComplete());
            Assert.assertEquals((String)"Authorization ID", (Object)"jduke@WILDFLY.ORG", (Object)server.getAuthorizationID());
            Assert.assertEquals((String)"Bound server name", (Object)TEST_SERVER_1, (Object)server.getNegotiatedProperty("javax.security.sasl.bound.server.name"));
            Assert.assertEquals((String)"Server QOP", (Object)this.mode.getQop(), (Object)server.getNegotiatedProperty("javax.security.sasl.qop"));
            Assert.assertEquals((String)"Client QOP", (Object)this.mode.getQop(), (Object)client.getNegotiatedProperty("javax.security.sasl.qop"));
            if (this.mode != VerificationMode.NONE) {
                Assert.assertEquals((String)"Server MAX_BUFFER", (Object)"64321", (Object)server.getNegotiatedProperty("javax.security.sasl.maxbuffer"));
                Assert.assertEquals((String)"Client MAX_BUFFER", (Object)"61234", (Object)client.getNegotiatedProperty("javax.security.sasl.maxbuffer"));
                int serverRawSize = Integer.parseInt((String)server.getNegotiatedProperty("javax.security.sasl.rawsendsize"));
                int clientRawSize = Integer.parseInt((String)client.getNegotiatedProperty("javax.security.sasl.rawsendsize"));
                Assert.assertTrue((String)"Server RAW_SEND_SIZE", (61000 < serverRawSize && serverRawSize < 61234 ? 1 : 0) != 0);
                Assert.assertTrue((String)"Client RAW_SEND_SIZE", (64000 < clientRawSize && clientRawSize < 64321 ? 1 : 0) != 0);
                this.testDataExchange(client, server);
            }
        }
        finally {
            try {
                client.dispose();
                server.dispose();
            }
            catch (SaslException e) {
                e.printStackTrace();
            }
        }
    }

    private void testDataExchange(SaslClient client, SaslServer server) throws SaslException {
        byte[] original = "Some Test Data".getBytes(StandardCharsets.UTF_8);
        byte[] backup = "Some Test Data".getBytes(StandardCharsets.UTF_8);
        byte[] wrappedFromClient = client.wrap(original, 0, original.length);
        Assert.assertTrue((String)"Original data unmodified", (boolean)Arrays.equals(backup, original));
        byte[] unwrappedFromClient = server.unwrap(wrappedFromClient, 0, wrappedFromClient.length);
        Assert.assertTrue((String)"Unwrapped (By Server) matched original", (boolean)Arrays.equals(unwrappedFromClient, original));
        byte[] wrappedFromServer = server.wrap(original, 0, original.length);
        Assert.assertTrue((String)"Original data unmodified", (boolean)Arrays.equals(backup, original));
        byte[] unwrappedFromServer = client.unwrap(wrappedFromServer, 0, wrappedFromServer.length);
        Assert.assertTrue((String)"Unwrapped (By Client) matched original", (boolean)Arrays.equals(unwrappedFromServer, original));
    }

    private SaslClient getSaslClient() throws Exception {
        SaslClient baseClient = Subject.doAs(clientSubject, this::createClient);
        return new SubjectWrappingSaslClient(baseClient, clientSubject);
    }

    private SaslServer getSaslServer() throws Exception {
        SaslServer baseServer = Subject.doAs(serverSubject, this::createServer);
        return new SubjectWrappingSaslServer(baseServer, this.unbound ? unboundServerSubject : serverSubject);
    }

    private SaslClient createClient() throws Exception {
        Provider provider = this.findProvider(SASL_CLIENT_FACTORY_GSSAPI, this.clientElytron);
        String factoryName = (String)provider.get(SASL_CLIENT_FACTORY_GSSAPI);
        SaslClientFactory factory = Class.forName(factoryName).asSubclass(SaslClientFactory.class).newInstance();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("javax.security.sasl.server.authentication", Boolean.toString(this.authServer));
        props.put("javax.security.sasl.qop", this.mode.getQop());
        props.put("javax.security.sasl.maxbuffer", Integer.toString(61234));
        if (this.clientElytron && !this.serverElytron) {
            props.put("wildfly.sasl.relax-compliance", Boolean.TRUE.toString());
        }
        return factory.createSaslClient(new String[]{GSSAPI}, null, "sasl", TEST_SERVER_1, props, new NoCallbackHandler());
    }

    private SaslServer createServer() throws Exception {
        Provider provider = this.findProvider(SASL_SERVER_FACTORY_GSSAPI, this.serverElytron);
        String factoryName = (String)provider.get(SASL_SERVER_FACTORY_GSSAPI);
        SaslServerFactory factory = Class.forName(factoryName).asSubclass(SaslServerFactory.class).newInstance();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("javax.security.sasl.qop", this.mode.getQop());
        props.put("javax.security.sasl.maxbuffer", Integer.toString(64321));
        if (!this.clientElytron && this.serverElytron) {
            props.put("wildfly.sasl.relax-compliance", Boolean.TRUE.toString());
        }
        return factory.createSaslServer(GSSAPI, "sasl", this.unbound ? null : TEST_SERVER_1, props, new AuthorizeOnlyCallbackHandler());
    }

    private Provider findProvider(String filter, boolean elytronProvider) {
        Provider[] providers;
        for (Provider current : providers = Security.getProviders(filter)) {
            if (!(current instanceof WildFlyElytronSaslGssapiProvider ? elytronProvider : !elytronProvider)) continue;
            return current;
        }
        return null;
    }

    private class AuthorizeOnlyCallbackHandler
    implements CallbackHandler {
        private AuthorizeOnlyCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (!(current instanceof AuthorizeCallback)) {
                    throw new UnsupportedCallbackException(current);
                }
                AuthorizeCallback ac = (AuthorizeCallback)current;
                ac.setAuthorized(ac.getAuthorizationID().equals(ac.getAuthenticationID()));
            }
        }
    }

    private class NoCallbackHandler
    implements CallbackHandler {
        private NoCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            throw new UnsupportedCallbackException(callbacks[0]);
        }
    }

    static enum VerificationMode {
        NONE("auth"),
        INTEGRITY("auth-int"),
        CONFIDENTIALITY("auth-conf");

        private final String qop;

        private VerificationMode(String qop) {
            this.qop = qop;
        }

        String getQop() {
            return this.qop;
        }
    }
}

