/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.oauth2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.Permission;
import java.security.Permissions;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import mockit.Mock;
import mockit.MockUp;
import mockit.integration.junit4.JMockit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.AggregateSecurityRealm;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.realm.token.TokenSecurityRealm;
import org.wildfly.security.auth.realm.token.TokenValidator;
import org.wildfly.security.auth.realm.token.validator.OAuth2IntrospectValidator;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.util.RegexNameRewriter;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.BearerTokenCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.sasl.oauth2.OAuth2SaslClientFactory;
import org.wildfly.security.sasl.oauth2.OAuth2SaslServerFactory;
import org.wildfly.security.sasl.oauth2.WildFlyElytronSaslOAuth2Provider;
import org.wildfly.security.sasl.test.SaslServerBuilder;
import org.wildfly.security.sasl.test.SaslTestUtil;
import org.wildfly.security.sasl.util.AbstractSaslParticipant;

@RunWith(value=JMockit.class)
public class OAuth2SaslTest {
    private static final Provider provider = WildFlyElytronSaslOAuth2Provider.getInstance();

    @BeforeClass
    public static void registerProvider() {
        Security.insertProviderAt(provider, 1);
    }

    @AfterClass
    public static void removeProvider() {
        Security.removeProvider(provider.getName());
    }

    @Test
    public void testQueryMechanisms() {
        SaslServerFactory serverFactory = SaslTestUtil.obtainSaslServerFactory(OAuth2SaslServerFactory.class);
        String[] mechanismNames = serverFactory.getMechanismNames(Collections.emptyMap());
        Assert.assertEquals((long)1L, (long)mechanismNames.length);
        Assert.assertEquals((Object)"OAUTHBEARER", (Object)mechanismNames[0]);
    }

    @Test
    public void testAbstractMessageFlow() throws Exception {
        SaslClientFactory saslClientFactory = SaslTestUtil.obtainSaslClientFactory(OAuth2SaslClientFactory.class);
        Assert.assertNotNull((String)"OAuth2SaslClientFactory not found", (Object)saslClientFactory);
        SaslClient saslClient = saslClientFactory.createSaslClient(new String[]{"OAUTHBEARER"}, "user", "imap", "resourceserver.com", Collections.emptyMap(), new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (!(callback instanceof CredentialCallback)) continue;
                    CredentialCallback credentialCallback = (CredentialCallback)callback;
                    JsonObjectBuilder tokenBuilder = Json.createObjectBuilder();
                    tokenBuilder.add("active", true);
                    tokenBuilder.add("username", "elytron@jboss.org");
                    credentialCallback.setCredential((Credential)new BearerTokenCredential(tokenBuilder.build().toString()));
                }
            }
        });
        Assert.assertNotNull((String)"OAuth2SaslClient is null", (Object)saslClient);
        SaslServer saslServer = new SaslServerBuilder(OAuth2SaslServerFactory.class, "OAUTHBEARER").setServerName("resourceserver.com").setProtocol("imap").addRealm("oauth-realm", this.createSecurityRealmMock()).setDefaultRealmName("oauth-realm").build();
        byte[] message = AbstractSaslParticipant.NO_BYTES;
        while ((message = saslClient.evaluateChallenge(message)) != null && (message = saslServer.evaluateResponse(message)) != null) {
        }
        Assert.assertTrue((boolean)saslServer.isComplete());
        Assert.assertTrue((boolean)saslClient.isComplete());
    }

    @Test
    public void testSuccessfulWithoutAuthorizationId() throws Exception {
        SaslClientFactory saslClientFactory = SaslTestUtil.obtainSaslClientFactory(OAuth2SaslClientFactory.class);
        Assert.assertNotNull((String)"OAuth2SaslClientFactory not found", (Object)saslClientFactory);
        SaslClient saslClient = saslClientFactory.createSaslClient(new String[]{"OAUTHBEARER"}, null, "imap", "resourceserver.com", Collections.emptyMap(), new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (!(callback instanceof CredentialCallback)) continue;
                    CredentialCallback credentialCallback = (CredentialCallback)callback;
                    JsonObjectBuilder tokenBuilder = Json.createObjectBuilder();
                    tokenBuilder.add("active", true);
                    tokenBuilder.add("username", "elytron@jboss.org");
                    credentialCallback.setCredential((Credential)new BearerTokenCredential(tokenBuilder.build().toString()));
                }
            }
        });
        Assert.assertNotNull((String)"OAuth2SaslClient is null", (Object)saslClient);
        SaslServer saslServer = new SaslServerBuilder(OAuth2SaslServerFactory.class, "OAUTHBEARER").setServerName("resourceserver.com").setProtocol("imap").addRealm("oauth-realm", this.createSecurityRealmMock()).setDefaultRealmName("oauth-realm").build();
        byte[] message = AbstractSaslParticipant.NO_BYTES;
        while ((message = saslClient.evaluateChallenge(message)) != null && (message = saslServer.evaluateResponse(message)) != null) {
        }
        Assert.assertTrue((boolean)saslServer.isComplete());
        Assert.assertTrue((boolean)saslClient.isComplete());
    }

    @Test
    public void testSuccessfulAuthorizationWithAggregateRealmWithoutPrincipalTransformer() throws Exception {
        this.testSuccessfulAuthorizationWithAggregateRealm(false);
    }

    @Test
    public void testSuccessfulAuthorizationWithAggregateRealmWithPrincipalTransformer() throws Exception {
        this.testSuccessfulAuthorizationWithAggregateRealm(true);
    }

    private void testSuccessfulAuthorizationWithAggregateRealm(boolean usePrincipalTransformer) throws Exception {
        SaslClientFactory saslClientFactory = SaslTestUtil.obtainSaslClientFactory(OAuth2SaslClientFactory.class);
        Assert.assertNotNull((String)"OAuth2SaslClientFactory not found", (Object)saslClientFactory);
        SaslClient saslClient = saslClientFactory.createSaslClient(new String[]{"OAUTHBEARER"}, null, "imap", "resourceserver.com", Collections.emptyMap(), new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (!(callback instanceof CredentialCallback)) continue;
                    CredentialCallback credentialCallback = (CredentialCallback)callback;
                    JsonObjectBuilder tokenBuilder = Json.createObjectBuilder();
                    tokenBuilder.add("active", true);
                    tokenBuilder.add("username", "elytron@jboss.org");
                    credentialCallback.setCredential((Credential)new BearerTokenCredential(tokenBuilder.build().toString()));
                }
            }
        });
        Assert.assertNotNull((String)"OAuth2SaslClient is null", (Object)saslClient);
        Permissions permissions = new Permissions();
        permissions.add((Permission)new LoginPermission());
        SaslServer saslServer = new SaslServerBuilder(OAuth2SaslServerFactory.class, "OAUTHBEARER").setServerName("resourceserver.com").setProtocol("imap").addRealm("oauth-realm", this.createAggregateSecurityRealmMock(usePrincipalTransformer)).setDefaultRealmName("oauth-realm").setPermissionsMap(Collections.singletonMap("admin", permissions)).build();
        byte[] message = AbstractSaslParticipant.NO_BYTES;
        while ((message = saslClient.evaluateChallenge(message)) != null && (message = saslServer.evaluateResponse(message)) != null) {
        }
        Assert.assertTrue((boolean)saslServer.isComplete());
        Assert.assertTrue((boolean)saslClient.isComplete());
    }

    @Test
    public void testFailedAuthenticationFlow() throws Exception {
        SaslClientFactory saslClientFactory = SaslTestUtil.obtainSaslClientFactory(OAuth2SaslClientFactory.class);
        Assert.assertNotNull((String)"OAuth2SaslClientFactory not found", (Object)saslClientFactory);
        SaslClient saslClient = saslClientFactory.createSaslClient(new String[]{"OAUTHBEARER"}, "user", "imap", "resourceserver.com", Collections.emptyMap(), new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (!(callback instanceof CredentialCallback)) continue;
                    CredentialCallback credentialCallback = (CredentialCallback)callback;
                    JsonObjectBuilder tokenBuilder = Json.createObjectBuilder();
                    tokenBuilder.add("active", false);
                    credentialCallback.setCredential((Credential)new BearerTokenCredential(tokenBuilder.build().toString()));
                }
            }
        });
        Assert.assertNotNull((String)"OAuth2SaslClient is null", (Object)saslClient);
        HashMap<String, Object> saslServerConfig = new HashMap<String, Object>();
        saslServerConfig.put("openid-configuration", "http://as.test.org/oauth2/.well-known/openid-configuration");
        SaslServer saslServer = new SaslServerBuilder(OAuth2SaslServerFactory.class, "OAUTHBEARER").setServerName("resourceserver.com").setProperties(saslServerConfig).setProtocol("imap").addRealm("oauth-realm", this.createSecurityRealmMock()).setDefaultRealmName("oauth-realm").build();
        byte[] message = AbstractSaslParticipant.NO_BYTES;
        message = saslClient.evaluateChallenge(message);
        Assert.assertNotNull((Object)message);
        message = saslServer.evaluateResponse(message);
        byte[] serverErrorMessage = message;
        Assert.assertNotNull((Object)message);
        message = saslClient.evaluateChallenge(message);
        Assert.assertNotNull((Object)message);
        try {
            saslServer.evaluateResponse(message);
            Assert.fail((String)"Expected SaslException not thrown");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)saslServer.isComplete());
        Assert.assertFalse((boolean)saslClient.isComplete());
        Assert.assertEquals((Object)"{\"status\":\"invalid_token\",\"openid-configuration\":\"http://as.test.org/oauth2/.well-known/openid-configuration\"}", (Object)new String(CodePointIterator.ofUtf8Bytes((byte[])serverErrorMessage).base64Decode().drain()));
    }

    private SecurityRealm createSecurityRealmMock() throws MalformedURLException {
        this.configureReplayTokenIntrospectionEndpoint();
        return TokenSecurityRealm.builder().validator((TokenValidator)OAuth2IntrospectValidator.builder().clientId("wildfly-elytron").clientSecret("dont_tell_me").tokenIntrospectionUrl(new URL("http://as.test.org/oauth2/token/introspect")).build()).build();
    }

    private SecurityRealm createAggregateSecurityRealmMock(boolean usePrincipalTransformer) throws Exception {
        this.configureReplayTokenIntrospectionEndpoint();
        TokenSecurityRealm authenticationRealm = TokenSecurityRealm.builder().validator((TokenValidator)OAuth2IntrospectValidator.builder().clientId("wildfly-elytron").clientSecret("dont_tell_me").tokenIntrospectionUrl(new URL("http://as.test.org/oauth2/token/introspect")).build()).build();
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 1);
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal(usePrincipalTransformer ? "elytron" : "elytron@jboss.org"));
        newIdentity.create();
        MapAttributes newAttributes = new MapAttributes();
        newAttributes.addAll("roles", Arrays.asList("admin"));
        newIdentity.setAttributes((Attributes)newAttributes);
        newIdentity.dispose();
        FileSystemSecurityRealm authorizationRealm = new FileSystemSecurityRealm(this.getRootPath(false), 1);
        return usePrincipalTransformer ? new AggregateSecurityRealm((SecurityRealm)authenticationRealm, (Function)new RegexNameRewriter(Pattern.compile("(.*)@jboss\\.org"), "$1", true).asPrincipalRewriter(), new SecurityRealm[]{authorizationRealm}) : new AggregateSecurityRealm((SecurityRealm)authenticationRealm, (SecurityRealm)authorizationRealm);
    }

    private Path getRootPath(boolean deleteIfExists) throws Exception {
        Path rootPath = Paths.get(this.getClass().getResource(File.separator).toURI()).resolve("filesystem-realm");
        if (rootPath.toFile().exists() && !deleteIfExists) {
            return rootPath;
        }
        return Files.walkFileTree(Files.createDirectories(rootPath, new FileAttribute[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private Path getRootPath() throws Exception {
        return this.getRootPath(true);
    }

    private void configureReplayTokenIntrospectionEndpoint() {
        Class<?> classToMock;
        try {
            classToMock = Class.forName("org.wildfly.security.auth.realm.token.validator.OAuth2IntrospectValidator", true, TokenSecurityRealm.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        new MockUp<Object>(classToMock){

            @Mock
            public JsonObject introspectAccessToken(URL tokenIntrospectionUrl, String clientId, String clientSecret, String token, SSLContext sslContext, HostnameVerifier hostnameVerifier) throws IOException {
                return Json.createReader((InputStream)new ByteArrayInputStream(token.getBytes())).readObject();
            }
        };
    }
}

