/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.scram;

import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.Permissions;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import mockit.Mock;
import mockit.MockUp;
import mockit.integration.junit4.JMockit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.permission.RunAsPrincipalPermission;
import org.wildfly.security.mechanism.scram.ScramClient;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.sasl.scram.ScramSaslServerFactory;
import org.wildfly.security.sasl.scram.WildFlyElytronSaslScramProvider;
import org.wildfly.security.sasl.test.SaslServerBuilder;
import org.wildfly.security.sasl.test.SaslTestUtil;

@RunWith(value=JMockit.class)
public class ScramServerCompatibilityTest {
    private static final Provider provider = WildFlyElytronSaslScramProvider.getInstance();

    @BeforeClass
    public static void registerPasswordProvider() {
        Security.insertProviderAt(provider, 1);
    }

    @AfterClass
    public static void removePasswordProvider() {
        Security.removeProvider(provider.getName());
    }

    private void mockNonce(final String nonce) {
        Class<?> classToMock;
        try {
            classToMock = Class.forName("org.wildfly.security.mechanism.scram.ScramUtil", true, ScramClient.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        new MockUp<Object>(classToMock){

            @Mock
            public byte[] generateNonce(int length, Random random) {
                return nonce.getBytes(StandardCharsets.UTF_8);
            }
        };
    }

    @Test
    public void testRfc5802example() throws Exception {
        this.mockNonce("3rfcNHYJY1ZVvWVs7j");
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"scram-sha-1");
        Password password = ScramServerCompatibilityTest.getPassword("pencil", "QSXCR+Q6sek8bf92");
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setUserName("user").setPassword(password).build();
        byte[] message = "n,,n=user,r=fyko+d2lbbFgONRv9qkxdawL".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096", (Object)new String(message, StandardCharsets.UTF_8));
        message = "c=biws,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=v0X8v3Bz2T0CJGbJQyF0X+HI4Ts=".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"v=rmF9pqV8S7suAoZWja4dJRkFsKQ=", (Object)new String(message, StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)saslServer.isComplete());
        Assert.assertEquals((Object)"user", (Object)saslServer.getAuthorizationID());
    }

    private static Password getPassword(String password, String saltString) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"scram-sha-1");
        return passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec(password.toCharArray(), (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(4096, CodePointIterator.ofString((String)saltString).base64Decode().drain())));
    }

    @Test
    public void testBadUsername() throws Exception {
        this.mockNonce("3rfcNHYJY1ZVvWVs7j");
        Password password = ScramServerCompatibilityTest.getPassword("pencil", "QSXCR+Q6sek8bf92");
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setUserName("baduser").setPassword(password).build();
        byte[] message = "n,,n=user,r=fyko+d2lbbFgONRv9qkxdawL".getBytes(StandardCharsets.UTF_8);
        try {
            saslServer.evaluateResponse(message);
            Assert.fail((String)"SaslException not thrown");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)saslServer.isComplete());
    }

    @Test
    public void testBadPassword() throws Exception {
        this.mockNonce("3rfcNHYJY1ZVvWVs7j");
        Password password = ScramServerCompatibilityTest.getPassword("pen", "QSXCR+Q6sek8bf92");
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setUserName("user").setPassword(password).build();
        byte[] message = "n,,n=user,r=fyko+d2lbbFgONRv9qkxdawL".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096", (Object)new String(message, StandardCharsets.UTF_8));
        message = "c=biws,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=v0X8v3Bz2T0CJGbJQyF0X+HI4Ts=".getBytes(StandardCharsets.UTF_8);
        try {
            saslServer.evaluateResponse(message);
            Assert.fail((String)"SaslException not thrown");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)saslServer.isComplete());
    }

    @Test
    public void testAllowedAuthorizationId() throws Exception {
        this.mockNonce("3rfcNHYJY1ZVvWVs7j");
        HashMap<String, Password> passwordMap = new HashMap<String, Password>();
        passwordMap.put("admin", ScramServerCompatibilityTest.getPassword("pencil", "QSXCR+Q6sek8bf92"));
        passwordMap.put("user", ScramServerCompatibilityTest.getPassword("pen", "QSXCR+Q6sek8bf92"));
        Permissions permissions = new Permissions();
        permissions.add((Permission)new RunAsPrincipalPermission("user"));
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setPasswordInstanceMap(passwordMap).setProtocol("acap").setServerName("elwood.innosoft.com").setPermissionsMap(Collections.singletonMap("admin", permissions)).build();
        byte[] message = "n,a=user,n=admin,r=fyko+d2lbbFgONRv9qkxdawL".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096", (Object)new String(message, StandardCharsets.UTF_8));
        message = "c=bixhPXVzZXIs,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=sSem09WkghLJOV/Ma5LjIqUtoo8=".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"v=xzTfS758LckdRoQKN/ZFY/Bauxo=", (Object)new String(message, StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)saslServer.isComplete());
        Assert.assertEquals((Object)saslServer.getAuthorizationID(), (Object)"user");
    }

    @Test
    public void testUnallowedAuthorizationId() throws Exception {
        this.mockNonce("3rfcNHYJY1ZVvWVs7j");
        Password password = ScramServerCompatibilityTest.getPassword("pencil", "QSXCR+Q6sek8bf92");
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setUserName("admin").setPassword(password).setProtocol("acap").setServerName("elwood.innosoft.com").build();
        byte[] message = "n,a=user,n=admin,r=fyko+d2lbbFgONRv9qkxdawL".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096", (Object)new String(message, StandardCharsets.UTF_8));
        message = "c=bixhPXVzZXIs,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=sSem09WkghLJOV/Ma5LjIqUtoo8=".getBytes(StandardCharsets.UTF_8);
        try {
            saslServer.evaluateResponse(message);
            Assert.fail((String)"SaslException not thrown");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)saslServer.isComplete());
    }

    @Test
    public void testMismatchedAuthorizationId() throws Exception {
        this.mockNonce("3rfcNHYJY1ZVvWVs7j");
        Password password = ScramServerCompatibilityTest.getPassword("pencil", "QSXCR+Q6sek8bf92");
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setUserName("user").setPassword(password).build();
        byte[] message = "n,a=user,n=user,r=fyko+d2lbbFgONRv9qkxdawL".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096", (Object)new String(message, StandardCharsets.UTF_8));
        message = "c=bixhPWFkbWluLA==,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=NdEpo1qMJaCn9xyrYplfuEKubqQ=".getBytes(StandardCharsets.UTF_8);
        try {
            saslServer.evaluateResponse(message);
            Assert.fail((String)"SaslException not throwed");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)saslServer.isComplete());
    }

    @Test
    public void testMismatchedAuthorizationIdBlank() throws Exception {
        this.mockNonce("3rfcNHYJY1ZVvWVs7j");
        Password password = ScramServerCompatibilityTest.getPassword("pencil", "QSXCR+Q6sek8bf92");
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setUserName("user").setPassword(password).build();
        byte[] message = "n,a=user,n=user,r=fyko+d2lbbFgONRv9qkxdawL".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096", (Object)new String(message, StandardCharsets.UTF_8));
        message = "c=biws,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=v0X8v3Bz2T0CJGbJQyF0X+HI4Ts=".getBytes(StandardCharsets.UTF_8);
        try {
            saslServer.evaluateResponse(message);
            Assert.fail((String)"SaslException not throwed");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)saslServer.isComplete());
    }

    @Test
    public void testDifferentNonceAttack() throws Exception {
        this.mockNonce("differentNonceVs7j");
        Password password = ScramServerCompatibilityTest.getPassword("pencil", "QSXCR+Q6sek8bf92");
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setUserName("user").setPassword(password).build();
        byte[] message = "n,,n=user,r=fyko+d2lbbFgONRv9qkxdawL".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"r=fyko+d2lbbFgONRv9qkxdawLdifferentNonceVs7j,s=QSXCR+Q6sek8bf92,i=4096", (Object)new String(message, StandardCharsets.UTF_8));
        message = "c=biws,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=v0X8v3Bz2T0CJGbJQyF0X+HI4Ts=".getBytes(StandardCharsets.UTF_8);
        try {
            saslServer.evaluateResponse(message);
            Assert.fail((String)"SaslException not throwed");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)saslServer.isComplete());
    }

    @Test
    public void testStrangeCredentials() throws Exception {
        this.mockNonce("3rfcNHYJY1ZVvWVs7j");
        SaslServerFactory serverFactory = SaslTestUtil.obtainSaslServerFactory(ScramSaslServerFactory.class);
        Assert.assertNotNull((Object)serverFactory);
        HashMap<String, Password> passwordMap = new HashMap<String, Password>();
        passwordMap.put("strange=admin, \\\u0438\u4f60\ud83c\udca11\u20442 \u0301", ScramServerCompatibilityTest.getPassword("\"strange=admin=password, \\\\\\u0438\\u4F60\\uD83C\\uDCA1\\u00BD\\u00B4\"", "QSXCR+Q6sek8bf92"));
        passwordMap.put("strange=user, \\\u0438\u4f60\ud83c\udca11\u20442 \u0301", ScramServerCompatibilityTest.getPassword("strange=password, \\\u0438\u4f60\ud83c\udca1\u00bd\u00b4", "QSXCR+Q6sek8bf92"));
        Permissions permissions = new Permissions();
        permissions.add((Permission)new RunAsPrincipalPermission("strange=admin, \\\u0438\u4f60\ud83c\udca11\u20442 \u0301"));
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setProtocol("protocol").setPasswordInstanceMap(passwordMap).setPermissionsMap(Collections.singletonMap("strange=user, \\\u0438\u4f60\ud83c\udca11\u20442 \u0301", permissions)).build();
        byte[] message = "n,a=strange=3Dadmin=2C \\\u0438\u4f60\ud83c\udca11\u20442 \u0301,n=strange=3Duser=2C \\\u0438\u4f60\ud83c\udca1\u00bd\u00b4,r=fyko+d2lbbFgONRv9qkxdawL".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096", (Object)new String(message, StandardCharsets.UTF_8));
        message = "c=bixhPXN0cmFuZ2U9M0RhZG1pbj0yQyBc0LjkvaDwn4KhMeKBhDIgzIEs,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=ZWpaDThPD7OErOz+6Q+n9msNhMQ=".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"v=k1gWxds6QP4FdDqmsLtaxIl38NM=", (Object)new String(message, StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)saslServer.isComplete());
    }

    @Test
    public void testBindingCorrectY() throws Exception {
        this.mockNonce("3rfcNHYJY1ZVvWVs7j");
        Password password = ScramServerCompatibilityTest.getPassword("pencil", "QSXCR+Q6sek8bf92");
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setUserName("user").setPassword(password).build();
        byte[] message = "y,,n=user,r=fyko+d2lbbFgONRv9qkxdawL".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096", (Object)new String(message, StandardCharsets.UTF_8));
        message = "c=eSws,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=BjZF5dV+EkD3YCb3pH3IP8riMGw=".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"v=dsprQ5R2AGYt1kn4bQRwTAE0PTU=", (Object)new String(message, StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)saslServer.isComplete());
    }

    @Test
    public void testBindingIncorrectYWithServerChannelBinding() throws Exception {
        this.mockNonce("3rfcNHYJY1ZVvWVs7j");
        Password password = ScramServerCompatibilityTest.getPassword("pencil", "QSXCR+Q6sek8bf92");
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setUserName("user").setPassword(password).setChannelBinding("same-type", new byte[]{0, 44, -1}).build();
        byte[] message = "y,,n=user,r=fyko+d2lbbFgONRv9qkxdawL".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"e=server-does-support-channel-binding", (Object)new String(message, StandardCharsets.UTF_8));
        Assert.assertFalse((boolean)saslServer.isComplete());
    }

    @Test
    public void testBindingIncorrectNWithChannelBinding() throws Exception {
        this.mockNonce("3rfcNHYJY1ZVvWVs7j");
        Password password = ScramServerCompatibilityTest.getPassword("pencil", "QSXCR+Q6sek8bf92");
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1").setUserName("user").setPassword(password).setChannelBinding("same-type", new byte[]{0, 44, -1}).build();
        byte[] message = "n,,n=user,r=fyko+d2lbbFgONRv9qkxdawL".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"e=server-does-support-channel-binding", (Object)new String(message, StandardCharsets.UTF_8));
        Assert.assertFalse((boolean)saslServer.isComplete());
    }

    @Test
    public void testBindingIncorrectY() throws Exception {
        this.mockNonce("3rfcNHYJY1ZVvWVs7j");
        Password password = ScramServerCompatibilityTest.getPassword("pencil", "QSXCR+Q6sek8bf92");
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("wildfly.sasl.channel-binding-required", "true");
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1-PLUS").setUserName("user").setPassword(password).setChannelBinding("sameType", new byte[]{18, 44, 0}).setProperties(props).build();
        byte[] message = "y,,n=user,r=fyko+d2lbbFgONRv9qkxdawL".getBytes(StandardCharsets.UTF_8);
        Assert.assertEquals((Object)"e=server-does-support-channel-binding", (Object)new String(saslServer.evaluateResponse(message), StandardCharsets.UTF_8));
        Assert.assertFalse((boolean)saslServer.isComplete());
    }

    @Test
    public void testBindingCorrect() throws Exception {
        this.mockNonce("3rfcNHYJY1ZVvWVs7j");
        Password password = ScramServerCompatibilityTest.getPassword("pencil", "QSXCR+Q6sek8bf92");
        SaslServerFactory serverFactory = SaslTestUtil.obtainSaslServerFactory(ScramSaslServerFactory.class);
        Assert.assertNotNull((Object)serverFactory);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("wildfly.sasl.channel-binding-required", "true");
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1-PLUS").setUserName("user").setPassword(password).setChannelBinding("same-type", new byte[]{0, 44, -1}).setProperties(props).build();
        byte[] message = "p=same-type,,n=user,r=fyko+d2lbbFgONRv9qkxdawL".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096", (Object)new String(message, StandardCharsets.UTF_8));
        message = "c=cD1zYW1lLXR5cGUsLAAs/w==,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=H8mpU86Osa2lDJvFElvu7qys7LE=".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"v=/ubKPpiyDhhCsgGfHqY5Xm7msjM=", (Object)new String(message, StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)saslServer.isComplete());
    }

    @Test
    public void testBindingBadData() throws Exception {
        this.mockNonce("3rfcNHYJY1ZVvWVs7j");
        Password password = ScramServerCompatibilityTest.getPassword("pencil", "QSXCR+Q6sek8bf92");
        SaslServerFactory serverFactory = SaslTestUtil.obtainSaslServerFactory(ScramSaslServerFactory.class);
        Assert.assertNotNull((Object)serverFactory);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("wildfly.sasl.channel-binding-required", "true");
        SaslServer saslServer = new SaslServerBuilder(ScramSaslServerFactory.class, "SCRAM-SHA-1-PLUS").setUserName("user").setPassword(password).setChannelBinding("same-type", new byte[]{-103, -103}).setProperties(props).build();
        byte[] message = "p=same-type,,n=user,r=fyko+d2lbbFgONRv9qkxdawL".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096", (Object)new String(message, StandardCharsets.UTF_8));
        message = "c=cD1zYW1lLXR5cGUsLAAs/w==,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=H8mpU86Osa2lDJvFElvu7qys7LE=".getBytes(StandardCharsets.UTF_8);
        message = saslServer.evaluateResponse(message);
        Assert.assertEquals((Object)"e=channel-bindings-dont-match", (Object)new String(message, StandardCharsets.UTF_8));
        Assert.assertFalse((boolean)saslServer.isComplete());
    }
}

