/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.security.Principal;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

public class TestCallbackHandler
implements CallbackHandler {
    private Principal principal;
    private Evidence evidence;

    public void setSecurityInfo(Principal principal, Object evidence) {
        this.principal = principal;
        this.evidence = (Evidence)evidence;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        if (callbacks == null) {
            throw new IllegalArgumentException("The callbacks argument cannot be null");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callback;
                if (this.principal == null) continue;
                nameCallback.setName(this.principal.getName());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback)callback;
                if (!(this.evidence instanceof PasswordGuessEvidence)) continue;
                passwordCallback.setPassword(((PasswordGuessEvidence)this.evidence).getGuess());
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unsupported callback");
        }
    }
}

