/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.token;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.PlainHeader;
import com.nimbusds.jose.PlainObject;
import com.nimbusds.jose.crypto.RSASSASigner;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedHashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import mockit.integration.junit4.JMockit;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.QueueDispatcher;
import okhttp3.mockwebserver.RecordedRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.token.RsaJwk;
import org.wildfly.security.auth.realm.token.TokenSecurityRealm;
import org.wildfly.security.auth.realm.token.TokenValidator;
import org.wildfly.security.auth.realm.token.validator.JwtValidator;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.evidence.BearerTokenEvidence;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.pem.Pem;
import org.wildfly.security.ssl.SSLContextBuilder;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;

@RunWith(value=JMockit.class)
public class JwtSecurityRealmTest {
    private static final MockWebServer server = new MockWebServer();
    private static final MockWebServer nonTlsServer = new MockWebServer();
    private static final String CA_JKS_LOCATION = "./target/test-classes/jwt/ca/jks/";
    private static char[] PASSWORD = "password".toCharArray();
    private static KeyPair keyPair1;
    private static KeyPair keyPair2;
    private static KeyPair keyPair3;
    private static RsaJwk jwk1;
    private static RsaJwk jwk2;
    private static RsaJwk jwk3;
    private static File trustStoreFile;
    private static String jwksResponse;

    private static byte[] toBase64urlUInt(BigInteger bigInt) {
        int i;
        byte[] bytes = bigInt.toByteArray();
        for (i = 0; i < bytes.length && bytes[i] == 0; ++i) {
        }
        if (i > 0 && i < bytes.length) {
            return Arrays.copyOfRange(bytes, i, bytes.length);
        }
        return bytes;
    }

    @BeforeClass
    public static void setup() throws GeneralSecurityException, IOException {
        System.setProperty("wildfly.config.url", JwtSecurityRealmTest.class.getResource("wildfly-jwt-test-config.xml").toExternalForm());
        keyPair1 = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        keyPair2 = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        keyPair3 = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        RSAPublicKey pk1 = (RSAPublicKey)keyPair1.getPublic();
        RSAPublicKey pk2 = (RSAPublicKey)keyPair2.getPublic();
        RSAPublicKey pk3 = (RSAPublicKey)keyPair3.getPublic();
        jwk1.setAlg("RS256");
        jwk1.setKid("1");
        jwk1.setKty("RSA");
        jwk1.setE(Base64.getUrlEncoder().withoutPadding().encodeToString(JwtSecurityRealmTest.toBase64urlUInt(pk1.getPublicExponent())));
        jwk1.setN(Base64.getUrlEncoder().withoutPadding().encodeToString(JwtSecurityRealmTest.toBase64urlUInt(pk1.getModulus())));
        jwk2.setAlg("RS256");
        jwk2.setKid("2");
        jwk2.setKty("RSA");
        jwk2.setE(Base64.getUrlEncoder().withoutPadding().encodeToString(JwtSecurityRealmTest.toBase64urlUInt(pk2.getPublicExponent())));
        jwk2.setN(Base64.getUrlEncoder().withoutPadding().encodeToString(JwtSecurityRealmTest.toBase64urlUInt(pk2.getModulus())));
        jwk3.setAlg("RS256");
        jwk3.setKid("3");
        jwk3.setKty("RSA");
        jwk3.setE(Base64.getUrlEncoder().withoutPadding().encodeToString(JwtSecurityRealmTest.toBase64urlUInt(pk3.getPublicExponent())));
        jwk3.setN(Base64.getUrlEncoder().withoutPadding().encodeToString(JwtSecurityRealmTest.toBase64urlUInt(pk3.getModulus())));
        JsonObject jwks = JwtSecurityRealmTest.jwksToJson(jwk1, jwk2);
        File dir = new File(CA_JKS_LOCATION);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((trustStoreFile = new File("./target/test-classes/jwt/ca/jks/ca.truststore")).exists()) {
            trustStoreFile.delete();
        }
        KeyStore mockKeyStore = KeyStore.getInstance("JKS");
        KeyStore trustStore = KeyStore.getInstance("JKS");
        mockKeyStore.load(null, null);
        trustStore.load(null, null);
        String alg = KeyManagerFactory.getDefaultAlgorithm();
        SelfSignedX509CertificateAndSigningKey issuerSelfSignedX509CertificateAndSigningKey = SelfSignedX509CertificateAndSigningKey.builder().setDn(new X500Principal("CN=localhost, ST=Elytron, C=UK, EMAILADDRESS=elytron@wildfly.org, O=Root Certificate Authority")).setKeyAlgorithmName("RSA").setSignatureAlgorithmName("SHA256withRSA").addExtension(false, "BasicConstraints", "CA:true,pathlen:2147483647").build();
        X509Certificate issuerCertificate = issuerSelfSignedX509CertificateAndSigningKey.getSelfSignedCertificate();
        mockKeyStore.setKeyEntry("ca", issuerSelfSignedX509CertificateAndSigningKey.getSigningKey(), PASSWORD, new X509Certificate[]{issuerCertificate});
        trustStore.setCertificateEntry("ca", issuerCertificate);
        trustStore.store(new FileOutputStream(trustStoreFile), PASSWORD);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(alg);
        keyManagerFactory.init(mockKeyStore, PASSWORD);
        X509ExtendedKeyManager keyManager = null;
        for (KeyManager km : keyManagerFactory.getKeyManagers()) {
            if (!(km instanceof X509ExtendedKeyManager)) continue;
            keyManager = (X509ExtendedKeyManager)X509ExtendedKeyManager.class.cast(km);
            break;
        }
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setKeyManager(keyManager).build().create();
        jwksResponse = jwks.toString();
        server.useHttps(sslContext.getSocketFactory(), false);
        server.setDispatcher(JwtSecurityRealmTest.createTokenDispatcher(jwksResponse));
        nonTlsServer.setDispatcher(JwtSecurityRealmTest.createTokenDispatcher(jwksResponse));
        server.start(50831);
        nonTlsServer.start(50832);
    }

    @AfterClass
    public static void cleanup() throws IOException {
        server.shutdown();
        nonTlsServer.shutdown();
    }

    @Test
    public void testChangedKeys() throws Exception {
        QueueDispatcher dispatcher = new QueueDispatcher();
        dispatcher.enqueueResponse(new MockResponse().setBody(JwtSecurityRealmTest.jwksToJson(jwk1).toString()));
        dispatcher.enqueueResponse(new MockResponse().setBody(JwtSecurityRealmTest.jwksToJson(jwk1).toString()));
        dispatcher.enqueueResponse(new MockResponse().setBody(JwtSecurityRealmTest.jwksToJson(jwk2).toString()));
        dispatcher.enqueueResponse(new MockResponse().setBody(JwtSecurityRealmTest.jwksToJson(jwk2).toString()));
        dispatcher.enqueueResponse(new MockResponse().setBody(JwtSecurityRealmTest.jwksToJson(jwk3.setKid("1")).toString()));
        dispatcher.enqueueResponse(new MockResponse().setBody(JwtSecurityRealmTest.jwksToJson(jwk3).toString()));
        jwk3.setKid("3");
        server.setDispatcher((Dispatcher)dispatcher);
        BearerTokenEvidence evidence1 = new BearerTokenEvidence(this.createJwt(keyPair1, 60, -1, "1", new URI("https://localhost:50831")));
        BearerTokenEvidence evidence2 = new BearerTokenEvidence(this.createJwt(keyPair2, 60, -1, "2", new URI("https://localhost:50831")));
        BearerTokenEvidence evidence3 = new BearerTokenEvidence(this.createJwt(keyPair3, 60, -1, "1", new URI("https://localhost:50831")));
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).setJkuTimeout(0L).setJkuMinTimeBetweenRequests(0).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence2);
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence2);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence3);
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence3);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        server.setDispatcher(JwtSecurityRealmTest.createTokenDispatcher(jwksResponse));
    }

    @Test
    public void testNewRotationKeys() throws Exception {
        server.setDispatcher(JwtSecurityRealmTest.createTokenDispatcher(JwtSecurityRealmTest.jwksToJson(jwk1).toString()));
        BearerTokenEvidence evidence1 = new BearerTokenEvidence(this.createJwt(keyPair1, 60, -1, "1", new URI("https://localhost:50831")));
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).setJkuTimeout(60000L).setJkuMinTimeBetweenRequests(0).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        server.setDispatcher(JwtSecurityRealmTest.createTokenDispatcher(jwksResponse));
        BearerTokenEvidence evidence2 = new BearerTokenEvidence(this.createJwt(keyPair2, 60, -1, "2", new URI("https://localhost:50831")));
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence2);
    }

    @Test
    public void testNewRotationKeysTimeBetweenRequests() throws Exception {
        server.setDispatcher(JwtSecurityRealmTest.createTokenDispatcher(JwtSecurityRealmTest.jwksToJson(jwk1).toString()));
        BearerTokenEvidence evidence1 = new BearerTokenEvidence(this.createJwt(keyPair1, 60, -1, "1", new URI("https://localhost:50831")));
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).setJkuTimeout(60000L).setJkuMinTimeBetweenRequests(10000).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        server.setDispatcher(JwtSecurityRealmTest.createTokenDispatcher(jwksResponse));
        BearerTokenEvidence evidence2 = new BearerTokenEvidence(this.createJwt(keyPair2, 60, -1, "2", new URI("https://localhost:50831")));
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence2);
    }

    @Test
    public void testMultipleTokenTypes() throws Exception {
        BearerTokenEvidence evidence1 = new BearerTokenEvidence(this.createJwt(keyPair3, 60, -1, "1", null));
        BearerTokenEvidence evidence2 = new BearerTokenEvidence(this.createJwt(keyPair3, 60, -1, "2", null));
        BearerTokenEvidence evidence3 = new BearerTokenEvidence(this.createJwt(keyPair2, 60, -1, "1", null));
        BearerTokenEvidence evidence4 = new BearerTokenEvidence(this.createJwt(keyPair2, 60, -1, "2", new URI("https://localhost:50831")));
        BearerTokenEvidence evidence5 = new BearerTokenEvidence(this.createJwt(keyPair3, 60, -1, "2", new URI("https://localhost:50831")));
        BearerTokenEvidence evidence6 = new BearerTokenEvidence(this.createJwt(keyPair2, 60, -1, "1", new URI("https://localhost:50831")));
        BearerTokenEvidence evidence7 = new BearerTokenEvidence(this.createJwt(keyPair1, 60, -1, "3", null));
        BearerTokenEvidence evidence8 = new BearerTokenEvidence(this.createJwt(keyPair3, 60, -1));
        BearerTokenEvidence evidence9 = new BearerTokenEvidence(this.createJwt(keyPair1, 60, -1));
        LinkedHashMap<String, PublicKey> namedKeys = new LinkedHashMap<String, PublicKey>();
        namedKeys.put("1", keyPair3.getPublic());
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).publicKeys(namedKeys).publicKey(keyPair3.getPublic()).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence2);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence3);
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence4);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence5);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence6);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence7);
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence8);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence9);
    }

    @Test
    public void testUnsecuredJkuEndpoint() throws Exception {
        BearerTokenEvidence evidence = new BearerTokenEvidence(this.createJwt(keyPair1, 60, -1, "1", new URI("https://localhost:50832")));
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testKid() throws Exception {
        BearerTokenEvidence evidence1 = new BearerTokenEvidence(this.createJwt(keyPair1, 60, -1, "1", null));
        BearerTokenEvidence evidence2 = new BearerTokenEvidence(this.createJwt(keyPair2, 60, -1, "2", null));
        BearerTokenEvidence evidence3 = new BearerTokenEvidence(this.createJwt(keyPair2, 60, -1, "3", null));
        LinkedHashMap<String, PublicKey> namedKeys = new LinkedHashMap<String, PublicKey>();
        namedKeys.put("1", keyPair1.getPublic());
        namedKeys.put("2", keyPair2.getPublic());
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).publicKeys(namedKeys).build()).build();
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence2);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence3);
    }

    @Test
    public void testStoppedJkuEndpoint() throws Exception {
        server.setDispatcher(JwtSecurityRealmTest.createOneTimeDispatcher(jwksResponse));
        BearerTokenEvidence evidence = new BearerTokenEvidence(this.createJwt(keyPair1, 60, -1, "1", new URI("https://localhost:50831")));
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).setJkuTimeout(0L).setJkuMinTimeBetweenRequests(0).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence);
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
        server.setDispatcher(JwtSecurityRealmTest.createTokenDispatcher(jwksResponse));
    }

    @Test
    public void testJkuMultipleKeys() throws Exception {
        BearerTokenEvidence evidence1 = new BearerTokenEvidence(this.createJwt(keyPair1, 60, -1, "1", new URI("https://localhost:50831")));
        BearerTokenEvidence evidence2 = new BearerTokenEvidence(this.createJwt(keyPair2, 60, -1, "2", new URI("https://localhost:50831")));
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence1);
        this.assertIdentityExist((SecurityRealm)securityRealm, (Evidence)evidence2);
    }

    @Test
    public void testInvalidJku() throws Exception {
        BearerTokenEvidence evidence = new BearerTokenEvidence(this.createJwt(keyPair1, 60, -1, "1", new URI("https://localhost:80")));
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testInvalidKid() throws Exception {
        BearerTokenEvidence evidence = new BearerTokenEvidence(this.createJwt(keyPair1, 60, -1, "badkid", new URI("https://localhost:50831")));
        X509TrustManager tm = this.getTrustManager();
        SSLContext sslContext = (SSLContext)new SSLContextBuilder().setTrustManager(tm).setClientMode(true).setSessionTimeout(10).build().create();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).useSslContext(sslContext).useSslHostnameVerifier((a, b) -> true).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testUsingGeneratedPublicKey() throws Exception {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        ByteStringBuilder publicKeyPem = new ByteStringBuilder();
        Pem.generatePemPublicKey((ByteStringBuilder)publicKeyPem, (PublicKey)keyPair.getPublic());
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).publicKey(publicKeyPem.toArray()).build()).build();
        RealmIdentity realmIdentity = securityRealm.getRealmIdentity((Evidence)new BearerTokenEvidence(this.createJwt(keyPair, 10, 0)));
        Assert.assertNotNull((Object)realmIdentity);
        Assert.assertTrue((boolean)realmIdentity.exists());
        Assert.assertEquals((Object)"elytron@jboss.org", (Object)realmIdentity.getRealmIdentityPrincipal().getName());
    }

    @Test
    public void testEmptyConfiguration() throws Exception {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        ByteStringBuilder publicKeyPem = new ByteStringBuilder();
        Pem.generatePemPublicKey((ByteStringBuilder)publicKeyPem, (PublicKey)keyPair.getPublic());
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().build()).build();
        RealmIdentity realmIdentity = securityRealm.getRealmIdentity((Evidence)new BearerTokenEvidence(this.createJwt(keyPair, 10, 0)));
        Assert.assertNotNull((Object)realmIdentity);
        Assert.assertTrue((boolean)realmIdentity.exists());
        Assert.assertEquals((Object)"elytron@jboss.org", (Object)realmIdentity.getRealmIdentityPrincipal().getName());
    }

    @Test
    public void testWithMultipleAudience() throws Exception {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"third-app", "another-app-valid", "my-app"}).publicKey(keyPair.getPublic()).build()).build();
        RealmIdentity realmIdentity = securityRealm.getRealmIdentity((Evidence)new BearerTokenEvidence(this.createJwt(keyPair)));
        Assert.assertNotNull((Object)realmIdentity);
        Assert.assertTrue((boolean)realmIdentity.exists());
        Assert.assertEquals((Object)"elytron@jboss.org", (Object)realmIdentity.getRealmIdentityPrincipal().getName());
    }

    @Test
    public void testInvalidSignature() throws Exception {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        BearerTokenEvidence evidence = new BearerTokenEvidence(this.createJwt(keyPair));
        KeyPair anotherKeyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).publicKey(anotherKeyPair.getPublic()).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testInvalidIssuer() throws Exception {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        BearerTokenEvidence evidence = new BearerTokenEvidence(this.createJwt(keyPair));
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"different-issuer"}).audience(new String[]{"my-app-valid"}).publicKey(keyPair.getPublic()).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testInvalidAudience() throws Exception {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        BearerTokenEvidence evidence = new BearerTokenEvidence(this.createJwt(keyPair));
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"different-audience"}).publicKey(keyPair.getPublic()).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testTokenExpired() throws Exception {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        BearerTokenEvidence evidence = new BearerTokenEvidence(this.createJwt(keyPair, -1));
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"different-audience"}).publicKey(keyPair.getPublic()).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testTokenNotBefore() throws Exception {
        KeyPair keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        BearerTokenEvidence evidence = new BearerTokenEvidence(this.createJwt(keyPair, 10, 10));
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"different-audience"}).publicKey(keyPair.getPublic()).build()).build();
        this.assertIdentityNotExist((SecurityRealm)securityRealm, (Evidence)evidence);
    }

    @Test
    public void testUnsecuredJwt() throws Exception {
        PlainObject plainObject = new PlainObject(new PlainHeader(), new Payload(this.createClaims(10, 0).build().toString()));
        BearerTokenEvidence evidence = new BearerTokenEvidence(plainObject.serialize());
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).build()).build();
        RealmIdentity realmIdentity = securityRealm.getRealmIdentity((Evidence)evidence);
        Assert.assertNotNull((Object)realmIdentity);
        Assert.assertTrue((boolean)realmIdentity.exists());
        Assert.assertEquals((Object)"elytron@jboss.org", (Object)realmIdentity.getRealmIdentityPrincipal().getName());
    }

    @Test
    public void testAltPrincipaNames() throws Exception {
        JsonObjectBuilder altBuilder = Json.createObjectBuilder().add("upn", "upn:elytron@jboss.org");
        PlainObject plainObject = new PlainObject(new PlainHeader(), new Payload(this.createClaims(10, 0, altBuilder.build()).build().toString()));
        BearerTokenEvidence evidence = new BearerTokenEvidence(plainObject.serialize());
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().claimToPrincipal(claims -> {
            String pn = claims.getFirst("upn");
            if (pn == null) {
                pn = claims.getFirst("preferred_name");
            }
            if (pn == null) {
                pn = claims.getFirst("sub");
            }
            return new NamePrincipal(pn);
        }).validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).build()).build();
        RealmIdentity realmIdentity = securityRealm.getRealmIdentity((Evidence)evidence);
        Assert.assertNotNull((Object)realmIdentity);
        Assert.assertTrue((boolean)realmIdentity.exists());
        Assert.assertEquals((Object)"upn:elytron@jboss.org", (Object)realmIdentity.getRealmIdentityPrincipal().getName());
    }

    @Test
    public void testAltPrincipaNamesSubFallback() throws Exception {
        PlainObject plainObject = new PlainObject(new PlainHeader(), new Payload(this.createClaims(10, 0).build().toString()));
        BearerTokenEvidence evidence = new BearerTokenEvidence(plainObject.serialize());
        TokenSecurityRealm securityRealm = TokenSecurityRealm.builder().principalClaimName("sub").validator((TokenValidator)JwtValidator.builder().issuer(new String[]{"elytron-oauth2-realm"}).audience(new String[]{"my-app-valid"}).build()).build();
        RealmIdentity realmIdentity = securityRealm.getRealmIdentity((Evidence)evidence);
        Assert.assertNotNull((Object)realmIdentity);
        Assert.assertTrue((boolean)realmIdentity.exists());
        Assert.assertEquals((Object)"elytron@jboss.org", (Object)realmIdentity.getRealmIdentityPrincipal().getName());
    }

    private void assertIdentityNotExist(SecurityRealm realm, Evidence evidence) throws RealmUnavailableException {
        RealmIdentity identity = realm.getRealmIdentity(evidence);
        Assert.assertNotNull((Object)identity);
        Assert.assertFalse((boolean)identity.exists());
    }

    private void assertIdentityExist(SecurityRealm realm, Evidence evidence) throws RealmUnavailableException {
        RealmIdentity identity = realm.getRealmIdentity(evidence);
        Assert.assertNotNull((Object)identity);
        Assert.assertTrue((boolean)identity.exists());
    }

    private String createJwt(KeyPair keyPair, int expirationOffset, int notBeforeOffset) throws Exception {
        return this.createJwt(keyPair, expirationOffset, notBeforeOffset, null, null);
    }

    private String createJwt(KeyPair keyPair, int expirationOffset) throws Exception {
        return this.createJwt(keyPair, expirationOffset, -1);
    }

    private String createJwt(KeyPair keyPair, int expirationOffset, int notBeforeOffset, String kid, URI jku) throws Exception {
        PrivateKey privateKey = keyPair.getPrivate();
        RSASSASigner signer = new RSASSASigner(privateKey);
        JsonObjectBuilder claimsBuilder = this.createClaims(expirationOffset, notBeforeOffset);
        JWSHeader.Builder headerBuilder = new JWSHeader.Builder(JWSAlgorithm.RS256).type(new JOSEObjectType("jwt"));
        if (jku != null) {
            headerBuilder.jwkURL(jku);
        }
        if (kid != null) {
            headerBuilder.keyID(kid);
        }
        JWSObject jwsObject = new JWSObject(headerBuilder.build(), new Payload(claimsBuilder.build().toString()));
        jwsObject.sign((JWSSigner)signer);
        return jwsObject.serialize();
    }

    private String createJwt(KeyPair keyPair) throws Exception {
        return this.createJwt(keyPair, 60);
    }

    private JsonObjectBuilder createClaims(int expirationOffset, int notBeforeOffset) {
        return this.createClaims(expirationOffset, notBeforeOffset, null);
    }

    private JsonObjectBuilder createClaims(int expirationOffset, int notBeforeOffset, JsonObject additionalClaims) {
        JsonObjectBuilder claimsBuilder = Json.createObjectBuilder().add("active", true).add("sub", "elytron@jboss.org").add("iss", "elytron-oauth2-realm").add("aud", (JsonValue)Json.createArrayBuilder().add("my-app-valid").add("third-app-valid").add("another-app-valid").build()).add("exp", System.currentTimeMillis() / 1000L + (long)expirationOffset);
        if (additionalClaims != null) {
            for (String name : additionalClaims.keySet()) {
                JsonValue value = (JsonValue)additionalClaims.get((Object)name);
                claimsBuilder.add(name, value);
            }
        }
        if (notBeforeOffset > 0) {
            claimsBuilder.add("nbf", System.currentTimeMillis() / 1000L + (long)notBeforeOffset);
        }
        return claimsBuilder;
    }

    private X509TrustManager getTrustManager() throws Exception {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(new FileInputStream(trustStoreFile), PASSWORD);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        X509TrustManager tm = null;
        for (TrustManager tm1 : tmf.getTrustManagers()) {
            if (!(tm1 instanceof X509TrustManager)) continue;
            tm = (X509TrustManager)X509TrustManager.class.cast(tm1);
            break;
        }
        Assert.assertNotNull(tm);
        return tm;
    }

    private static JsonObject jwksToJson(RsaJwk ... jwks) {
        JsonArrayBuilder jab = Json.createArrayBuilder();
        for (int i = 0; i < jwks.length; ++i) {
            JsonObjectBuilder jwk = Json.createObjectBuilder().add("kty", jwks[i].getKty()).add("alg", jwks[i].getAlg()).add("kid", jwks[i].getKid()).add("n", jwks[i].getN()).add("e", jwks[i].getE());
            jab.add(jwk);
        }
        return Json.createObjectBuilder().add("keys", jab).build();
    }

    private static Dispatcher createOneTimeDispatcher(final String response) {
        return new Dispatcher(){
            boolean used = false;

            public MockResponse dispatch(RecordedRequest recordedRequest) {
                if (!this.used) {
                    this.used = true;
                    return new MockResponse().setBody(response);
                }
                return new MockResponse().setResponseCode(404);
            }
        };
    }

    private static Dispatcher createTokenDispatcher(final String response) {
        return new Dispatcher(){

            public MockResponse dispatch(RecordedRequest recordedRequest) {
                return new MockResponse().setBody(response);
            }
        };
    }

    static {
        jwk1 = new RsaJwk();
        jwk2 = new RsaJwk();
        jwk3 = new RsaJwk();
    }
}

