/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.Provider;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.permission.RunAsPrincipalPermission;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerUtils;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.permission.PermissionVerifier;

public class IdentitySwitchingTest {
    private static SecurityDomain usersDomain;
    private static SecurityDomain adminsDomain;
    private static final Provider provider;

    @BeforeClass
    public static void setup() throws Exception {
        SimpleMapBackedSecurityRealm usersRealm = new SimpleMapBackedSecurityRealm(NameRewriter.IDENTITY_REWRITER, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        HashMap<String, SimpleRealmEntry> users = new HashMap<String, SimpleRealmEntry>();
        IdentitySwitchingTest.addUser(users, "joe", "User");
        IdentitySwitchingTest.addUser(users, "bob", "User");
        usersRealm.setIdentityMap(users);
        SimpleMapBackedSecurityRealm adminsRealm = new SimpleMapBackedSecurityRealm(NameRewriter.IDENTITY_REWRITER, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        HashMap<String, SimpleRealmEntry> admins = new HashMap<String, SimpleRealmEntry>();
        IdentitySwitchingTest.addUser(admins, "admin", "Admin");
        adminsRealm.setIdentityMap(admins);
        SecurityDomain.Builder builder = SecurityDomain.builder();
        builder.addRealm("users", (SecurityRealm)usersRealm).build();
        builder.setDefaultRealmName("users");
        builder.setPermissionMapper((permissionMappable, roles) -> PermissionVerifier.from((Permission)new LoginPermission()).or(PermissionVerifier.from((Permission)new RunAsPrincipalPermission("bob"))));
        usersDomain = builder.build();
        builder = SecurityDomain.builder();
        builder.addRealm("admins", (SecurityRealm)adminsRealm).build();
        builder.setDefaultRealmName("admins");
        adminsDomain = builder.build();
    }

    @Test
    public void testRunAsBlock() throws Exception {
        SecurityIdentity anonymous = usersDomain.getAnonymousSecurityIdentity();
        SecurityIdentity joe = usersDomain.authenticate("joe", (Evidence)new PasswordGuessEvidence("password".toCharArray()));
        SecurityIdentity bob = anonymous.createRunAsIdentity("bob", false);
        Assert.assertEquals((Object)"joe", (Object)joe.getPrincipal().getName());
        Assert.assertEquals((Object)anonymous, (Object)usersDomain.getCurrentSecurityIdentity());
        joe.runAs(() -> {
            Assert.assertEquals((Object)joe.getPrincipal(), (Object)usersDomain.getCurrentSecurityIdentity().getPrincipal());
            joe.createRunAsIdentity("bob", true).runAs(() -> {
                Assert.assertEquals((Object)bob.getPrincipal(), (Object)usersDomain.getCurrentSecurityIdentity().getPrincipal());
                joe.createRunAsAnonymous().runAs(() -> Assert.assertEquals((Object)anonymous, (Object)usersDomain.getCurrentSecurityIdentity()));
                Assert.assertEquals((Object)bob.getPrincipal(), (Object)usersDomain.getCurrentSecurityIdentity().getPrincipal());
            });
            Assert.assertEquals((Object)joe.getPrincipal(), (Object)usersDomain.getCurrentSecurityIdentity().getPrincipal());
        });
        Assert.assertEquals((Object)anonymous, (Object)usersDomain.getCurrentSecurityIdentity());
    }

    @Test
    public void testWithSecurityIdentity() {
        SecurityIdentity joe = usersDomain.getAnonymousSecurityIdentity().createRunAsIdentity("joe", false);
        SecurityIdentity admin = adminsDomain.getAnonymousSecurityIdentity().createRunAsIdentity("admin", false);
        joe.withSecurityIdentity(joe).withSecurityIdentity(admin).withSecurityIdentity(admin).runAs(() -> {
            Assert.assertEquals((Object)joe.getPrincipal(), (Object)usersDomain.getCurrentSecurityIdentity().getPrincipal());
            Assert.assertEquals((Object)admin.getPrincipal(), (Object)adminsDomain.getCurrentSecurityIdentity().getPrincipal());
        });
        Assert.assertEquals((Object)usersDomain.getAnonymousSecurityIdentity(), (Object)usersDomain.getCurrentSecurityIdentity());
        Assert.assertEquals((Object)adminsDomain.getAnonymousSecurityIdentity(), (Object)adminsDomain.getCurrentSecurityIdentity());
    }

    @Test
    public void testRunAsAll() throws PrivilegedActionException {
        SecurityIdentity joe = usersDomain.getAnonymousSecurityIdentity().createRunAsIdentity("joe", false);
        SecurityIdentity admin = adminsDomain.getAnonymousSecurityIdentity().createRunAsIdentity("admin", false);
        SecurityIdentity.runAsAll(() -> {
            Assert.assertEquals((Object)joe.getPrincipal(), (Object)usersDomain.getCurrentSecurityIdentity().getPrincipal());
            Assert.assertEquals((Object)admin.getPrincipal(), (Object)adminsDomain.getCurrentSecurityIdentity().getPrincipal());
            return Boolean.TRUE;
        }, (SecurityIdentity[])new SecurityIdentity[]{joe, admin});
        Assert.assertEquals((Object)usersDomain.getAnonymousSecurityIdentity(), (Object)usersDomain.getCurrentSecurityIdentity());
        Assert.assertEquals((Object)adminsDomain.getAnonymousSecurityIdentity(), (Object)adminsDomain.getCurrentSecurityIdentity());
    }

    @Test
    public void testWithRoleMapper() {
        SecurityIdentity joe = usersDomain.getAnonymousSecurityIdentity().createRunAsIdentity("joe", false);
        SecurityIdentity joeWithRoles = joe.withRoleMapper("cat1", RoleMapper.constant((Roles)Roles.of((String)"constantJoesRole"))).withRoleMapper("cat2", RoleMapper.constant((Roles)Roles.of((String)"secondRole")));
        Assert.assertTrue((boolean)joeWithRoles.getRoles("cat1").contains("constantJoesRole"));
        Assert.assertTrue((boolean)joeWithRoles.getRoles("cat2").contains("secondRole"));
    }

    private static void addUser(Map<String, SimpleRealmEntry> securityRealm, String userName, String roles) throws Exception {
        List<PasswordCredential> credentials = Collections.singletonList(new PasswordCredential(PasswordFactory.getInstance((String)"clear", ServerUtils.ELYTRON_PASSWORD_PROVIDERS).generatePassword((KeySpec)new ClearPasswordSpec("password".toCharArray()))));
        MapAttributes attributes = new MapAttributes();
        attributes.addAll("Roles", Collections.singletonList(roles));
        securityRealm.put(userName, new SimpleRealmEntry(credentials, (Attributes)attributes));
    }

    static {
        provider = WildFlyElytronPasswordProvider.getInstance();
    }
}

