/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ldap;

import java.security.Principal;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.ldap.LdapTestSuite;

public class DirectEvidenceVerificationSuiteChild {
    @Test
    public void testPlainUserWithSimpleName() throws Exception {
        ModifiableSecurityRealm securityRealm = LdapSecurityRealmBuilder.builder().setDirContextSupplier(LdapTestSuite.dirContextFactory.create()).identityMapping().setSearchDn("dc=elytron,dc=wildfly,dc=org").setRdnIdentifier("uid").build().addDirectEvidenceVerification().build();
        RealmIdentity realmIdentity = securityRealm.getRealmIdentity((Principal)new NamePrincipal("plainUser"));
        SupportLevel credentialSupport = realmIdentity.getEvidenceVerifySupport(PasswordGuessEvidence.class, null);
        Assert.assertEquals((String)"Identity verification level support", (Object)SupportLevel.SUPPORTED, (Object)credentialSupport);
        Assert.assertTrue((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("plainPassword".toCharArray())));
        Assert.assertFalse((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("wrongPassword".toCharArray())));
    }

    @Test
    public void testPlainUserWithX500Name() throws Exception {
        ModifiableSecurityRealm securityRealm = LdapSecurityRealmBuilder.builder().setDirContextSupplier(LdapTestSuite.dirContextFactory.create()).identityMapping().setRdnIdentifier("uid").build().addDirectEvidenceVerification().build();
        RealmIdentity realmIdentity = securityRealm.getRealmIdentity((Principal)new NamePrincipal("uid=plainUser,dc=elytron,dc=wildfly,dc=org"));
        SupportLevel credentialSupport = realmIdentity.getEvidenceVerifySupport(PasswordGuessEvidence.class, null);
        Assert.assertEquals((String)"Identity verification level support", (Object)SupportLevel.SUPPORTED, (Object)credentialSupport);
        Assert.assertTrue((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("plainPassword".toCharArray())));
        Assert.assertFalse((boolean)realmIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("wrongPassword".toCharArray())));
    }
}

