/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import jakarta.json.Json;
import jakarta.json.JsonObjectBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslServer;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.auth.realm.token.TokenSecurityRealm;
import org.wildfly.security.auth.realm.token.TokenValidator;
import org.wildfly.security.auth.realm.token.validator.JwtValidator;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.source.OAuth2CredentialSource;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.sasl.SaslMechanismSelector;
import org.wildfly.security.sasl.oauth2.OAuth2SaslServerFactory;
import org.wildfly.security.sasl.oauth2.WildFlyElytronSaslOAuth2Provider;
import org.wildfly.security.sasl.plain.PlainSaslServerFactory;
import org.wildfly.security.sasl.plain.WildFlyElytronSaslPlainProvider;
import org.wildfly.security.sasl.test.SaslServerBuilder;
import org.wildfly.security.sasl.util.AbstractSaslParticipant;

public class MaskedPasswordSaslAuthenticationTest {
    private static final String PLAIN = "PLAIN";
    private static final String USERNAME = "Guest";
    private static final String PASSWORD = "gpwd";
    private static final String CONFIG_FILE = "wildfly-masked-password-sasl-config-v1_4.xml";
    private static final MockWebServer server = new MockWebServer();
    private static final Provider[] providers = new Provider[]{WildFlyElytronSaslPlainProvider.getInstance(), WildFlyElytronSaslOAuth2Provider.getInstance(), WildFlyElytronPasswordProvider.getInstance()};

    @BeforeClass
    public static void registerProvider() throws IOException {
        for (Provider provider : providers) {
            Security.insertProviderAt(provider, 1);
        }
        server.setDispatcher(MaskedPasswordSaslAuthenticationTest.createTokenEndpoint());
        server.start(50831);
        System.setProperty("wildfly.config.url", MaskedPasswordSaslAuthenticationTest.class.getResource(CONFIG_FILE).toExternalForm());
    }

    @AfterClass
    public static void removeProvider() throws IOException {
        for (Provider provider : providers) {
            Security.removeProvider(provider.getName());
        }
        server.shutdown();
    }

    private static Dispatcher createTokenEndpoint() {
        return new Dispatcher(){

            public MockResponse dispatch(RecordedRequest recordedRequest) throws InterruptedException {
                String body = recordedRequest.getBody().readUtf8();
                boolean resourceOwnerCredentials = body.contains("grant_type=password");
                boolean clientCredentials = body.contains("grant_type=client_credentials");
                if (resourceOwnerCredentials && body.contains("client_id=elytron-client") && body.contains("client_secret=dont_tell_me") && (body.contains("username=alice") || body.contains("username=jdoe")) && body.contains("password=dont_tell_me")) {
                    JsonObjectBuilder tokenBuilder = Json.createObjectBuilder();
                    tokenBuilder.add("access_token", "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwiaXNzIjoiYXV0aC5zZXJ2ZXIiLCJhdWQiOiJmb3JfbWUiLCJleHAiOjE3NjA5OTE2MzUsInByZWZlcnJlZF91c2VybmFtZSI6Impkb2UifQ.SoPW41_mOFnKXdkwVG63agWQ2k09dEnEtTBztnxHN64");
                    return new MockResponse().setBody(tokenBuilder.build().toString());
                }
                if (clientCredentials && body.contains("client_id=elytron-client") && body.contains("client_secret=dont_tell_me") && !body.contains("username=")) {
                    JsonObjectBuilder tokenBuilder = Json.createObjectBuilder();
                    tokenBuilder.add("access_token", "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwiaXNzIjoiYXV0aC5zZXJ2ZXIiLCJhdWQiOiJmb3JfbWUiLCJleHAiOjE3NjA5OTE2MzUsInByZWZlcnJlZF91c2VybmFtZSI6Impkb2UifQ.SoPW41_mOFnKXdkwVG63agWQ2k09dEnEtTBztnxHN64");
                    return new MockResponse().setBody(tokenBuilder.build().toString());
                }
                return new MockResponse().setResponseCode(400);
            }
        };
    }

    @Test
    public void testSuccessfulExchangeWithXmlConfig() throws Exception {
        SaslServer server = new SaslServerBuilder(PlainSaslServerFactory.class, PLAIN).setUserName(USERNAME).setPassword(PASSWORD.toCharArray()).build();
        AccessController.doPrivileged(() -> Security.insertProviderAt((Provider)WildFlyElytronPasswordProvider.getInstance(), 1));
        AuthenticationContext context = (AuthenticationContext)AuthenticationContext.getContextManager().get();
        AuthenticationContextConfigurationClient contextConfigurationClient = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
        SaslClient client = contextConfigurationClient.createSaslClient(new URI(CONFIG_FILE), (AuthenticationConfiguration)context.authRules.configuration, Arrays.asList(PLAIN));
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] message = client.evaluateChallenge(new byte[0]);
        Assert.assertEquals((Object)"\u0000Guest\u0000gpwd", (Object)new String(message, StandardCharsets.UTF_8));
        server.evaluateResponse(message);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertEquals((Object)USERNAME, (Object)server.getAuthorizationID());
    }

    @Test
    public void testSuccessfulExchangeWithProgrammaticConfig() throws Exception {
        SaslServer server = new SaslServerBuilder(PlainSaslServerFactory.class, PLAIN).setUserName(USERNAME).setPassword(PASSWORD.toCharArray()).build();
        AuthenticationConfiguration maskedConfig = AuthenticationConfiguration.empty().setSaslMechanismSelector(SaslMechanismSelector.NONE.addMechanism(PLAIN)).useName(USERNAME).useMaskedPassword("YFBlotObdCo=", null, null, 100, "12345678", null);
        AuthenticationContext context = AuthenticationContext.empty();
        context = context.with(MatchRule.ALL.matchHost("masked"), maskedConfig);
        AuthenticationContextConfigurationClient contextConfigurationClient = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
        SaslClient client = contextConfigurationClient.createSaslClient(URI.create("http://masked/"), (AuthenticationConfiguration)context.authRules.configuration, Arrays.asList(PLAIN));
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] message = client.evaluateChallenge(new byte[0]);
        Assert.assertEquals((Object)"\u0000Guest\u0000gpwd", (Object)new String(message, StandardCharsets.UTF_8));
        server.evaluateResponse(message);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertEquals((Object)USERNAME, (Object)server.getAuthorizationID());
    }

    @Test
    public void testSuccessfulOAuth2ExchangeWithXmlConfig() throws Exception {
        URI serverUri = URI.create("protocol://oauth2/");
        SaslServer saslServer = new SaslServerBuilder(OAuth2SaslServerFactory.class, "OAUTHBEARER").setServerName("resourceserver.comn").setProtocol("imap").addRealm("oauth-realm", this.createSecurityRealmMock()).setDefaultRealmName("oauth-realm").build();
        AuthenticationContext context = (AuthenticationContext)AuthenticationContext.getContextManager().get();
        AuthenticationContextConfigurationClient contextConfigurationClient = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
        AuthenticationConfiguration authenticationConfiguration = contextConfigurationClient.getAuthenticationConfiguration(serverUri, context);
        SaslClient client = contextConfigurationClient.createSaslClient(serverUri, authenticationConfiguration, Arrays.asList("OAUTHBEARER"));
        Assert.assertNotNull((String)"OAuth2SaslClient is null", (Object)client);
        byte[] message = AbstractSaslParticipant.NO_BYTES;
        while ((message = client.evaluateChallenge(message)) != null && (message = saslServer.evaluateResponse(message)) != null) {
        }
        Assert.assertTrue((boolean)saslServer.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
    }

    @Test
    public void testSuccessfulOAuth2ExchangeWithProgrammaticConfig() throws Exception {
        AuthenticationContext context = AuthenticationContext.empty().with(MatchRule.ALL.matchHost("resourceserver.com"), AuthenticationConfiguration.empty().useCredentials((CredentialSource)OAuth2CredentialSource.builder((URL)new URL("http://localhost:50831/token")).maskedClientCredentials("elytron-client", "FMkAWSbPn9SCEejW71SvLA==", "masked-MD5-DES", "somearbitrarycrazystringthatdoesnotmatter", 100, "12345678", null).useResourceOwnerMaskedPassword("alice", "FMkAWSbPn9SCEejW71SvLA==", null, null, 100, "12345678", null).build()).setSaslMechanismSelector(SaslMechanismSelector.NONE.addMechanism("OAUTHBEARER")));
        AuthenticationContextConfigurationClient contextConfigurationClient = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
        AuthenticationConfiguration configuration = contextConfigurationClient.getAuthenticationConfiguration(URI.create("http://resourceserver.com"), context);
        SaslClient saslClient = contextConfigurationClient.createSaslClient(URI.create("http://resourceserver.com"), configuration, Arrays.asList("OAUTHBEARER"));
        SaslServer saslServer = new SaslServerBuilder(OAuth2SaslServerFactory.class, "OAUTHBEARER").setServerName("resourceserver.comn").setProtocol("imap").addRealm("oauth-realm", this.createSecurityRealmMock()).setDefaultRealmName("oauth-realm").build();
        byte[] message = AbstractSaslParticipant.NO_BYTES;
        while ((message = saslClient.evaluateChallenge(message)) != null && (message = saslServer.evaluateResponse(message)) != null) {
        }
        Assert.assertTrue((boolean)saslServer.isComplete());
        Assert.assertTrue((boolean)saslClient.isComplete());
    }

    private SecurityRealm createSecurityRealmMock() {
        return TokenSecurityRealm.builder().validator((TokenValidator)JwtValidator.builder().build()).principalClaimName("preferred_username").build();
    }
}

