/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.io.File;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import mockit.Mock;
import mockit.MockUp;
import mockit.integration.junit4.JMockit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.security.audit.AuditEndpoint;
import org.wildfly.security.audit.EventPriority;
import org.wildfly.security.audit.PeriodicRotatingFileAuditEndpoint;
import org.wildfly.security.util.TestClock;

@RunWith(value=JMockit.class)
public class PeriodicRotatingFileAuditEndpointTest {
    static File logDirFile;
    static Path logFile;
    static ZoneId UTC;
    static TestClock clock;

    @BeforeClass
    public static void init() throws Exception {
        Locale.setDefault(Locale.US);
        logDirFile = new File(PeriodicRotatingFileAuditEndpointTest.class.getResource(".").getFile(), "audit");
        logFile = logDirFile.toPath().resolve("audit");
    }

    @Before
    public void initDir() {
        logDirFile.mkdirs();
        Assert.assertTrue((boolean)logDirFile.isDirectory());
        for (File file : logDirFile.listFiles()) {
            file.delete();
        }
        this.assertFiles(new String[0]);
    }

    @Test
    public void testBase() throws Exception {
        AuditEndpoint endpoint = PeriodicRotatingFileAuditEndpoint.builder().setLocation(logFile).setClock((Clock)clock).build();
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message");
        endpoint.close();
        this.assertFiles("audit");
    }

    @Test
    public void testTimeBasedRolloverYear() throws Exception {
        AuditEndpoint endpoint = PeriodicRotatingFileAuditEndpoint.builder().setTimeZone(UTC).setSuffix(".yyyy").setLocation(logFile).setClock((Clock)clock).build();
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 1");
        clock.plus(365L, ChronoUnit.DAYS);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 2");
        clock.plus(365L, ChronoUnit.DAYS);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 3");
        endpoint.close();
        this.assertFiles("audit", "audit.1970", "audit.1971");
    }

    @Test
    public void testTimeBasedRolloverMonth() throws Exception {
        AuditEndpoint endpoint = PeriodicRotatingFileAuditEndpoint.builder().setTimeZone(UTC).setSuffix(".yyyy-MM").setLocation(logFile).setClock((Clock)clock).build();
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 1");
        clock.plus(32L, ChronoUnit.DAYS);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 2");
        clock.plus(32L, ChronoUnit.DAYS);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 3");
        endpoint.close();
        this.assertFiles("audit", "audit.1970-01", "audit.1970-02");
    }

    @Test
    public void testTimeBasedRolloverWeek() throws Exception {
        AuditEndpoint endpoint = PeriodicRotatingFileAuditEndpoint.builder().setTimeZone(UTC).setSuffix(".yyyy-MM-ww").setLocation(logFile).setClock((Clock)clock).build();
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 1");
        clock.plus(4L, ChronoUnit.DAYS);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 2");
        clock.plus(7L, ChronoUnit.DAYS);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 3");
        endpoint.close();
        this.assertFiles("audit", "audit.1970-01-01", "audit.1970-01-02");
    }

    @Test
    public void testTimeBasedRolloverDay() throws Exception {
        AuditEndpoint endpoint = PeriodicRotatingFileAuditEndpoint.builder().setTimeZone(UTC).setSuffix(".yyyy-MM-ww-dd").setLocation(logFile).setClock((Clock)clock).build();
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 1");
        clock.plus(1L, ChronoUnit.DAYS);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 2");
        clock.plus(1L, ChronoUnit.DAYS);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 3");
        endpoint.close();
        this.assertFiles("audit", "audit.1970-01-01-01", "audit.1970-01-01-02");
    }

    @Test
    public void testTimeBasedRolloverHalfDay() throws Exception {
        AuditEndpoint endpoint = PeriodicRotatingFileAuditEndpoint.builder().setTimeZone(UTC).setSuffix(".yyyy-MM-ww-dd-a").setLocation(logFile).setClock((Clock)clock).build();
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 1");
        clock.plus(12L, ChronoUnit.HOURS);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 2");
        clock.plus(12L, ChronoUnit.HOURS);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 3");
        endpoint.close();
        this.assertFiles("audit", "audit.1970-01-01-01-AM", "audit.1970-01-01-01-PM");
    }

    @Test
    public void testTimeBasedRolloverHour() throws Exception {
        AuditEndpoint endpoint = PeriodicRotatingFileAuditEndpoint.builder().setTimeZone(UTC).setSuffix(".yyyy-MM-ww-dd-a-hh").setLocation(logFile).setClock((Clock)clock).build();
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 1");
        clock.plus(1L, ChronoUnit.HOURS);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 2");
        clock.plus(1L, ChronoUnit.HOURS);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 3");
        endpoint.close();
        this.assertFiles("audit", "audit.1970-01-01-01-AM-12", "audit.1970-01-01-01-AM-01");
    }

    @Test
    public void testTimeBasedRolloverHour24() throws Exception {
        AuditEndpoint endpoint = PeriodicRotatingFileAuditEndpoint.builder().setTimeZone(UTC).setSuffix(".yyyy-MM-ww-dd-a-HH").setLocation(logFile).setClock((Clock)clock).build();
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 1");
        clock.plus(1L, ChronoUnit.HOURS);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 2");
        clock.plus(1L, ChronoUnit.HOURS);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 3");
        endpoint.close();
        this.assertFiles("audit", "audit.1970-01-01-01-AM-00", "audit.1970-01-01-01-AM-01");
    }

    @Test
    public void testTimeBasedRolloverMinutes() throws Exception {
        AuditEndpoint endpoint = PeriodicRotatingFileAuditEndpoint.builder().setTimeZone(UTC).setSuffix(".yyyy-MM-ww-dd-a-HH_mm").setLocation(logFile).setClock((Clock)clock).build();
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 1");
        clock.plus(1L, ChronoUnit.MINUTES);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 2");
        clock.plus(1L, ChronoUnit.MINUTES);
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 3");
        endpoint.close();
        this.assertFiles("audit", "audit.1970-01-01-01-AM-00_00", "audit.1970-01-01-01-AM-00_01");
    }

    @Before
    public void mockTime() {
        clock = new TestClock(Instant.EPOCH.truncatedTo(ChronoUnit.DAYS));
        new MockUp<File>(){

            @Mock
            public long lastModified() {
                return clock.millis();
            }
        };
    }

    private void assertFiles(String ... files) {
        HashSet<String> expected = new HashSet<String>(Arrays.asList(files));
        for (File file : logDirFile.listFiles()) {
            if (expected.remove(file.getName())) continue;
            Assert.fail((String)("Unexpected file " + file.getName()));
        }
        for (String missing : expected) {
            Assert.fail((String)("Missing file " + missing));
        }
    }

    static {
        UTC = ZoneId.of("UTC");
    }
}

