/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashSet;
import mockit.Mock;
import mockit.MockUp;
import mockit.integration.junit4.JMockit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.security.audit.AuditEndpoint;
import org.wildfly.security.audit.EventPriority;
import org.wildfly.security.audit.SizeRotatingFileAuditEndpoint;
import org.wildfly.security.util.TestClock;

@RunWith(value=JMockit.class)
public class SizeRotatingFileAuditEndpointTest {
    static File logDirFile;
    static Path logFile;
    static ZoneId UTC;
    static TestClock clock;

    @BeforeClass
    public static void init() throws Exception {
        logDirFile = new File(SizeRotatingFileAuditEndpointTest.class.getResource(".").getFile(), "audit");
        logFile = Paths.get(logDirFile.getPath(), "audit");
    }

    @Test
    public void testBase() throws Exception {
        AuditEndpoint endpoint = SizeRotatingFileAuditEndpoint.builder().setLocation(logFile).setClock((Clock)clock).build();
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message");
        endpoint.close();
        this.assertFiles("audit");
    }

    @Test
    public void testRotateOnSizeOverflow() throws Exception {
        int i;
        AuditEndpoint endpoint = SizeRotatingFileAuditEndpoint.builder().setTimeZone(UTC).setMaxBackupIndex(4).setRotateSize(60L).setSuffix(".yyyy-MM-dd").setLocation(logFile).setClock((Clock)clock).build();
        for (i = 0; i < 15; ++i) {
            endpoint.accept((Object)EventPriority.CRITICAL, (Object)("testing log message " + i));
        }
        clock.plus(1L, ChronoUnit.DAYS);
        while (i < 30) {
            endpoint.accept((Object)EventPriority.CRITICAL, (Object)("testing log message " + i));
            ++i;
        }
        endpoint.close();
        this.assertFiles("audit", "audit.1970-01-01.1", "audit.1970-01-01.2", "audit.1970-01-01.3", "audit.1970-01-01.4", "audit.1970-01-02.1", "audit.1970-01-02.2", "audit.1970-01-02.3", "audit.1970-01-02.4");
    }

    @Test
    public void testRotateOnBoot() throws Exception {
        AuditEndpoint endpoint = SizeRotatingFileAuditEndpoint.builder().setTimeZone(UTC).setRotateOnBoot(true).setMaxBackupIndex(2).setRotateSize(1L).setSuffix(".yyyy-MM-dd").setLocation(logFile).setClock((Clock)clock).build();
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 1");
        endpoint.close();
        endpoint = SizeRotatingFileAuditEndpoint.builder().setTimeZone(UTC).setRotateOnBoot(true).setMaxBackupIndex(2).setRotateSize(1L).setSuffix(".yyyy-MM-dd").setLocation(logFile).setClock((Clock)clock).build();
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message 2");
        endpoint.close();
        this.assertFiles("audit", "audit.1970-01-01.1");
    }

    @Before
    public void initDir() {
        logDirFile.mkdirs();
        Assert.assertTrue((boolean)logDirFile.isDirectory());
        for (File file : logDirFile.listFiles()) {
            file.delete();
        }
        this.assertFiles(new String[0]);
    }

    @Before
    public void mockTime() {
        clock = new TestClock(Instant.EPOCH.truncatedTo(ChronoUnit.DAYS));
        new MockUp<File>(){

            @Mock
            public long lastModified() {
                return clock.millis();
            }
        };
    }

    private void assertFiles(String ... files) {
        HashSet<String> expected = new HashSet<String>(Arrays.asList(files));
        for (File file : logDirFile.listFiles()) {
            if (expected.remove(file.getName())) continue;
            Assert.fail((String)("Unexpected file " + file.getName()));
        }
        for (String missing : expected) {
            Assert.fail((String)("Missing file " + missing));
        }
    }

    static {
        UTC = ZoneId.of("UTC");
    }
}

