/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.realm.KeyStoreBackedSecurityRealm;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.permission.PermissionVerifier;
import org.wildfly.security.ssl.SSLContextBuilder;
import org.wildfly.security.ssl.test.util.CAGenerationTool;
import org.wildfly.security.ssl.test.util.DefinedCAIdentity;
import org.wildfly.security.ssl.test.util.DefinedIdentity;
import org.wildfly.security.x500.principal.X500AttributePrincipalDecoder;

public class MaskedPasswordSSLAuthenticationTest {
    private static final String JKS_LOCATION = "./target/test-classes/jks";
    private static CAGenerationTool caGenerationTool;

    private static SecurityDomain getKeyStoreBackedSecurityDomain(KeyStore keyStore) throws Exception {
        KeyStoreBackedSecurityRealm securityRealm = new KeyStoreBackedSecurityRealm(keyStore);
        return SecurityDomain.builder().addRealm("KeystoreRealm", (SecurityRealm)securityRealm).build().setDefaultRealmName("KeystoreRealm").setPrincipalDecoder((PrincipalDecoder)new X500AttributePrincipalDecoder("2.5.4.3", 1)).setPreRealmRewriter(s -> s.toLowerCase(Locale.ENGLISH)).setPermissionMapper((permissionMappable, roles) -> PermissionVerifier.ALL).build();
    }

    @BeforeClass
    public static void beforeTest() throws Exception {
        caGenerationTool = CAGenerationTool.builder().setBaseDir(JKS_LOCATION).setRequestIdentities(new CAGenerationTool.Identity[]{CAGenerationTool.Identity.CA, CAGenerationTool.Identity.LADYBIRD, CAGenerationTool.Identity.SCARAB}).build();
    }

    @AfterClass
    public static void afterTest() throws IOException {
        caGenerationTool.close();
    }

    @Test
    public void testTwoWay() throws Exception {
        DefinedCAIdentity ca = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.CA);
        DefinedIdentity scarab = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.SCARAB);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(MaskedPasswordSSLAuthenticationTest.getKeyStoreBackedSecurityDomain(caGenerationTool.getBeetlesKeyStore())).setKeyManager(scarab.createKeyManager()).setTrustManager(ca.createTrustManager()).setNeedClientAuth(true).build().create();
        SecurityIdentity identity = this.performConnectionTest(serverContext, "protocol://test-two-way.org", true);
        Assert.assertNotNull((Object)identity);
        Assert.assertEquals((String)"Principal Name", (Object)"ladybird", (Object)identity.getPrincipal().getName());
    }

    private SecurityIdentity performConnectionTest(SSLContext serverContext, String clientUri, boolean expectValid) throws Exception {
        System.setProperty("wildfly.config.url", MaskedPasswordSSLAuthenticationTest.class.getResource("wildfly-masked-password-ssl-config-v1_4.xml").toExternalForm());
        AccessController.doPrivileged(() -> Security.insertProviderAt((Provider)WildFlyElytronPasswordProvider.getInstance(), 1));
        AuthenticationContext context = (AuthenticationContext)AuthenticationContext.getContextManager().get();
        AuthenticationContextConfigurationClient contextConfigurationClient = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
        SSLContext clientContext = contextConfigurationClient.getSSLContext(URI.create(clientUri), context);
        return this.performConnectionTest(serverContext, clientContext, expectValid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityIdentity performConnectionTest(SSLContext serverContext, SSLContext clientContext, boolean expectValid) throws Exception {
        SSLServerSocketFactory sslServerSocketFactory = serverContext.getServerSocketFactory();
        SSLServerSocket sslServerSocket = (SSLServerSocket)sslServerSocketFactory.createServerSocket(1111, 10, InetAddress.getLoopbackAddress());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<SSLSocket> socketFuture = executorService.submit(() -> {
            try {
                System.out.println("About to connect client");
                SSLSocket sslSocket = (SSLSocket)clientContext.getSocketFactory().createSocket(InetAddress.getLoopbackAddress(), 1111);
                sslSocket.getSession();
                System.out.println("Client connected");
                return sslSocket;
            }
            catch (Exception e) {
                System.out.println("Client Connection Failed");
                throw new RuntimeException(e);
            }
        });
        SSLSocket serverSocket = (SSLSocket)sslServerSocket.accept();
        SSLSession serverSession = serverSocket.getSession();
        SSLSocket clientSocket = socketFuture.get();
        SSLSession clientSession = clientSocket.getSession();
        try {
            if (expectValid) {
                Assert.assertTrue((String)"Client SSL Session should be Valid", (boolean)clientSession.isValid());
                Assert.assertTrue((String)"Server SSL Session should be Valid", (boolean)serverSession.isValid());
                SecurityIdentity securityIdentity = (SecurityIdentity)serverSession.getValue("org.wildfly.security.ssl.identity");
                return securityIdentity;
            }
            Assert.assertFalse((String)"Client SSL Session should be Invalid", (boolean)clientSession.isValid());
            Assert.assertFalse((String)"Server SSL Session should be Invalid", (boolean)serverSession.isValid());
            SecurityIdentity securityIdentity = null;
            return securityIdentity;
        }
        finally {
            this.safeClose(serverSocket);
            this.safeClose(clientSocket);
            this.safeClose(sslServerSocket);
        }
    }

    private void safeClose(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

