/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.cert;

import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import javax.security.auth.x500.X500Principal;
import mockit.Tested;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.cache.IdentityCache;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.cert.WildFlyElytronHttpClientCertProvider;
import org.wildfly.security.http.impl.AbstractBaseHttpTest;

public class ClientCertAuthenticationMechanismTest
extends AbstractBaseHttpTest {
    private static final Provider provider = WildFlyElytronHttpClientCertProvider.getInstance();
    @Tested
    private IdentityCache identityCache;

    @BeforeClass
    public static void registerCertProvider() {
        Security.insertProviderAt(provider, 1);
        SecurityDomain securityDomain = SecurityDomain.builder().addRealm("Simple", (SecurityRealm)new SimpleMapBackedSecurityRealm()).build().setDefaultRealmName("Simple").build();
    }

    @AfterClass
    public static void removeCertProvider() {
        Security.removeProvider(provider.getName());
    }

    private HttpServerAuthenticationMechanism createMechanism() throws HttpAuthenticationException {
        HashMap props = new HashMap();
        return this.certFactory.createAuthenticationMechanism("CLIENT_CERT", props, this.getCallbackHandler("Duk3"));
    }

    @Test
    public void testNoCert() throws Exception {
        AbstractBaseHttpTest.TestingHttpServerRequest request = new AbstractBaseHttpTest.TestingHttpServerRequest(new String[0]);
        this.createMechanism().evaluateRequest((HttpServerRequest)request);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.NO_AUTH), (Object)((Object)request.getResult()));
    }

    @Test
    public void testUnknownCert() throws Exception {
        AbstractBaseHttpTest.TestingHttpServerRequest request = new AbstractBaseHttpTest.TestingHttpServerRequest(new String[]{"Cert random"}, new X500Principal("CN=Duke, OU=Test, O=Wonderland, C=US"));
        this.createMechanism().evaluateRequest((HttpServerRequest)request);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.FAILED), (Object)((Object)request.getResult()));
    }

    @Test
    public void testKnownCert() throws Exception {
        AbstractBaseHttpTest.TestingHttpServerRequest request = new AbstractBaseHttpTest.TestingHttpServerRequest(new String[]{"Cert test"}, new X500Principal("CN=Duk3, OU=T3st, O=W0nd3rl4nd, C=US"));
        this.createMechanism().evaluateRequest((HttpServerRequest)request);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.COMPLETE), (Object)((Object)request.getResult()));
    }
}

