/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest._private;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Locale;
import javax.crypto.Mac;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.sasl.digest._private.DigestUtil;

public class DigestUtilTest {
    MessageDigest md;

    @Before
    public void init() throws Exception {
        this.md = MessageDigest.getInstance(DigestUtil.messageDigestAlgorithm((String)"DIGEST-MD5"));
    }

    @Test
    public void testH_A1() throws Exception {
        Assert.assertEquals((Object)"a2549853149b0536f01f0b850c643c57", (Object)ByteIterator.ofBytes((byte[])DigestUtil.H_A1((MessageDigest)this.md, (byte[])org.wildfly.security.mechanism.digest.DigestUtil.userRealmPasswordDigest((MessageDigest)this.md, (String)"chris", (String)"elwood.innosoft.com", (char[])"secret".toCharArray()), (byte[])"OA6MG9tEQGm2hh".getBytes(StandardCharsets.UTF_8), (byte[])"OA6MHXh6VqTrRk".getBytes(StandardCharsets.UTF_8), null, (Charset)StandardCharsets.UTF_8)).hexEncode().drainToString());
        Assert.assertEquals((Object)"7f94ea5b1eb1b0573cca321e2b517b63", (Object)ByteIterator.ofBytes((byte[])DigestUtil.H_A1((MessageDigest)this.md, (byte[])org.wildfly.security.mechanism.digest.DigestUtil.userRealmPasswordDigest((MessageDigest)this.md, (String)"chris", (String)"elwood.innosoft.com", (char[])"secret".toCharArray()), (byte[])"OA9BSXrbuRhWay".getBytes(StandardCharsets.UTF_8), (byte[])"OA9BSuZWMSpW8m".getBytes(StandardCharsets.UTF_8), (String)"chris", (Charset)StandardCharsets.UTF_8)).hexEncode().drainToString());
        Assert.assertEquals((Object)"4e863a809aa7f7cc191be93705967394", (Object)ByteIterator.ofBytes((byte[])DigestUtil.H_A1((MessageDigest)this.md, (byte[])org.wildfly.security.mechanism.digest.DigestUtil.userRealmPasswordDigest((MessageDigest)this.md, (String)"\u0438\u4f60\ud83c\udca1", (String)"realm.\u0438\u4f60\ud83c\udca1.com", (char[])"\u0438\u4f60\ud83c\udca1".toCharArray()), (byte[])"sn\u0438\u4f60\ud83c\udca1".getBytes(StandardCharsets.UTF_8), (byte[])"cn\u0438\u4f60\ud83c\udca1".getBytes(StandardCharsets.UTF_8), null, (Charset)StandardCharsets.UTF_8)).hexEncode().drainToString());
    }

    @Test
    public void testDigestResponse() throws Exception {
        Assert.assertEquals((Object)"d388dad90d4bbd760a152321f2143af7", (Object)new String(DigestUtil.digestResponse((MessageDigest)this.md, (byte[])CodePointIterator.ofString((String)"a2549853149b0536f01f0b850c643c57").hexDecode().drain(), (byte[])"OA6MG9tEQGm2hh".getBytes(StandardCharsets.UTF_8), (int)1, (byte[])"OA6MHXh6VqTrRk".getBytes(StandardCharsets.UTF_8), null, (String)"auth", (String)"imap/elwood.innosoft.com", (boolean)true), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"ea40f60335c427b5527b84dbabcdfffd", (Object)new String(DigestUtil.digestResponse((MessageDigest)this.md, (byte[])CodePointIterator.ofString((String)"a2549853149b0536f01f0b850c643c57").hexDecode().drain(), (byte[])"OA6MG9tEQGm2hh".getBytes(StandardCharsets.UTF_8), (int)1, (byte[])"OA6MHXh6VqTrRk".getBytes(StandardCharsets.UTF_8), null, (String)"auth", (String)"imap/elwood.innosoft.com", (boolean)false), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"aa4e81f1c6656350f7bce05d436665de", (Object)new String(DigestUtil.digestResponse((MessageDigest)this.md, (byte[])CodePointIterator.ofString((String)"7f94ea5b1eb1b0573cca321e2b517b63").hexDecode().drain(), (byte[])"OA9BSXrbuRhWay".getBytes(StandardCharsets.UTF_8), (int)1, (byte[])"OA9BSuZWMSpW8m".getBytes(StandardCharsets.UTF_8), (String)"chris", (String)"auth", (String)"acap/elwood.innosoft.com", (boolean)true), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"af3ca83a805d4cfa00675a17315475c4", (Object)new String(DigestUtil.digestResponse((MessageDigest)this.md, (byte[])CodePointIterator.ofString((String)"7f94ea5b1eb1b0573cca321e2b517b63").hexDecode().drain(), (byte[])"OA9BSXrbuRhWay".getBytes(StandardCharsets.UTF_8), (int)1, (byte[])"OA9BSuZWMSpW8m".getBytes(StandardCharsets.UTF_8), (String)"chris", (String)"auth", (String)"acap/elwood.innosoft.com", (boolean)false), StandardCharsets.UTF_8));
    }

    @Test
    public void testConvertToHexBytesWithLeftPadding() throws Exception {
        Assert.assertEquals((Object)"00000001", (Object)new String(DigestUtil.convertToHexBytesWithLeftPadding((int)1, (int)8), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"0000002", (Object)new String(DigestUtil.convertToHexBytesWithLeftPadding((int)2, (int)7), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"000a", (Object)new String(DigestUtil.convertToHexBytesWithLeftPadding((int)10, (int)4), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"abc", (Object)new String(DigestUtil.convertToHexBytesWithLeftPadding((int)2748, (int)3), StandardCharsets.UTF_8));
    }

    @Test
    public void testCreate3desSubKey() throws Exception {
        byte[] input1 = CodePointIterator.ofString((String)"FFFFFFFFFFFFFF").hexDecode().drain();
        byte[] output1 = DigestUtil.create3desSubKey((byte[])input1, (int)0);
        Assert.assertEquals((Object)"FEFEFEFEFEFEFEFE".toLowerCase(Locale.ROOT), (Object)ByteIterator.ofBytes((byte[])output1).hexEncode().drainToString());
        byte[] input2 = CodePointIterator.ofString((String)"d7c920cf2564cec39c570490f7ea").hexDecode().drain();
        byte[] output2 = DigestUtil.create3desSubKey((byte[])input2, (int)0);
        Assert.assertEquals((Object)"D6E54919F22A929D".toLowerCase(Locale.ROOT), (Object)ByteIterator.ofBytes((byte[])output2).hexEncode().drainToString());
        byte[] input3 = CodePointIterator.ofString((String)"d7c920cf2564cec39c570490f7ea").hexDecode().drain();
        byte[] output3 = DigestUtil.create3desSubKey((byte[])input3, (int)7);
        Assert.assertEquals((Object)"C2CE15E04986DFD5".toLowerCase(Locale.ROOT), (Object)ByteIterator.ofBytes((byte[])output3).hexEncode().drainToString());
    }

    @Test
    public void testComputeHmac() throws Exception {
        Mac mac = Mac.getInstance("HmacMD5");
        byte[] message = CodePointIterator.ofString((String)"11223344").hexDecode().drain();
        byte[] kc = CodePointIterator.ofString((String)"9fdbff3d48c87e74bd89460e2462c73a").hexDecode().drain();
        byte[] output = DigestUtil.computeHMAC((byte[])kc, (int)0, (Mac)mac, (byte[])message, (int)0, (int)message.length);
        Assert.assertEquals((Object)"EF3E40D7B5A64C1DAE6B".toLowerCase(Locale.ROOT), (Object)ByteIterator.ofBytes((byte[])output).hexEncode().drainToString());
    }

    @Test
    public void testIntegerByteOrdered() throws Exception {
        byte[] output0 = new byte[4];
        DigestUtil.integerByteOrdered((int)0, (byte[])output0, (int)0, (int)4);
        Assert.assertEquals((Object)"00000000".toLowerCase(Locale.ROOT), (Object)ByteIterator.ofBytes((byte[])output0).hexEncode().drainToString());
        byte[] output1 = new byte[4];
        DigestUtil.integerByteOrdered((int)1, (byte[])output1, (int)0, (int)4);
        Assert.assertEquals((Object)"00000001".toLowerCase(Locale.ROOT), (Object)ByteIterator.ofBytes((byte[])output1).hexEncode().drainToString());
        byte[] output1234 = new byte[6];
        DigestUtil.integerByteOrdered((int)4660, (byte[])output1234, (int)1, (int)4);
        Assert.assertEquals((Object)"000000123400".toLowerCase(Locale.ROOT), (Object)ByteIterator.ofBytes((byte[])output1234).hexEncode().drainToString());
        byte[] outputFFFFFFFF = new byte[4];
        DigestUtil.integerByteOrdered((int)-1, (byte[])outputFFFFFFFF, (int)0, (int)4);
        Assert.assertEquals((Object)"FFFFFFFF".toLowerCase(Locale.ROOT), (Object)ByteIterator.ofBytes((byte[])outputFFFFFFFF).hexEncode().drainToString());
    }

    @Test
    public void testDecodeByteOrderedInteger() throws Exception {
        byte[] input0 = CodePointIterator.ofString((String)"00000000").hexDecode().drain();
        Assert.assertEquals((long)0L, (long)DigestUtil.decodeByteOrderedInteger((byte[])input0, (int)0, (int)4));
        byte[] input1 = CodePointIterator.ofString((String)"00000001").hexDecode().drain();
        Assert.assertEquals((long)1L, (long)DigestUtil.decodeByteOrderedInteger((byte[])input1, (int)0, (int)4));
        byte[] input1234 = CodePointIterator.ofString((String)"000000123400").hexDecode().drain();
        Assert.assertEquals((long)4660L, (long)DigestUtil.decodeByteOrderedInteger((byte[])input1234, (int)1, (int)4));
        byte[] input1234b = CodePointIterator.ofString((String)"000000123400").hexDecode().drain();
        Assert.assertEquals((long)4660L, (long)DigestUtil.decodeByteOrderedInteger((byte[])input1234b, (int)3, (int)2));
        byte[] inputFFFFFFFF = CodePointIterator.ofString((String)"FFFFFFFF").hexDecode().drain();
        Assert.assertEquals((long)-1L, (long)DigestUtil.decodeByteOrderedInteger((byte[])inputFFFFFFFF, (int)0, (int)4));
        byte[] inputFF = CodePointIterator.ofString((String)"000000FF").hexDecode().drain();
        Assert.assertEquals((long)255L, (long)DigestUtil.decodeByteOrderedInteger((byte[])inputFF, (int)0, (int)4));
    }
}

