/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.gssapi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.factory.DefaultDirectoryServiceFactory;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.keytab.Keytab;
import org.apache.kerby.kerberos.kerb.keytab.KeytabEntry;
import org.apache.kerby.kerberos.kerb.server.SimpleKdcServer;
import org.apache.kerby.kerberos.kerb.server.impl.DefaultInternalKdcServerImpl;
import org.apache.kerby.kerberos.kerb.server.impl.InternalKdcServer;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.jboss.logging.Logger;

public class TestKDC {
    public static final int LDAP_PORT = 11390;
    private static Logger log = Logger.getLogger(TestKDC.class);
    private File workingDir;
    private DirectoryService directoryService;
    private SimpleKdcServer kdcServer;
    private String originalConfig;
    private boolean exposeLdapServer;
    private LdapServer ldapServer;

    public TestKDC(boolean exposeLdapServer) {
        this.exposeLdapServer = exposeLdapServer;
    }

    public void startDirectoryService() {
        if (this.directoryService != null) {
            throw new IllegalStateException("DirectoryService already started");
        }
        this.createWorkingDir();
        try {
            DefaultDirectoryServiceFactory dsf = new DefaultDirectoryServiceFactory();
            DirectoryService ds = dsf.getDirectoryService();
            dsf.init("Test Service");
            ds.getChangeLog().setEnabled(false);
            ds.addLast((Interceptor)new KeyDerivationInterceptor());
            SchemaManager schemaManager = ds.getSchemaManager();
            TestKDC.createPartition((DirectoryServiceFactory)dsf, schemaManager, "wildfly", "dc=wildfly,dc=org", ds, this.workingDir, "uid", "krb5PrincipalName");
            CoreSession adminSession = ds.getAdminSession();
            TestKDC.processLdif(schemaManager, adminSession, "/KerberosTesting.ldif");
            this.directoryService = ds;
            if (this.exposeLdapServer) {
                this.ldapServer = new LdapServer();
                this.ldapServer.setServiceName("DefaultLDAP");
                TcpTransport ldap = new TcpTransport("localhost", 11390, 3, 5);
                this.ldapServer.addTransports(new Transport[]{ldap});
                this.ldapServer.setDirectoryService(this.directoryService);
                this.ldapServer.start();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to initialise DirectoryService", e);
        }
    }

    private static void createPartition(DirectoryServiceFactory dsf, SchemaManager schemaManager, String id, String suffix, DirectoryService directoryService, File workingDir, String ... indexAttributes) throws Exception {
        PartitionFactory pf = dsf.getPartitionFactory();
        Partition p = pf.createPartition(schemaManager, directoryService.getDnFactory(), id, suffix, 1000, workingDir);
        for (String current : indexAttributes) {
            pf.addIndex(p, current, 10);
        }
        p.initialize();
        directoryService.addPartition(p);
    }

    private static void processLdif(SchemaManager schemaManager, CoreSession adminSession, String ldifName) throws Exception {
        InputStream ldifInput = TestKDC.class.getResourceAsStream(ldifName);
        LdifReader ldifReader = new LdifReader(ldifInput);
        for (LdifEntry ldifEntry : ldifReader) {
            adminSession.add((Entry)new DefaultEntry(schemaManager, ldifEntry.getEntry()));
        }
        ldifReader.close();
        ldifInput.close();
    }

    private void stopDirectoryService() {
        if (this.directoryService == null) {
            return;
        }
        try {
            this.directoryService.shutdown();
            this.directoryService = null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error shutting down directory service", e);
        }
    }

    public void startKDC() {
        if (this.directoryService == null) {
            throw new IllegalStateException("No DirectoryService Available for KDC");
        }
        if (this.kdcServer != null) {
            throw new IllegalStateException("KDCServer already started");
        }
        File configPath = new File(TestKDC.class.getResource("/krb5.conf").getFile());
        this.originalConfig = System.setProperty("java.security.krb5.conf", configPath.getAbsolutePath());
        try {
            SimpleKdcServer kdcServer = new SimpleKdcServer();
            kdcServer.setKdcRealm("WILDFLY.ORG");
            kdcServer.setKdcHost("localhost");
            kdcServer.setInnerKdcImpl((InternalKdcServer)new DefaultInternalKdcServerImpl(kdcServer.getKdcSetting()));
            kdcServer.setAllowUdp(true);
            kdcServer.setKdcUdpPort(6088);
            kdcServer.init();
            kdcServer.createPrincipal("sasl/test_server_1@WILDFLY.ORG", "servicepwd");
            kdcServer.createPrincipal("sasl/test_server_2@WILDFLY.ORG", "servicepwd");
            kdcServer.createPrincipal("jduke@WILDFLY.ORG", "theduke");
            kdcServer.start();
            this.kdcServer = kdcServer;
        }
        catch (KrbException e) {
            throw new IllegalStateException("Unable to start KDC", e);
        }
    }

    private void stopKDC() {
        if (this.kdcServer == null) {
            return;
        }
        try {
            this.kdcServer.stop();
        }
        catch (KrbException e) {
            throw new IllegalStateException("Unable to stop KDC", e);
        }
        this.kdcServer = null;
        if (this.originalConfig != null) {
            System.setProperty("java.security.krb5.conf", this.originalConfig);
        }
    }

    private void createWorkingDir() {
        this.workingDir = new File("./target/apache-ds/working");
        if (!this.workingDir.exists() && !this.workingDir.mkdirs()) {
            throw new IllegalStateException("Unable to create working dir.");
        }
        this.emptyDir(this.workingDir);
    }

    private void cleanWorkingDir() {
        this.emptyDir(this.workingDir);
        this.workingDir = null;
    }

    private void emptyDir(File dir) {
        for (File current : dir.listFiles()) {
            if (current.delete()) continue;
            try {
                throw new IllegalStateException(String.format("Unable to delete file '%s' from working dir '%s'.", current.getName(), this.workingDir.getCanonicalPath()));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void stopAll() {
        this.stopKDC();
        this.stopDirectoryService();
    }

    public String generateKeyTab(String keyTabFileName, String ... credentials) {
        log.debug((Object)("Generating keytab: " + keyTabFileName));
        ArrayList<KeytabEntry> entries = new ArrayList<KeytabEntry>();
        KerberosTime ktm = KerberosTime.now();
        int i = 0;
        while (i < credentials.length) {
            String principal = credentials[i++];
            String password = credentials[i++];
            for (Map.Entry keyEntry : KerberosKeyFactory.getKerberosKeys((String)principal, (String)password).entrySet()) {
                EncryptionKey key = (EncryptionKey)keyEntry.getValue();
                log.debug((Object)("Adding key=" + key + " for principal=" + principal));
                entries.add(new KeytabEntry(new PrincipalName(principal), ktm, key.getKeyVersion(), new org.apache.kerby.kerberos.kerb.type.base.EncryptionKey(key.getKeyType().getValue(), key.getKeyValue(), key.getKeyVersion())));
            }
        }
        Keytab keyTab = new Keytab();
        keyTab.addKeytabEntries(entries);
        try {
            File keyTabFile = new File(this.workingDir, keyTabFileName);
            keyTab.store(keyTabFile);
            return keyTabFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create keytab: " + keyTabFileName, e);
        }
    }
}

