/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.test;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import org.junit.Assert;
import org.wildfly.security.auth.callback.AnonymousAuthorizationCallback;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.callback.FastUnsupportedCallbackException;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;

@Deprecated
public class ServerCallbackHandler
implements CallbackHandler {
    private final String expectedUsername;
    private final char[] expectedPassword;
    private final String expectedAuthzid;
    private final KeySpec keySpec;
    private final String algorithm;
    private String bindingType = null;
    private byte[] bindingData = null;

    public ServerCallbackHandler(String expectedUsername, char[] expectedPassword) {
        this.expectedUsername = expectedUsername;
        this.expectedPassword = expectedPassword;
        this.expectedAuthzid = null;
        this.keySpec = null;
        this.algorithm = null;
    }

    public ServerCallbackHandler(String expectedUsername, String algorithm, KeySpec keyspec) {
        this.expectedUsername = expectedUsername;
        this.algorithm = algorithm;
        this.keySpec = keyspec;
        this.expectedAuthzid = null;
        this.expectedPassword = null;
    }

    public ServerCallbackHandler(String expectedUsername, String algorithm, KeySpec keyspec, String authzid) {
        this.expectedUsername = expectedUsername;
        this.algorithm = algorithm;
        this.keySpec = keyspec;
        this.expectedAuthzid = authzid;
        this.expectedPassword = null;
    }

    public void setBinding(String bindingType, byte[] bindingData) {
        this.bindingType = bindingType;
        this.bindingData = bindingData;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback current : callbacks) {
            if (current instanceof NameCallback) {
                String username = ((NameCallback)current).getDefaultName();
                if (username != null && username.equals(this.expectedUsername)) continue;
                throw new SaslException("Invalid username received (expected \"" + this.expectedUsername + "\", received \"" + username + "\"");
            }
            if (current instanceof EvidenceVerifyCallback && this.expectedPassword != null) {
                EvidenceVerifyCallback pvc = (EvidenceVerifyCallback)current;
                pvc.setVerified(Arrays.equals(this.expectedPassword, (char[])pvc.applyToEvidence(PasswordGuessEvidence.class, PasswordGuessEvidence::getGuess)));
                continue;
            }
            if (current instanceof PasswordCallback && this.expectedPassword != null) {
                PasswordCallback pcb = (PasswordCallback)current;
                pcb.setPassword(this.expectedPassword);
                continue;
            }
            if (current instanceof AnonymousAuthorizationCallback) {
                ((AnonymousAuthorizationCallback)current).setAuthorized(true);
                continue;
            }
            if (current instanceof AuthorizeCallback) {
                AuthorizeCallback acb = (AuthorizeCallback)current;
                Assert.assertEquals((Object)this.expectedUsername, (Object)acb.getAuthenticationID());
                if (this.expectedAuthzid != null) {
                    acb.setAuthorized(this.expectedAuthzid.equals(acb.getAuthorizationID()));
                    continue;
                }
                acb.setAuthorized(this.expectedUsername.equals(acb.getAuthorizationID()));
                continue;
            }
            if (current instanceof RealmCallback) continue;
            if (current instanceof CredentialCallback && this.algorithm != null && this.keySpec != null) {
                CredentialCallback ccb = (CredentialCallback)current;
                try {
                    PasswordFactory passwordFactory = PasswordFactory.getInstance((String)this.algorithm);
                    Password password = passwordFactory.generatePassword(this.keySpec);
                    if (!ccb.isCredentialTypeSupported(PasswordCredential.class, password.getAlgorithm())) {
                        throw new FastUnsupportedCallbackException(current);
                    }
                    ccb.setCredential((Credential)new PasswordCredential(password));
                    continue;
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new IOException("Password object generation failed", e);
                }
            }
            if (current instanceof ChannelBindingCallback && this.bindingType != null) {
                ChannelBindingCallback cbc = (ChannelBindingCallback)current;
                cbc.setBindingType(this.bindingType);
                cbc.setBindingData(this.bindingData);
                continue;
            }
            throw new UnsupportedCallbackException(current, current.getClass().getSimpleName() + " not supported.");
        }
    }
}

