/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.apacheds;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.factory.DefaultDirectoryServiceFactory;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;

public class LdapService
implements Closeable {
    private final DirectoryService directoryService;
    private final Collection<LdapServer> servers;

    private LdapService(DirectoryService directoryService, Collection<LdapServer> servers) {
        this.directoryService = directoryService;
        this.servers = servers;
    }

    @Override
    public void close() throws IOException {
        for (LdapServer current : this.servers) {
            current.stop();
        }
        try {
            this.directoryService.shutdown();
        }
        catch (Exception e) {
            throw new IOException("Unable to shut down DirectoryService", e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean started = false;
        private File workingDir = null;
        private DirectoryServiceFactory directoryServiceFactory;
        private DirectoryService directoryService;
        private List<LdapServer> servers = new LinkedList<LdapServer>();

        Builder() {
        }

        public Builder setWorkingDir(File workingDir) {
            this.assertNotStarted();
            this.workingDir = workingDir;
            return this;
        }

        public Builder createDirectoryService(String name) throws Exception {
            if (this.directoryService != null) {
                throw new IllegalStateException("Directory service already created.");
            }
            this.initWorkingDir();
            this.directoryServiceFactory = new DefaultDirectoryServiceFactory();
            this.directoryServiceFactory.init(name);
            DirectoryService directoryService = this.directoryServiceFactory.getDirectoryService();
            directoryService.getChangeLog().setEnabled(false);
            this.directoryService = directoryService;
            return this;
        }

        public Builder addPartition(String id, String partitionName, int indexSize, String ... indexes) throws Exception {
            this.assertNotStarted();
            if (this.directoryService == null) {
                throw new IllegalStateException("The Directory service has not been created.");
            }
            SchemaManager schemaManager = this.directoryService.getSchemaManager();
            PartitionFactory partitionFactory = this.directoryServiceFactory.getPartitionFactory();
            Partition partition = partitionFactory.createPartition(schemaManager, this.directoryService.getDnFactory(), id, partitionName, 1000, this.workingDir);
            for (String current : indexes) {
                partitionFactory.addIndex(partition, current, indexSize);
            }
            partition.initialize();
            this.directoryService.addPartition(partition);
            return this;
        }

        public Builder importLdif(InputStream ldif) throws Exception {
            this.assertNotStarted();
            if (this.directoryService == null) {
                throw new IllegalStateException("The Directory service has not been created.");
            }
            CoreSession adminSession = this.directoryService.getAdminSession();
            SchemaManager schemaManager = this.directoryService.getSchemaManager();
            LdifReader ldifReader = new LdifReader(ldif);
            for (LdifEntry ldifEntry : ldifReader) {
                adminSession.add((Entry)new DefaultEntry(schemaManager, ldifEntry.getEntry()));
            }
            ldifReader.close();
            ldif.close();
            return this;
        }

        public Builder addTcpServer(String serviceName, String hostName, int port, String keyStore, String keyStorePassword) throws URISyntaxException {
            this.assertNotStarted();
            if (this.directoryService == null) {
                throw new IllegalStateException("The Directory service has not been created.");
            }
            LdapServer server = new LdapServer();
            server.setServiceName(serviceName);
            TcpTransport ldaps = new TcpTransport(hostName, port, 3, 5);
            ldaps.enableSSL(true);
            server.addTransports(new Transport[]{ldaps});
            server.setKeystoreFile(new File(this.getClass().getResource(keyStore).getFile()).getAbsolutePath());
            server.setCertificatePassword(keyStorePassword);
            server.setDirectoryService(this.directoryService);
            this.servers.add(server);
            return this;
        }

        public LdapService start() throws Exception {
            this.assertNotStarted();
            this.started = true;
            for (LdapServer current : this.servers) {
                current.start();
            }
            return new LdapService(this.directoryService, this.servers);
        }

        private void assertNotStarted() {
            if (this.started) {
                throw new IllegalStateException("Already started.");
            }
        }

        private void initWorkingDir() {
            if (this.workingDir == null) {
                throw new IllegalStateException("No working dir.");
            }
            if (!this.workingDir.exists() && !this.workingDir.mkdirs()) {
                throw new IllegalStateException("Unable to create working dir.");
            }
            this.emptyDir(this.workingDir);
        }

        private void emptyDir(File dir) {
            for (File current : dir.listFiles()) {
                if (current.delete()) continue;
                try {
                    throw new IllegalStateException(String.format("Unable to delete file '%s' from working dir '%s'.", current.getName(), this.workingDir.getCanonicalPath()));
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

