/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ldap;

import java.security.Principal;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.ldap.LdapTestSuite;

public class PrincipalMappingSuiteChild {
    @Test
    public void testLdapRealmPrincipalMapping() throws RealmUnavailableException {
        ModifiableSecurityRealm realm = LdapSecurityRealmBuilder.builder().setDirContextSupplier(LdapTestSuite.dirContextFactory.create()).identityMapping().setSearchDn("dc=elytron,dc=wildfly,dc=org").setRdnIdentifier("uid").build().build();
        RealmIdentity identity = realm.getRealmIdentity((Principal)new NamePrincipal("plainUser"));
        Assert.assertTrue((String)"Exists", (boolean)identity.exists());
        identity = realm.getRealmIdentity((Principal)new NamePrincipal("nobody"));
        Assert.assertFalse((String)"Exists", (boolean)identity.exists());
    }

    @Test
    public void testDnToSimple() throws RealmUnavailableException {
        ModifiableSecurityRealm realm = LdapSecurityRealmBuilder.builder().setDirContextSupplier(LdapTestSuite.dirContextFactory.create()).identityMapping().setRdnIdentifier("uid").build().build();
        RealmIdentity identity = realm.getRealmIdentity((Principal)new NamePrincipal("uid=plainUser,dc=elytron,dc=wildfly,dc=org"));
        Assert.assertTrue((String)"Exists", (boolean)identity.exists());
        identity = realm.getRealmIdentity((Principal)new NamePrincipal("uid=nobody,dc=elytron,dc=wildfly,dc=org"));
        Assert.assertFalse((String)"Exists", (boolean)identity.exists());
    }

    @Test
    public void testDnToDnNoLookup() throws RealmUnavailableException {
        ModifiableSecurityRealm realm = LdapSecurityRealmBuilder.builder().setDirContextSupplier(LdapTestSuite.dirContextFactory.create()).identityMapping().setRdnIdentifier("uid").build().build();
        RealmIdentity identity = realm.getRealmIdentity((Principal)new NamePrincipal("uid=plainUser,dc=elytron,dc=wildfly,dc=org"));
        Assert.assertTrue((String)"Exists", (boolean)identity.exists());
    }

    @Test
    public void testDnToDnVerify() throws RealmUnavailableException {
        ModifiableSecurityRealm realm = LdapSecurityRealmBuilder.builder().setDirContextSupplier(LdapTestSuite.dirContextFactory.create()).identityMapping().setRdnIdentifier("uid").setSearchDn("dc=elytron,dc=wildfly,dc=org").build().build();
        RealmIdentity identity = realm.getRealmIdentity((Principal)new NamePrincipal("uid=PlainUser,dc=elytron,dc=wildfly,dc=org"));
        Assert.assertTrue((String)"Exists", (boolean)identity.exists());
        int tryNumber = 0;
        int maxTries = 2;
        while (true) {
            try {
                identity = realm.getRealmIdentity((Principal)new NamePrincipal("uid=nobody,dc=elytron,dc=wildfly,dc=org"));
            }
            catch (RealmUnavailableException e) {
                if (++tryNumber != maxTries) continue;
                throw e;
            }
            break;
        }
        Assert.assertFalse((String)"Exists", (boolean)identity.exists());
    }
}

