/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URI;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.MiscPEMGenerator;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.realm.KeyStoreBackedSecurityRealm;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.permission.PermissionVerifier;
import org.wildfly.security.ssl.SSLContextBuilder;
import org.wildfly.security.ssl.TestingOcspServer;
import org.wildfly.security.ssl.X509RevocationTrustManager;
import org.wildfly.security.ssl.test.util.CAGenerationTool;
import org.wildfly.security.ssl.test.util.CustomIdentity;
import org.wildfly.security.ssl.test.util.DefinedCAIdentity;
import org.wildfly.security.ssl.test.util.DefinedIdentity;
import org.wildfly.security.x500.GeneralName;
import org.wildfly.security.x500.cert.AccessDescription;
import org.wildfly.security.x500.cert.AuthorityInformationAccessExtension;
import org.wildfly.security.x500.cert.ExtendedKeyUsageExtension;
import org.wildfly.security.x500.cert.X509CertificateExtension;
import org.wildfly.security.x500.principal.X500AttributePrincipalDecoder;

public class SSLAuthenticationTest {
    private static final int OCSP_PORT = 4854;
    private final int TESTING_PORT = 18201;
    private static final char[] PASSWORD = "Elytron".toCharArray();
    private static final String JKS_LOCATION = "./target/test-classes/pkcs12";
    private static final String CA_CRL_LOCATION = "./target/test-classes/ca/crl";
    private static final String ICA_CRL_LOCATION = "./target/test-classes/ica/crl";
    private static final File WORKING_DIR_CACRL = new File("./target/test-classes/ca/crl");
    private static final File WORKING_DIR_ICACRL = new File("./target/test-classes/ica/crl");
    private static final File SHORTWINGED_FILE = new File("./target/test-classes/pkcs12", "shortwinged.keystore");
    private static final File CA_BLANK_PEM_CRL = new File(WORKING_DIR_CACRL, "blank.pem");
    private static final File ICA_BLANK_PEM_CRL = new File(WORKING_DIR_ICACRL, "blank.pem");
    private static final File BLANK_BLANK_PEM_CRL = new File(WORKING_DIR_ICACRL, "blank-blank.pem");
    private static final File FIREFLY_REVOKED_PEM_CRL = new File(WORKING_DIR_CACRL, "firefly-revoked.pem");
    private static final File ICA_REVOKED_PEM_CRL = new File(WORKING_DIR_CACRL, "ica-revoked.pem");
    private static final File ROVE_REVOKED_PEM_CRL = new File(WORKING_DIR_ICACRL, "rove-revoked.pem");
    private static CAGenerationTool caGenerationTool = null;
    private static final File LADYBUG_REVOKED_PEM_CRL = new File(WORKING_DIR_CACRL, "ladybug-revoked.pem");
    private static TestingOcspServer ocspServer = null;
    private static X509Certificate ocspResponderCertificate;
    private static KeyStore shortWingedKeyStore;
    private static CustomIdentity goodIdentity;
    private static CustomIdentity revokedIdentity;

    private static TrustManagerFactory getTrustManagerFactory() throws Exception {
        return TrustManagerFactory.getInstance("PKIX");
    }

    private static KeyStore createKeyStore() throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(null, null);
        return ks;
    }

    private static void createTemporaryKeyStoreFile(KeyStore keyStore, File outputFile, char[] password) throws Exception {
        if (!outputFile.exists()) {
            outputFile.createNewFile();
        }
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            keyStore.store(fos, password);
        }
    }

    private static SecurityDomain getKeyStoreBackedSecurityDomain(KeyStore keyStore) throws Exception {
        return SSLAuthenticationTest.getKeyStoreBackedSecurityDomain(keyStore, true);
    }

    private static SecurityDomain getKeyStoreBackedSecurityDomain(KeyStore keyStore, boolean decoder) throws Exception {
        KeyStoreBackedSecurityRealm securityRealm = new KeyStoreBackedSecurityRealm(keyStore);
        SecurityDomain.Builder builder = SecurityDomain.builder().addRealm("KeystoreRealm", (SecurityRealm)securityRealm).build().setDefaultRealmName("KeystoreRealm").setPreRealmRewriter(s -> s.toLowerCase(Locale.ENGLISH)).setPermissionMapper((permissionMappable, roles) -> PermissionVerifier.ALL);
        if (decoder) {
            builder.setPrincipalDecoder((PrincipalDecoder)new X500AttributePrincipalDecoder("2.5.4.3", 1));
        }
        return builder.build();
    }

    @BeforeClass
    public static void beforeTest() throws Exception {
        WORKING_DIR_CACRL.mkdirs();
        WORKING_DIR_ICACRL.mkdirs();
        caGenerationTool = CAGenerationTool.builder().setBaseDir(JKS_LOCATION).setRequestIdentities(CAGenerationTool.Identity.values()).build();
        Security.addProvider((Provider)new BouncyCastleProvider());
        DefinedCAIdentity caIdentity = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.CA);
        DefinedCAIdentity intermediateCAIdentity = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.INTERMEDIATE);
        CustomIdentity responderIdentity = caIdentity.createIdentity("ocspResponder", new X500Principal("OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=OcspResponder"), "ocsp-responder.keystore", new X509CertificateExtension[]{new ExtendedKeyUsageExtension(false, Collections.singletonList("1.3.6.1.5.5.7.3.9"))});
        ocspResponderCertificate = responderIdentity.getCertificate();
        goodIdentity = intermediateCAIdentity.createIdentity("checked", new X500Principal("OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=ocspCheckedGood"), "ocsp-checked-good.keystore", new X509CertificateExtension[]{new AuthorityInformationAccessExtension(Collections.singletonList(new AccessDescription("1.3.6.1.5.5.7.48.1", (GeneralName)new GeneralName.URIName("http://localhost:4854/ocsp"))))});
        X509Certificate ocspCheckedGoodCertificate = goodIdentity.getCertificate();
        revokedIdentity = caIdentity.createIdentity("checked", new X500Principal("OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=ocspCheckedRevoked"), "ocsp-checked-revoked.keystore", new X509CertificateExtension[]{new AuthorityInformationAccessExtension(Collections.singletonList(new AccessDescription("1.3.6.1.5.5.7.48.1", (GeneralName)new GeneralName.URIName("http://localhost:4854/ocsp"))))});
        X509Certificate ocspCheckedRevokedCertificate = revokedIdentity.getCertificate();
        CustomIdentity unknownIdentity = caIdentity.createIdentity("checked", new X500Principal("OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=ocspCheckedUnknown"), "ocsp-checked-unknown.keystore", new X509CertificateExtension[]{new AuthorityInformationAccessExtension(Collections.singletonList(new AccessDescription("1.3.6.1.5.5.7.48.1", (GeneralName)new GeneralName.URIName("http://localhost:4854/ocsp"))))});
        X509Certificate ocspCheckedUnknownCertificate = unknownIdentity.getCertificate();
        X509Certificate greenJuneCertificate = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.GREENJUNE).getCertificate();
        KeyStore beetlesKeyStore = caGenerationTool.getBeetlesKeyStore();
        beetlesKeyStore.setCertificateEntry("ocspResponder", ocspResponderCertificate);
        beetlesKeyStore.setCertificateEntry("ocspCheckedGood", ocspCheckedGoodCertificate);
        beetlesKeyStore.setCertificateEntry("ocspCheckedRevoked", ocspCheckedRevokedCertificate);
        beetlesKeyStore.setCertificateEntry("ocspCheckedUnknown", ocspCheckedUnknownCertificate);
        beetlesKeyStore.setCertificateEntry("green june", greenJuneCertificate);
        SSLAuthenticationTest.createTemporaryKeyStoreFile(beetlesKeyStore, new File(JKS_LOCATION, "beetles.keystore"), PASSWORD);
        shortWingedKeyStore = SSLAuthenticationTest.createKeyStore();
        shortWingedKeyStore.setCertificateEntry("rove", caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.ROVE).getCertificate());
        Calendar calendar = Calendar.getInstance();
        Date currentDate = calendar.getTime();
        calendar.add(1, 1);
        Date nextYear = calendar.getTime();
        calendar.add(1, -1);
        calendar.add(13, -30);
        Date revokeDate = calendar.getTime();
        X509v2CRLBuilder caBlankCrlBuilder = new X509v2CRLBuilder(SSLAuthenticationTest.convertSunStyleToBCStyle(caIdentity.getCertificate().getSubjectDN()), currentDate);
        X509CRLHolder caBlankCrlHolder = caBlankCrlBuilder.setNextUpdate(nextYear).build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(caIdentity.getPrivateKey()));
        X509v2CRLBuilder icaBlankCrlBuilder = new X509v2CRLBuilder(SSLAuthenticationTest.convertSunStyleToBCStyle(intermediateCAIdentity.getCertificate().getSubjectDN()), currentDate);
        X509CRLHolder icaBlankCrlHolder = icaBlankCrlBuilder.setNextUpdate(nextYear).build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(intermediateCAIdentity.getPrivateKey()));
        X509v2CRLBuilder fireflyRevokedCrlBuilder = new X509v2CRLBuilder(SSLAuthenticationTest.convertSunStyleToBCStyle(caIdentity.getCertificate().getSubjectDN()), currentDate);
        fireflyRevokedCrlBuilder.addCRLEntry(caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.FIREFLY).getCertificate().getSerialNumber(), revokeDate, 0);
        X509CRLHolder fireflyRevokedCrlHolder = fireflyRevokedCrlBuilder.setNextUpdate(nextYear).build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(caIdentity.getPrivateKey()));
        DefinedCAIdentity secondCAIdentity = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.SECOND_CA);
        X509v2CRLBuilder ladybugRevokedCrlBuilder = new X509v2CRLBuilder(SSLAuthenticationTest.convertSunStyleToBCStyle(secondCAIdentity.getCertificate().getSubjectDN()), currentDate);
        ladybugRevokedCrlBuilder.addCRLEntry(caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.LADYBUG).getCertificate().getSerialNumber(), revokeDate, 0);
        X509CRLHolder ladybugRevokedCrlHolder = ladybugRevokedCrlBuilder.setNextUpdate(nextYear).build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(secondCAIdentity.getPrivateKey()));
        X509v2CRLBuilder icaRevokedCrlBuilder = new X509v2CRLBuilder(SSLAuthenticationTest.convertSunStyleToBCStyle(caIdentity.getCertificate().getSubjectDN()), currentDate);
        icaRevokedCrlBuilder.addCRLEntry(intermediateCAIdentity.getCertificate().getSerialNumber(), revokeDate, 0);
        X509CRLHolder icaRevokedCrlHolder = icaRevokedCrlBuilder.setNextUpdate(nextYear).build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(caIdentity.getPrivateKey()));
        X509v2CRLBuilder roveRevokedCrlBuilder = new X509v2CRLBuilder(SSLAuthenticationTest.convertSunStyleToBCStyle(intermediateCAIdentity.getCertificate().getSubjectDN()), currentDate);
        X509CRLHolder roveRevokedCrlHolder = roveRevokedCrlBuilder.setNextUpdate(nextYear).build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(intermediateCAIdentity.getPrivateKey()));
        PemWriter caBlankCrlOutput = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(CA_BLANK_PEM_CRL)));
        PemWriter icaBlankCrlOutput = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(ICA_BLANK_PEM_CRL)));
        PemWriter blankBlankCrlOutput = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(BLANK_BLANK_PEM_CRL)));
        PemWriter fireflyRevokedCrlOutput = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(FIREFLY_REVOKED_PEM_CRL)));
        PemWriter icaRevokedCrlOutput = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(ICA_REVOKED_PEM_CRL)));
        PemWriter ladybugRevokedCrlOutput = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(LADYBUG_REVOKED_PEM_CRL)));
        PemWriter roveRevokedCrlOutput = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(ROVE_REVOKED_PEM_CRL)));
        caBlankCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)caBlankCrlHolder));
        icaBlankCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)icaBlankCrlHolder));
        blankBlankCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)icaBlankCrlHolder));
        blankBlankCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)caBlankCrlHolder));
        fireflyRevokedCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)fireflyRevokedCrlHolder));
        icaRevokedCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)icaRevokedCrlHolder));
        roveRevokedCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)roveRevokedCrlHolder));
        roveRevokedCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)icaBlankCrlHolder));
        roveRevokedCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)caBlankCrlHolder));
        ladybugRevokedCrlOutput.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)ladybugRevokedCrlHolder));
        caBlankCrlOutput.close();
        icaBlankCrlOutput.close();
        blankBlankCrlOutput.close();
        fireflyRevokedCrlOutput.close();
        icaRevokedCrlOutput.close();
        ladybugRevokedCrlOutput.close();
        roveRevokedCrlOutput.close();
        ocspServer = new TestingOcspServer(4854);
        ocspServer.createIssuer(1, caIdentity.getCertificate());
        ocspServer.createIssuer(2, intermediateCAIdentity.getCertificate());
        ocspServer.createCertificate(1, 1, intermediateCAIdentity.getCertificate());
        ocspServer.createCertificate(2, 2, ocspCheckedGoodCertificate);
        ocspServer.createCertificate(3, 1, ocspCheckedRevokedCertificate);
        ocspServer.revokeCertificate(3, 4);
        ocspServer.start();
    }

    private static X500Name convertSunStyleToBCStyle(Principal dn) {
        String dnName = dn.getName();
        String[] dnComponents = dnName.split(", ");
        StringBuilder dnBuffer = new StringBuilder(dnName.length());
        dnBuffer.append(dnComponents[dnComponents.length - 1]);
        for (int i = dnComponents.length - 2; i >= 0; --i) {
            dnBuffer.append(',');
            dnBuffer.append(dnComponents[i]);
        }
        return new X500Name(dnBuffer.toString());
    }

    @AfterClass
    public static void afterTest() throws Exception {
        if (ocspServer != null) {
            ocspServer.stop();
        }
        SHORTWINGED_FILE.delete();
        CA_BLANK_PEM_CRL.delete();
        ICA_BLANK_PEM_CRL.delete();
        BLANK_BLANK_PEM_CRL.delete();
        FIREFLY_REVOKED_PEM_CRL.delete();
        ICA_REVOKED_PEM_CRL.delete();
        LADYBUG_REVOKED_PEM_CRL.delete();
        ROVE_REVOKED_PEM_CRL.delete();
        WORKING_DIR_CACRL.delete();
        WORKING_DIR_ICACRL.delete();
        caGenerationTool.close();
        Security.removeProvider(new BouncyCastleProvider().getName());
    }

    @Test
    public void testOneWay() throws Throwable {
        DefinedIdentity firefly = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.FIREFLY);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setKeyManager(firefly.createKeyManager()).build().create();
        this.performConnectionTest(serverContext, "protocol://test-one-way.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Firefly", null, true);
    }

    @Test
    public void testCrlBlank() throws Throwable {
        DefinedIdentity firefly = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.FIREFLY);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setKeyManager(firefly.createKeyManager()).build().create();
        this.performConnectionTest(serverContext, "protocol://test-one-way-crl.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Firefly", null, true);
    }

    @Test
    public void testServerRevoked() throws Throwable {
        DefinedIdentity firefly = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.FIREFLY);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setKeyManager(firefly.createKeyManager()).build().create();
        this.performConnectionTest(serverContext, "protocol://test-one-way-firefly-revoked.org", false, null, null, true);
    }

    @Test
    public void testServerIcaRevoked() throws Throwable {
        DefinedIdentity rove = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.ROVE);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setKeyManager(rove.createKeyManager()).build().create();
        this.performConnectionTest(serverContext, "protocol://test-one-way-ica-revoked.org", false, null, null, true);
    }

    @Test
    public void testOneWayServerRejectedWithSingleCRL() throws Throwable {
        DefinedIdentity firefly = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.FIREFLY);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setKeyManager(firefly.createKeyManager()).build().create();
        this.performConnectionTest(serverContext, "protocol://test-one-way-one-crl.org", false, null, null, true);
    }

    @Test
    public void testOneWayServerRejectedWithMultipleCRL() throws Throwable {
        DefinedIdentity firefly = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.FIREFLY);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setKeyManager(firefly.createKeyManager()).build().create();
        this.performConnectionTest(serverContext, "protocol://test-one-way-multiple-crls-failure.org", false, null, null, true);
    }

    @Test
    public void testOneWayServerAcceptedWithMultipleCRL() throws Throwable {
        DefinedIdentity greenJune = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.GREENJUNE);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setKeyManager(greenJune.createKeyManager()).build().create();
        this.performConnectionTest(serverContext, "protocol://test-one-way-multiple-crls-success.org", true, "OU=Wildfly,O=Wildfly,C=CA,ST=Wildfly,CN=Green June", null, true);
    }

    @Test
    public void testCRLMaxCertPathSucceeds() throws Throwable {
        DefinedIdentity rove = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.ROVE);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setKeyManager(rove.createKeyManager()).build().create();
        this.performConnectionTest(serverContext, "protocol://test-one-way-max-cert-path.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Rove", null, true);
    }

    @Test
    public void testCRLMaxCertPathFails() throws Throwable {
        DefinedIdentity rove = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.ROVE);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setKeyManager(rove.createKeyManager()).build().create();
        this.performConnectionTest(serverContext, "protocol://test-one-way-max-cert-path-failure.org", false, null, null, true);
    }

    @Test
    public void testTwoWay() throws Throwable {
        DefinedCAIdentity ca = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.CA);
        DefinedIdentity scarab = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.SCARAB);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(SSLAuthenticationTest.getKeyStoreBackedSecurityDomain(caGenerationTool.getBeetlesKeyStore())).setKeyManager(scarab.createKeyManager()).setTrustManager(ca.createTrustManager()).setNeedClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-two-way.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Scarab", "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Ladybird", false);
    }

    @Test
    public void testTwoWayNoDecoder() throws Throwable {
        DefinedCAIdentity ca = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.CA);
        DefinedIdentity scarab = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.SCARAB);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(SSLAuthenticationTest.getKeyStoreBackedSecurityDomain(caGenerationTool.getBeetlesKeyStore(), false)).setKeyManager(scarab.createKeyManager()).setTrustManager(ca.createTrustManager()).setNeedClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-two-way.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Scarab", "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Ladybird", false);
    }

    @Test
    public void testTwoWayIca() throws Throwable {
        DefinedCAIdentity ca = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.CA);
        DefinedIdentity scarab = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.SCARAB);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(SSLAuthenticationTest.getKeyStoreBackedSecurityDomain(shortWingedKeyStore)).setKeyManager(scarab.createKeyManager()).setTrustManager(ca.createTrustManager()).setNeedClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-two-way-ica.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Scarab", "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Rove", false);
    }

    @Test
    public void testAcceptedIssuersConfiguredWithCRL() throws Throwable {
        FileInputStream crl = new FileInputStream("./target/test-classes/ica/crl/blank-blank.pem");
        DefinedCAIdentity ca = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.CA);
        X509RevocationTrustManager trustManager = X509RevocationTrustManager.builder().setTrustManagerFactory(SSLAuthenticationTest.getTrustManagerFactory()).setTrustStore(ca.loadKeyStore()).setCrlStream((InputStream)crl).setPreferCrls(true).setNoFallback(true).build();
        org.wildfly.common.Assert.assertTrue((trustManager.getAcceptedIssuers().length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTwoWayClientRejectedWithSingleCRL() throws Throwable {
        ArrayList<FileInputStream> crlStreams = new ArrayList<FileInputStream>();
        crlStreams.add(new FileInputStream("target/test-classes/ca/crl/ladybug-revoked.pem"));
        DefinedCAIdentity secondCA = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.SECOND_CA);
        DefinedIdentity firefly = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.FIREFLY);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setKeyManager(firefly.createKeyManager()).setTrustManager((X509TrustManager)X509RevocationTrustManager.builder().setTrustManagerFactory(SSLAuthenticationTest.getTrustManagerFactory()).setTrustStore(secondCA.loadKeyStore()).setCrlStreams(crlStreams).setPreferCrls(true).setNoFallback(true).build()).setNeedClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-two-way-no-crl-failure.org", false, null, null, false);
    }

    @Test
    public void testTwoWayClientAcceptedWithSingleCRL() throws Throwable {
        ArrayList<FileInputStream> crlStreams = new ArrayList<FileInputStream>();
        crlStreams.add(new FileInputStream("target/test-classes/ca/crl/ladybug-revoked.pem"));
        DefinedCAIdentity secondCA = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.SECOND_CA);
        DefinedIdentity firefly = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.FIREFLY);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(SSLAuthenticationTest.getKeyStoreBackedSecurityDomain(caGenerationTool.getBeetlesKeyStore())).setKeyManager(firefly.createKeyManager()).setTrustManager((X509TrustManager)X509RevocationTrustManager.builder().setTrustManagerFactory(SSLAuthenticationTest.getTrustManagerFactory()).setTrustStore(secondCA.loadKeyStore()).setCrlStreams(crlStreams).setPreferCrls(true).setNoFallback(true).build()).setNeedClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-two-way-no-crl-success.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Firefly", "OU=Wildfly,O=Wildfly,C=CA,ST=Wildfly,CN=Green June", false);
    }

    @Test
    public void testTwoWayClientRejectedWithMultipleCRL() throws Throwable {
        ArrayList<FileInputStream> crlStreams = new ArrayList<FileInputStream>();
        crlStreams.add(new FileInputStream("target/test-classes/ca/crl/ladybug-revoked.pem"));
        crlStreams.add(new FileInputStream("target/test-classes/ca/crl/firefly-revoked.pem"));
        DefinedCAIdentity secondCA = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.SECOND_CA);
        DefinedIdentity firefly = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.FIREFLY);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setKeyManager(firefly.createKeyManager()).setTrustManager((X509TrustManager)X509RevocationTrustManager.builder().setTrustManagerFactory(SSLAuthenticationTest.getTrustManagerFactory()).setTrustStore(secondCA.loadKeyStore()).setCrlStreams(crlStreams).setPreferCrls(true).setNoFallback(true).build()).setNeedClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-two-way-no-crl-failure.org", false, null, null, false);
    }

    @Test
    public void testTwoWayClientAcceptedWithMultipleCRL() throws Throwable {
        ArrayList<FileInputStream> crlStreams = new ArrayList<FileInputStream>();
        crlStreams.add(new FileInputStream("target/test-classes/ca/crl/ladybug-revoked.pem"));
        crlStreams.add(new FileInputStream("target/test-classes/ca/crl/firefly-revoked.pem"));
        DefinedCAIdentity secondCA = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.SECOND_CA);
        DefinedIdentity firefly = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.FIREFLY);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(SSLAuthenticationTest.getKeyStoreBackedSecurityDomain(caGenerationTool.getBeetlesKeyStore())).setKeyManager(firefly.createKeyManager()).setTrustManager((X509TrustManager)X509RevocationTrustManager.builder().setTrustManagerFactory(SSLAuthenticationTest.getTrustManagerFactory()).setTrustStore(secondCA.loadKeyStore()).setCrlStreams(crlStreams).setPreferCrls(true).setNoFallback(true).build()).setNeedClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-two-way-no-crl-success.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Firefly", "OU=Wildfly,O=Wildfly,C=CA,ST=Wildfly,CN=Green June", false);
    }

    @Test
    public void testOcspGood() throws Throwable {
        DefinedCAIdentity ca = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.CA);
        DefinedIdentity scarab = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.SCARAB);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(SSLAuthenticationTest.getKeyStoreBackedSecurityDomain(caGenerationTool.getBeetlesKeyStore())).setKeyManager(scarab.createKeyManager()).setTrustManager((X509TrustManager)X509RevocationTrustManager.builder().setTrustManagerFactory(SSLAuthenticationTest.getTrustManagerFactory()).setTrustStore(ca.loadKeyStore()).setOcspResponderCert(ocspResponderCertificate).build()).setNeedClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-two-way-ocsp-good.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Scarab", "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=ocspCheckedGood", false);
    }

    @Test
    public void testOcspRevoked() throws Throwable {
        DefinedCAIdentity ca = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.CA);
        DefinedIdentity scarab = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.SCARAB);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(SSLAuthenticationTest.getKeyStoreBackedSecurityDomain(caGenerationTool.getBeetlesKeyStore())).setKeyManager(scarab.createKeyManager()).setTrustManager((X509TrustManager)X509RevocationTrustManager.builder().setTrustManagerFactory(SSLAuthenticationTest.getTrustManagerFactory()).setTrustStore(ca.loadKeyStore()).setOcspResponderCert(ocspResponderCertificate).build()).setNeedClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-two-way-ocsp-revoked.org", false, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Scarab", "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=ocspCheckedRevoked", false);
    }

    @Test
    public void testOcspUnknown() throws Throwable {
        DefinedCAIdentity ca = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.CA);
        DefinedIdentity scarab = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.SCARAB);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(SSLAuthenticationTest.getKeyStoreBackedSecurityDomain(caGenerationTool.getBeetlesKeyStore())).setKeyManager(scarab.createKeyManager()).setTrustManager((X509TrustManager)X509RevocationTrustManager.builder().setTrustManagerFactory(SSLAuthenticationTest.getTrustManagerFactory()).setTrustStore(ca.loadKeyStore()).setOcspResponderCert(ocspResponderCertificate).build()).setNeedClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-two-way-ocsp-unknown.org", false, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Scarab", "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=ocspCheckedUnknown", false);
    }

    @Test
    public void testOcspMaxCertPathNeg1() throws Throwable {
        this.ocspMaxCertPathCommon(-1, false);
    }

    @Test
    public void testOcspMaxCertPath0() throws Throwable {
        this.ocspMaxCertPathCommon(0, false);
    }

    @Test
    public void testOcspMaxCertPathTooLong() throws Throwable {
        this.ocspMaxCertPathCommon(1, false);
    }

    @Test
    public void testOcspMaxCertPathOkay() throws Throwable {
        this.ocspMaxCertPathCommon(2, true);
    }

    private void ocspMaxCertPathCommon(int maxCertPath, boolean expectValid) throws Throwable {
        DefinedCAIdentity ca = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.CA);
        DefinedIdentity scarab = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.SCARAB);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(SSLAuthenticationTest.getKeyStoreBackedSecurityDomain(caGenerationTool.getBeetlesKeyStore())).setKeyManager(scarab.createKeyManager()).setTrustManager((X509TrustManager)X509RevocationTrustManager.builder().setTrustManagerFactory(SSLAuthenticationTest.getTrustManagerFactory()).setTrustStore(ca.loadKeyStore()).setOcspResponderCert(ocspResponderCertificate).setMaxCertPath(maxCertPath).build()).setNeedClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-two-way-ocsp-good.org", expectValid, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Scarab", "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=ocspCheckedGood", false);
    }

    @Test
    public void testClientSideOcsp() throws Throwable {
        SSLContext serverContextGood = (SSLContext)new SSLContextBuilder().setKeyManager(goodIdentity.createKeyManager()).build().create();
        SSLContext serverContextRevoked = (SSLContext)new SSLContextBuilder().setKeyManager(revokedIdentity.createKeyManager()).build().create();
        DefinedCAIdentity ca = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.CA);
        SSLContext clientContext = (SSLContext)new SSLContextBuilder().setTrustManager((X509TrustManager)X509RevocationTrustManager.builder().setTrustManagerFactory(SSLAuthenticationTest.getTrustManagerFactory()).setTrustStore(ca.loadKeyStore()).setOcspResponderCert(ocspResponderCertificate).build()).setClientMode(true).build().create();
        this.testCommunication(serverContextGood, clientContext, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=ocspCheckedGood", null, true);
        try {
            this.testCommunication(serverContextRevoked, clientContext, null, null, true);
            Assert.fail((String)"Expected SSLHandshakeException not thrown");
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            // empty catch block
        }
    }

    @Test
    public void testWantClientAuthWithCorrectCertificate() throws Throwable {
        DefinedCAIdentity ca = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.CA);
        DefinedIdentity scarab = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.SCARAB);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(SSLAuthenticationTest.getKeyStoreBackedSecurityDomain(caGenerationTool.getBeetlesKeyStore())).setKeyManager(scarab.createKeyManager()).setTrustManager(ca.createTrustManager()).setWantClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-two-way.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Scarab", "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Ladybird", false);
    }

    @Test
    public void testWantClientAuthWithIncorrectCertificate() throws Throwable {
        DefinedCAIdentity ca = caGenerationTool.getDefinedCAIdentity(CAGenerationTool.Identity.CA);
        DefinedIdentity scarab = caGenerationTool.getDefinedIdentity(CAGenerationTool.Identity.SCARAB);
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(SSLAuthenticationTest.getKeyStoreBackedSecurityDomain(caGenerationTool.getBeetlesKeyStore())).setKeyManager(scarab.createKeyManager()).setTrustManager(ca.createTrustManager()).setWantClientAuth(true).build().create();
        this.performConnectionTest(serverContext, "protocol://test-one-way.org", true, "OU=Elytron,O=Elytron,C=UK,ST=Elytron,CN=Scarab", null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performConnectionTest(SSLContext serverContext, String clientUri, boolean expectValid, String expectedServerPrincipal, String expectedClientPrincipal, boolean oneWay) throws Throwable {
        System.setProperty("wildfly.config.url", SSLAuthenticationTest.class.getResource("ssl-authentication-config.xml").toExternalForm());
        AccessController.doPrivileged(() -> Security.insertProviderAt((Provider)WildFlyElytronPasswordProvider.getInstance(), 1));
        AuthenticationContext context = (AuthenticationContext)AuthenticationContext.getContextManager().get();
        AuthenticationContextConfigurationClient contextConfigurationClient = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
        SSLContext clientContext = contextConfigurationClient.getSSLContext(URI.create(clientUri), context);
        try {
            this.testCommunication(serverContext, clientContext, expectedServerPrincipal, expectedClientPrincipal, oneWay);
            if (!expectValid) {
                Assert.fail((String)"Expected SSLHandshakeException not thrown");
            }
        }
        catch (SocketException | SSLHandshakeException expected) {
            if (expectValid) {
                throw new IllegalStateException("Unexpected SSLHandshakeException", expected);
            }
        }
        catch (SSLException expected) {
            if (expectValid) {
                throw new IllegalStateException("Unexpected SSLException", expected);
            }
            if (expected.getCause() instanceof SocketException) {
                // empty if block
            }
        }
        finally {
            System.clearProperty("wildfly.config.url");
            Security.removeProvider(WildFlyElytronPasswordProvider.getInstance().getName());
        }
    }

    private void testCommunication(SSLContext serverContext, SSLContext clientContext, String expectedServerPrincipal, String expectedClientPrincipal, boolean oneWay) throws Throwable {
        ServerSocket listeningSocket = serverContext.getServerSocketFactory().createServerSocket();
        listeningSocket.bind(new InetSocketAddress("localhost", 18201));
        SSLSocket clientSocket = (SSLSocket)clientContext.getSocketFactory().createSocket("localhost", 18201);
        SSLSocket serverSocket = (SSLSocket)listeningSocket.accept();
        ExecutorService serverExecutorService = Executors.newSingleThreadExecutor();
        Future<byte[]> serverFuture = serverExecutorService.submit(() -> {
            try {
                byte[] received = new byte[2];
                serverSocket.getInputStream().read(received);
                serverSocket.getOutputStream().write(new byte[]{86, 120});
                if (expectedClientPrincipal != null) {
                    Assert.assertEquals((Object)expectedClientPrincipal, (Object)serverSocket.getSession().getPeerPrincipal().getName());
                }
                SecurityIdentity identity = (SecurityIdentity)serverSocket.getSession().getValue("org.wildfly.security.ssl.identity");
                if (oneWay) {
                    Assert.assertNull((Object)identity);
                } else {
                    Assert.assertNotNull((Object)identity);
                }
                return received;
            }
            catch (Exception e) {
                throw new RuntimeException("Server exception", e);
            }
        });
        ExecutorService clientExecutorService = Executors.newSingleThreadExecutor();
        Future<byte[]> clientFuture = clientExecutorService.submit(() -> {
            try {
                byte[] received = new byte[2];
                clientSocket.getOutputStream().write(new byte[]{18, 52});
                clientSocket.getInputStream().read(received);
                if (expectedServerPrincipal != null) {
                    Assert.assertEquals((Object)expectedServerPrincipal, (Object)clientSocket.getSession().getPeerPrincipal().getName());
                }
                if (oneWay) {
                    Assert.assertNotEquals((Object)"TLSv1.3", (Object)clientSocket.getSession().getProtocol());
                } else {
                    Assert.assertNotEquals((Object)"TLSv1.3", (Object)serverSocket.getSession().getProtocol());
                    Assert.assertNotEquals((Object)"TLSv1.3", (Object)clientSocket.getSession().getProtocol());
                }
                return received;
            }
            catch (Exception e) {
                throw new RuntimeException("Client exception", e);
            }
        });
        try {
            Assert.assertArrayEquals((byte[])new byte[]{18, 52}, (byte[])serverFuture.get());
            Assert.assertArrayEquals((byte[])new byte[]{86, 120}, (byte[])clientFuture.get());
        }
        catch (ExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof RuntimeException && e.getCause().getCause() != null) {
                throw e.getCause().getCause();
            }
            throw e;
        }
        finally {
            this.safeClose(serverSocket);
            this.safeClose(clientSocket);
            this.safeClose(listeningSocket);
        }
    }

    private void safeClose(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

