/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;

public class TestClock
extends Clock {
    private volatile Instant instant;
    private final Object instantLock = new Object();
    private final ZoneId zone;

    public TestClock(Instant instant) {
        this(ZoneOffset.UTC);
        this.instant = instant;
    }

    private TestClock(ZoneId zone) {
        this.zone = zone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TestClock) {
            return this.zone.equals(((TestClock)obj).zone);
        }
        return false;
    }

    @Override
    public ZoneId getZone() {
        return this.zone;
    }

    @Override
    public int hashCode() {
        return this.zone.hashCode() + 1;
    }

    @Override
    public Instant instant() {
        return this.instant;
    }

    @Override
    public long millis() {
        return this.instant.toEpochMilli();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestClock minus(long amountToSubtract, TemporalUnit unit) {
        Object object = this.instantLock;
        synchronized (object) {
            this.instant = this.instant.minus(amountToSubtract, unit);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestClock minus(TemporalAmount amountToSubtract) {
        Object object = this.instantLock;
        synchronized (object) {
            this.instant = this.instant.minus(amountToSubtract);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestClock minusMillis(long millisToSubtract) {
        Object object = this.instantLock;
        synchronized (object) {
            this.instant = this.instant.minusMillis(millisToSubtract);
        }
        return this;
    }

    public TestClock minusNanos(long nanosToSubtract) {
        this.instant = this.instant.minusNanos(nanosToSubtract);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestClock minusSeconds(long secondsToSubtract) {
        Object object = this.instantLock;
        synchronized (object) {
            this.instant = this.instant.minusSeconds(secondsToSubtract);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestClock plus(long amountToAdd, TemporalUnit unit) {
        Object object = this.instantLock;
        synchronized (object) {
            this.instant = this.instant.plus(amountToAdd, unit);
        }
        return this;
    }

    public TestClock plus(TemporalAmount amountToAdd) {
        this.instant = this.instant.plus(amountToAdd);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestClock plusMillis(long millisToAdd) {
        Object object = this.instantLock;
        synchronized (object) {
            this.instant = this.instant.plusMillis(millisToAdd);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestClock plusNanos(long nanosToAdd) {
        Object object = this.instantLock;
        synchronized (object) {
            this.instant = this.instant.plusNanos(nanosToAdd);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestClock plusSeconds(long secondsToAdd) {
        Object object = this.instantLock;
        synchronized (object) {
            this.instant = this.instant.plusSeconds(secondsToAdd);
        }
        return this;
    }

    public String toString() {
        return "TestClock [instant=" + String.valueOf(this.instant) + ", zone=" + String.valueOf(this.zone) + "]";
    }

    @Override
    public Clock withZone(ZoneId zone) {
        if (zone.equals(this.zone)) {
            return this;
        }
        return new TestClock(zone);
    }
}

