/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.source.impl;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Provider;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.impl.CommandCredentialSource;
import org.wildfly.security.credential.source.impl.CredentialCommand;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.interfaces.ClearPassword;

public class CommandCredentialSourceTest {
    @Test
    public void testCommand() throws GeneralSecurityException, IOException {
        CommandCredentialSource.Builder builder = CommandCredentialSourceTest.getBuilder();
        builder.addCommand("secret_key_THREE");
        CommandCredentialSource credentialSource = builder.build();
        PasswordCredential credential = (PasswordCredential)credentialSource.getCredential(PasswordCredential.class);
        Assert.assertNotNull((Object)credential);
        Password password = (Password)credential.castAndApply(PasswordCredential.class, "clear", PasswordCredential::getPassword);
        Assert.assertNotNull((Object)password);
        ClearPassword clearPassword = (ClearPassword)password.castAs(ClearPassword.class, "clear");
        Assert.assertNotNull((Object)clearPassword);
        Assert.assertEquals((Object)"secret_key_THREE", (Object)new String(clearPassword.getPassword()));
    }

    private static CommandCredentialSource.Builder getBuilder() {
        CommandCredentialSource.Builder builder = CommandCredentialSource.builder();
        builder.setPasswordFactoryProvider((Provider)WildFlyElytronPasswordProvider.getInstance());
        CommandCredentialSourceTest.addJava(builder);
        CommandCredentialSourceTest.addCommand(builder);
        return builder;
    }

    private static void addJava(CommandCredentialSource.Builder builder) {
        File java = new File(System.getProperty("java.home"), "/bin/java");
        File javaExe = new File(System.getProperty("java.home"), "/bin/java.exe");
        builder.addCommand(java.exists() ? java.getAbsolutePath() : javaExe.getAbsolutePath());
    }

    private static void addCommand(CommandCredentialSource.Builder builder) {
        builder.addCommand("-cp").addCommand(System.getProperty("java.class.path")).addCommand(CredentialCommand.class.getName());
    }

    private static String buildExternalCommand(String extOption, String delimiter, String argument) {
        File java = new File(System.getProperty("java.home"), "/bin/java");
        File javaExe = new File(System.getProperty("java.home"), "/bin/java.exe");
        String jre = java.exists() ? java.getAbsolutePath() : javaExe.getAbsolutePath();
        String cmd = jre + delimiter + "-cp" + delimiter + System.getProperty("java.class.path") + delimiter + CredentialCommand.class.getName() + (String)(argument != null ? delimiter + argument : "");
        return extOption + cmd;
    }
}

