/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xnio.IoUtils;

public abstract class SimpleSyslogServer
implements Runnable {
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    protected final BlockingQueue<byte[]> receivedData = new LinkedBlockingQueue<byte[]>();

    SimpleSyslogServer() {
    }

    static SimpleSyslogServer createUdp(int port) throws IOException {
        Udp server = new Udp(port);
        Thread t = new Thread(server);
        t.start();
        return server;
    }

    static SimpleSyslogServer createTcp(int port, boolean octetCounting) throws IOException {
        Tcp server = new Tcp(new ServerSocket(port), octetCounting);
        Thread t = new Thread(server);
        t.start();
        return server;
    }

    abstract void close();

    byte[] receiveData() throws InterruptedException {
        return this.receivedData.poll(20L, TimeUnit.SECONDS);
    }

    byte[] pollData() {
        return (byte[])this.receivedData.poll();
    }

    private static class Tcp
    extends SimpleSyslogServer {
        private final boolean octetCounting;
        private final ServerSocket serverSocket;
        private volatile Socket socket;

        Tcp(ServerSocket servetSocket, boolean octetCounting) {
            this.serverSocket = servetSocket;
            this.octetCounting = octetCounting;
        }

        @Override
        void close() {
            this.closed.set(true);
            IoUtils.safeClose((ServerSocket)this.serverSocket);
            IoUtils.safeClose((Socket)this.socket);
        }

        Socket accept(ServerSocket serverSocket) throws IOException {
            return serverSocket.accept();
        }

        @Override
        public void run() {
            block18: {
                try {
                    this.socket = this.accept(this.serverSocket);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
                try {
                    BufferedInputStream in = new BufferedInputStream(this.socket.getInputStream());
                    while (!this.closed.get()) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        if (this.octetCounting) {
                            int i = ((InputStream)in).read();
                            int length = -1;
                            int count = 0;
                            while (i != -1 && (length == -1 || count++ <= length)) {
                                if (length == -1 && (char)i == ' ') {
                                    byte[] bytes = out.toByteArray();
                                    length = 0;
                                    for (int j = 0; j < bytes.length; ++j) {
                                        length = length * 10 + bytes[j] - Character.valueOf('0').charValue();
                                    }
                                    out.reset();
                                    continue;
                                }
                                out.write(i);
                                if (length == -1 || count <= length) {
                                    i = ((InputStream)in).read();
                                    continue;
                                }
                                break;
                            }
                        } else {
                            int braceCount = 0;
                            int i = ((InputStream)in).read();
                            while (i != -1) {
                                out.write(i);
                                if ((char)i == '{') {
                                    ++braceCount;
                                    break;
                                }
                                i = ((InputStream)in).read();
                            }
                            i = ((InputStream)in).read();
                            while (i != -1) {
                                char c = (char)i;
                                if (c == '{') {
                                    ++braceCount;
                                }
                                if (c == '}') {
                                    --braceCount;
                                }
                                out.write(i);
                                if (c != '\n' || braceCount != 0) {
                                    i = ((InputStream)in).read();
                                    continue;
                                }
                                break;
                            }
                        }
                        if (out.toByteArray() == null || out.toByteArray().length <= 0) continue;
                        this.receivedData.add(out.toByteArray());
                    }
                }
                catch (IOException e) {
                    if (this.closed.get()) break block18;
                    e.printStackTrace();
                    this.close();
                }
            }
        }
    }

    private static class Udp
    extends SimpleSyslogServer {
        private final DatagramSocket socket;

        Udp(int port) throws IOException {
            this.socket = new DatagramSocket(port);
        }

        @Override
        void close() {
            this.closed.set(true);
            this.socket.close();
        }

        @Override
        public void run() {
            while (!this.closed.get()) {
                try {
                    DatagramPacket packet = new DatagramPacket(new byte[2048], 2048);
                    this.socket.receive(packet);
                    byte[] bytes = new byte[packet.getLength()];
                    System.arraycopy(packet.getData(), 0, bytes, 0, packet.getLength());
                    this.receivedData.add(bytes);
                }
                catch (IOException e) {
                    if (this.closed.get()) continue;
                    e.printStackTrace();
                    this.close();
                }
            }
        }
    }
}

