/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Map;
import org.junit.Assert;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.matchers.Times;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.NottableString;
import org.wildfly.common.iteration.ByteIterator;
import org.xipki.datasource.DataSourceFactory;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.http.servlet.ServletURI;
import org.xipki.http.servlet.SslReverseProxyMode;
import org.xipki.ocsp.server.impl.HttpOcspServlet;
import org.xipki.ocsp.server.impl.OcspServer;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SecurityFactoryImpl;
import org.xipki.security.SignerFactoryRegister;
import org.xipki.security.SignerFactoryRegisterImpl;

public class TestingOcspServer {
    private int port;
    private OcspServer ocspServer = null;
    private ClientAndServer server;
    private Connection connection;
    private SecurityFactoryImpl securityFactory = new SecurityFactoryImpl();

    public TestingOcspServer(int port) throws Exception {
        this.port = port;
        this.initDatabase();
    }

    private void initDatabase() throws Exception {
        DataSourceFactory dataSourceFactory = new DataSourceFactory();
        DataSourceWrapper dataSourceWrapper = dataSourceFactory.createDataSource("datasource1", TestingOcspServer.class.getResource("ocsp-db.properties").openStream(), this.securityFactory.getPasswordResolver());
        this.connection = dataSourceWrapper.getConnection();
        this.connection.prepareStatement("CREATE TABLE ISSUER (\n    ID INT NOT NULL,\n    SUBJECT VARCHAR(350) NOT NULL,\n    NBEFORE BIGINT NOT NULL,\n    NAFTER BIGINT NOT NULL,\n    S1C CHAR(28) NOT NULL,\n    REV SMALLINT DEFAULT 0,\n    RR SMALLINT,\n    RT BIGINT,\n    RIT BIGINT,\n    CERT VARCHAR(4000) NOT NULL,\n    CRL_INFO VARCHAR(1000)\n);").execute();
        this.connection.prepareStatement("CREATE TABLE CERT (\n    ID BIGINT NOT NULL,\n    IID INT NOT NULL,\n    SN VARCHAR(40) NOT NULL,\n    LUPDATE BIGINT NOT NULL,\n    NBEFORE BIGINT,\n    NAFTER BIGINT,\n    REV SMALLINT DEFAULT 0,\n    RR SMALLINT,\n    RT BIGINT,\n    RIT BIGINT,\n    PN VARCHAR(45)\n);").execute();
    }

    public void start() throws Exception {
        Assert.assertNull((String)"OCSP server already started", (Object)this.ocspServer);
        this.ocspServer = new OcspServer();
        this.ocspServer.setConfFile(TestingOcspServer.class.getResource("ocsp-responder.xml").getFile());
        this.securityFactory.setSignerFactoryRegister((SignerFactoryRegister)new SignerFactoryRegisterImpl());
        this.ocspServer.setSecurityFactory((SecurityFactory)this.securityFactory);
        this.ocspServer.init();
        HttpOcspServlet servlet = new HttpOcspServlet();
        servlet.setServer(this.ocspServer);
        this.server = new ClientAndServer(new Integer[]{this.port});
        this.server.when(HttpRequest.request().withMethod("POST").withPath("/ocsp"), Times.unlimited()).respond(request -> this.getHttpResponse(request, servlet));
        this.server.when(HttpRequest.request().withMethod("GET").withPath("/ocsp/.*"), Times.unlimited()).respond(request -> this.getHttpResponse(request, servlet));
    }

    public void stop() throws SQLException {
        Assert.assertNotNull((String)"OCSP server not started", (Object)this.ocspServer);
        this.server.stop();
        this.ocspServer.shutdown();
        this.connection.close();
        this.ocspServer = null;
    }

    public void createIssuer(int id, X509Certificate issuer) throws SQLException, CertificateException, NoSuchAlgorithmException {
        Assert.assertNull((String)"OCSP server already started", (Object)this.ocspServer);
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        PreparedStatement statement = this.connection.prepareStatement("INSERT INTO ISSUER (ID, SUBJECT, NBEFORE, NAFTER, S1C, CERT) VALUES (?, ?, ?, ?, ?, ?)");
        statement.setInt(1, id);
        statement.setString(2, issuer.getSubjectDN().toString());
        statement.setLong(3, issuer.getNotBefore().toInstant().getEpochSecond());
        statement.setLong(4, issuer.getNotAfter().toInstant().getEpochSecond());
        statement.setString(5, ByteIterator.ofBytes((byte[])digest.digest(issuer.getEncoded())).base64Encode().drainToString());
        statement.setString(6, ByteIterator.ofBytes((byte[])issuer.getEncoded()).base64Encode().drainToString());
        statement.execute();
    }

    public void createCertificate(int id, int issuerId, X509Certificate certificate) throws SQLException {
        long time = Instant.now().getEpochSecond();
        PreparedStatement statement = this.connection.prepareStatement("INSERT INTO CERT (ID, IID, SN, LUPDATE, NBEFORE, NAFTER) VALUES (?, ?, ?, ?, ?, ?)");
        statement.setInt(1, id);
        statement.setInt(2, issuerId);
        statement.setString(3, certificate.getSerialNumber().toString(16));
        statement.setLong(4, time);
        statement.setLong(5, certificate.getNotBefore().toInstant().getEpochSecond());
        statement.setLong(6, certificate.getNotAfter().toInstant().getEpochSecond());
        statement.execute();
    }

    public void revokeCertificate(int id, int reason) throws SQLException {
        long time = Instant.now().getEpochSecond();
        PreparedStatement statement = this.connection.prepareStatement("UPDATE CERT SET REV = 1, RR = ?, RT = ?, RIT = ? WHERE ID = ?");
        statement.setInt(1, reason);
        statement.setLong(2, time);
        statement.setLong(3, time);
        statement.setInt(4, id);
        statement.execute();
    }

    public HttpResponse getHttpResponse(HttpRequest request, HttpOcspServlet servlet) {
        FullHttpResponse nettyResponse;
        byte[] body;
        HttpMethod method;
        if (request.getBody() == null) {
            method = HttpMethod.GET;
            body = request.getPath().getValue().split("/ocsp/", 2)[1].getBytes(StandardCharsets.UTF_8);
        } else {
            method = HttpMethod.POST;
            body = request.getBody().getRawBytes();
        }
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])body);
        DefaultFullHttpRequest nettyRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_0, method, request.getPath().getValue(), buffer);
        for (Header header : request.getHeaderList()) {
            for (NottableString value : header.getValues()) {
                nettyRequest.headers().add(header.getName().getValue(), (Object)value.getValue());
            }
        }
        try {
            nettyResponse = servlet.service((FullHttpRequest)nettyRequest, new ServletURI(request.getPath().getValue()), null, SslReverseProxyMode.NONE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HttpResponse response = HttpResponse.response().withStatusCode(Integer.valueOf(nettyResponse.status().code())).withBody(nettyResponse.content().array());
        for (Map.Entry header : nettyResponse.headers()) {
            response.withHeader((String)header.getKey(), new String[]{(String)header.getValue()});
        }
        return response;
    }
}

