/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;

public class AdHocIdentityTest {
    @Test
    public void testAdHocIdentityWithoutSecurityIdentityTransformer() {
        SecurityDomain domain = AdHocIdentityTest.getSecurityDomain(null);
        SecurityIdentity identity = domain.createAdHocIdentity("alice");
        Assert.assertNotNull((Object)identity);
        Assert.assertEquals((Object)"alice", (Object)identity.getPrincipal().getName());
        Assert.assertTrue((boolean)identity.getRoles().isEmpty());
    }

    @Test
    public void testAdHocIdentityWithSecurityIdentityTransformer() {
        SecurityDomain domain = AdHocIdentityTest.getSecurityDomain(securityIdentity -> securityIdentity.withDefaultRoleMapper(RoleMapper.constant((Roles)Roles.of((String)"constantRole"))));
        SecurityIdentity identity = domain.createAdHocIdentity("alice");
        Assert.assertNotNull((Object)identity);
        Assert.assertEquals((Object)"alice", (Object)identity.getPrincipal().getName());
        Assert.assertTrue((boolean)identity.getRoles().contains("constantRole"));
    }

    @Test
    public void testAdHocIdentityWithComplexSecurityIdentityTransformer() {
        SecurityDomain outflowDomain = AdHocIdentityTest.getSecurityDomain(AdHocIdentityTest.getRealm(), null);
        SecurityDomain domain = AdHocIdentityTest.getSecurityDomain(securityIdentity -> this.outflow((SecurityIdentity)securityIdentity, outflowDomain));
        SecurityIdentity identity = domain.createAdHocIdentity("joe");
        Assert.assertNotNull((Object)identity);
        Assert.assertEquals((Object)"joe", (Object)identity.getPrincipal().getName());
        Assert.assertEquals((Object)domain, (Object)identity.getSecurityDomain());
        Assert.assertEquals((Object)outflowDomain.getAnonymousSecurityIdentity(), (Object)outflowDomain.getCurrentSecurityIdentity());
        SecurityIdentity outflowDomainIdentity = (SecurityIdentity)identity.runAsSupplierEx(() -> outflowDomain.getCurrentSecurityIdentity());
        Assert.assertEquals((Object)"joe", (Object)outflowDomainIdentity.getPrincipal().getName());
        Assert.assertTrue((boolean)outflowDomainIdentity.getRoles().contains("User"));
    }

    @Test
    public void testAdHocIdentityWithComplexSecurityIdentityTransformerAndDefaultRoleMapper() {
        SecurityDomain outflowDomain = AdHocIdentityTest.getSecurityDomain(AdHocIdentityTest.getRealm(), null);
        SecurityDomain domain = AdHocIdentityTest.getSecurityDomain(securityIdentity -> this.outflow((SecurityIdentity)securityIdentity, outflowDomain));
        SecurityIdentity identity = domain.createAdHocIdentity("joe");
        Assert.assertNotNull((Object)identity);
        Assert.assertEquals((Object)"joe", (Object)identity.getPrincipal().getName());
        Assert.assertEquals((Object)domain, (Object)identity.getSecurityDomain());
        identity = identity.withDefaultRoleMapper(RoleMapper.constant((Roles)Roles.of((String)"constantRole")));
        Assert.assertTrue((boolean)identity.getRoles().contains("constantRole"));
        Assert.assertEquals((Object)outflowDomain.getAnonymousSecurityIdentity(), (Object)outflowDomain.getCurrentSecurityIdentity());
        SecurityIdentity outflowDomainIdentity = (SecurityIdentity)identity.runAsSupplierEx(() -> outflowDomain.getCurrentSecurityIdentity());
        Assert.assertEquals((Object)"joe", (Object)outflowDomainIdentity.getPrincipal().getName());
        Assert.assertTrue((boolean)outflowDomainIdentity.getRoles().contains("User"));
        Assert.assertFalse((boolean)outflowDomainIdentity.getRoles().contains("constantRole"));
    }

    private static void addUser(Map<String, SimpleRealmEntry> securityRealm, String userName, String roles) {
        MapAttributes attributes = new MapAttributes();
        attributes.addAll("Roles", Collections.singletonList(roles));
        securityRealm.put(userName, new SimpleRealmEntry(Collections.emptyList(), (Attributes)attributes));
    }

    private static SecurityDomain getSecurityDomain(UnaryOperator<SecurityIdentity> securityIdentityTransformer) {
        return AdHocIdentityTest.getSecurityDomain(null, securityIdentityTransformer);
    }

    private static SecurityDomain getSecurityDomain(SecurityRealm realm, UnaryOperator<SecurityIdentity> securityIdentityTransformer) {
        SecurityDomain.Builder securityDomainBuilder = SecurityDomain.builder();
        if (realm != null) {
            securityDomainBuilder.addRealm("default", realm).build();
            securityDomainBuilder.setDefaultRealmName("default");
            securityDomainBuilder.setTrustedSecurityDomainPredicate(securityDomain -> true);
        }
        securityDomainBuilder.setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance());
        if (securityIdentityTransformer != null) {
            securityDomainBuilder.setSecurityIdentityTransformer(securityIdentityTransformer);
        }
        return securityDomainBuilder.build();
    }

    private static SecurityRealm getRealm() {
        SimpleMapBackedSecurityRealm realm = new SimpleMapBackedSecurityRealm();
        HashMap<String, SimpleRealmEntry> users = new HashMap<String, SimpleRealmEntry>();
        AdHocIdentityTest.addUser(users, "joe", "User");
        AdHocIdentityTest.addUser(users, "bob", "User");
        realm.setIdentityMap(users);
        return realm;
    }

    private SecurityIdentity outflow(SecurityIdentity securityIdentity, SecurityDomain outflowDomain) {
        return securityIdentity.withSecurityIdentitySupplier(AdHocIdentityTest.performOutflow(securityIdentity, outflowDomain));
    }

    private static Supplier<SecurityIdentity[]> performOutflow(SecurityIdentity securityIdentity, SecurityDomain securityDomain) {
        return () -> {
            ServerAuthenticationContext context = securityDomain.createNewAuthenticationContext();
            try {
                Assert.assertTrue((boolean)context.importIdentity(securityIdentity));
            }
            catch (RealmUnavailableException e) {
                Assert.fail((String)"Unable to import identity");
            }
            SecurityIdentity outflowedIdentity = context.getAuthorizedIdentity();
            return new SecurityIdentity[]{outflowedIdentity};
        };
    }
}

