/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import org.junit.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.RealmEvent;
import org.wildfly.security.auth.server.event.RealmFailedAuthenticationEvent;
import org.wildfly.security.auth.server.event.RealmSuccessfulAuthenticationEvent;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

public class CustomRealm
implements SecurityRealm {
    public boolean wasAssertionError = false;

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        return SupportLevel.UNSUPPORTED;
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return PasswordGuessEvidence.class.isAssignableFrom(evidenceType) ? SupportLevel.POSSIBLY_SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    public RealmIdentity getRealmIdentity(final Principal principal) throws RealmUnavailableException {
        if ("myadmin".equals(principal.getName())) {
            return new RealmIdentity(){

                public Principal getRealmIdentityPrincipal() {
                    return principal;
                }

                public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                    return SupportLevel.UNSUPPORTED;
                }

                public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                    return null;
                }

                public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) {
                    return PasswordGuessEvidence.class.isAssignableFrom(evidenceType) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean verifyEvidence(Evidence evidence) {
                    if (evidence instanceof PasswordGuessEvidence) {
                        PasswordGuessEvidence guess = (PasswordGuessEvidence)evidence;
                        try {
                            boolean bl = Arrays.equals("mypassword".toCharArray(), guess.getGuess());
                            return bl;
                        }
                        finally {
                            guess.destroy();
                        }
                    }
                    return false;
                }

                public boolean exists() {
                    return true;
                }
            };
        }
        return RealmIdentity.NON_EXISTENT;
    }

    public void handleRealmEvent(RealmEvent event) {
        try {
            if (event instanceof RealmSuccessfulAuthenticationEvent) {
                Assert.assertEquals((Object)"10.12.14.16", (Object)((RealmSuccessfulAuthenticationEvent)event).getAuthorizationIdentity().getRuntimeAttributes().get("Source-Address").get(0));
                Assert.assertEquals((Object)"www.test-request-uri.org", (Object)((RealmSuccessfulAuthenticationEvent)event).getAuthorizationIdentity().getRuntimeAttributes().get("Request-URI").get(0));
                Assert.assertEquals((Object)"myadmin", (Object)((RealmSuccessfulAuthenticationEvent)event).getRealmIdentity().getRealmIdentityPrincipal().getName());
            }
            if (event instanceof RealmFailedAuthenticationEvent) {
                try {
                    Assert.assertEquals((Object)"10.12.14.16", (Object)((RealmFailedAuthenticationEvent)event).getRealmIdentity().getAuthorizationIdentity().getRuntimeAttributes().get("Source-Address").get(0));
                    Assert.assertEquals((Object)"www.test-request-uri.org", (Object)((RealmFailedAuthenticationEvent)event).getRealmIdentity().getAuthorizationIdentity().getRuntimeAttributes().get("Request-URI").get(0));
                    Assert.assertEquals((Object)"myadmin", (Object)((RealmFailedAuthenticationEvent)event).getRealmIdentity().getRealmIdentityPrincipal().getName());
                }
                catch (RealmUnavailableException e) {
                    Assert.fail((String)"RealmFailedAuthenticationEvent should have runtime attributes associated");
                }
            }
        }
        catch (AssertionError e) {
            this.wasAssertionError = true;
        }
    }
}

