/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.auth.callback.RequestInformationCallback;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.server.CustomRealm;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.permission.PermissionVerifier;

public class RealmEventTest {
    private static SecurityDomain usersDomain;
    private static CustomRealm usersRealm;
    private static final Provider provider;

    private ServerAuthenticationContext setupAndGetServerAuthenticationContext() throws IOException, UnsupportedCallbackException, URISyntaxException {
        Security.addProvider(provider);
        usersRealm = new CustomRealm();
        SecurityDomain.Builder builder = SecurityDomain.builder();
        builder.addRealm("users", (SecurityRealm)usersRealm).build();
        builder.setDefaultRealmName("users");
        builder.setPermissionMapper((permissionMappable, roles) -> PermissionVerifier.from((Permission)new LoginPermission()));
        usersDomain = builder.build();
        ServerAuthenticationContext serverAuthenticationContext = usersDomain.createNewAuthenticationContext();
        serverAuthenticationContext.addRuntimeAttributes(this.createRuntimeAttributesWithSourceAddress());
        HashMap<String, URI> props = new HashMap<String, URI>();
        props.put("Request-URI", new URI("www.test-request-uri.org"));
        CallbackHandler callbackHandler = serverAuthenticationContext.createCallbackHandler();
        callbackHandler.handle(new Callback[]{new RequestInformationCallback(props)});
        return serverAuthenticationContext;
    }

    @Test
    public void testRealmSuccessfulAuthenticationEvent() throws IOException, UnsupportedCallbackException, URISyntaxException {
        ServerAuthenticationContext serverAuthenticationContext = this.setupAndGetServerAuthenticationContext();
        try {
            serverAuthenticationContext.setAuthenticationName("myadmin");
            serverAuthenticationContext.addPublicCredential((Credential)new PasswordCredential(PasswordFactory.getInstance((String)"clear").generatePassword((KeySpec)new ClearPasswordSpec("mypassword".toCharArray()))));
            serverAuthenticationContext.authorize();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException | RealmUnavailableException e) {
            Assert.fail();
        }
        serverAuthenticationContext.succeed();
        if (RealmEventTest.usersRealm.wasAssertionError) {
            Assert.fail((String)"Realm successful authentication event did not contain expected information");
        }
    }

    @Test
    public void testRealmFailedAuthenticationEvent() throws NoSuchAlgorithmException, IOException, UnsupportedCallbackException, InvalidKeySpecException, URISyntaxException {
        ServerAuthenticationContext serverAuthenticationContext = this.setupAndGetServerAuthenticationContext();
        serverAuthenticationContext.setAuthenticationName("myadmin");
        serverAuthenticationContext.addPublicCredential((Credential)new PasswordCredential(PasswordFactory.getInstance((String)"clear").generatePassword((KeySpec)new ClearPasswordSpec("wrongPassword".toCharArray()))));
        serverAuthenticationContext.fail();
        if (RealmEventTest.usersRealm.wasAssertionError) {
            Assert.fail((String)"Realm failed authentication event did not contain expected information");
        }
    }

    private Attributes createRuntimeAttributesWithSourceAddress() {
        MapAttributes runtimeAttributes = new MapAttributes();
        runtimeAttributes.addFirst("Source-Address", "10.12.14.16");
        return runtimeAttributes;
    }

    static {
        provider = WildFlyElytronPasswordProvider.getInstance();
    }
}

