/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.bearer;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.impl.AbstractBaseHttpTest;

public class BearerAuthenticationMechanismTest
extends AbstractBaseHttpTest {
    @Test
    public void testBearerAuthenticationMechanism() throws Exception {
        HttpServerAuthenticationMechanism mechanism = this.bearerFactory.createAuthenticationMechanism("BEARER_TOKEN", Collections.emptyMap(), this.getCallbackHandler(null, "testrealm@host.com", null, "random"));
        AbstractBaseHttpTest.TestingHttpServerRequest request1 = new AbstractBaseHttpTest.TestingHttpServerRequest(new String[0]);
        mechanism.evaluateRequest((HttpServerRequest)request1);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.NO_AUTH), (Object)((Object)request1.getResult()));
        AbstractBaseHttpTest.TestingHttpServerRequest request2 = new AbstractBaseHttpTest.TestingHttpServerRequest(new String[]{"Bearer test"});
        mechanism.evaluateRequest((HttpServerRequest)request2);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.FAILED), (Object)((Object)request2.getResult()));
        Assert.assertEquals((long)401L, (long)request2.getResponse().getStatusCode());
        AbstractBaseHttpTest.TestingHttpServerRequest request3 = new AbstractBaseHttpTest.TestingHttpServerRequest(new String[]{"Bearer random"});
        mechanism.evaluateRequest((HttpServerRequest)request3);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.COMPLETE), (Object)((Object)request3.getResult()));
    }
}

