/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ldap;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import org.junit.Test;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.realm.CachingModifiableSecurityRealm;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableRealmIdentityIterator;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.auth.server.ServerUtils;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.cache.RealmIdentityCache;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.ldap.LdapTestSuite;
import org.wildfly.security.password.interfaces.ClearPassword;

public class LdapSecurityRealmIdentityCacheSuiteChild {
    private CountDownLatch waitServerNotification = new CountDownLatch(1);
    private AtomicInteger realmHitCount = new AtomicInteger();
    private AtomicInteger credentialHitCount = new AtomicInteger();
    private AtomicInteger attributesHitCount = new AtomicInteger();
    private AtomicInteger evidencesHitCount = new AtomicInteger();

    @Test
    public void testCacheUpdateAfterChangeNotificationFromServer() throws Exception {
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)this.createSecurityRealm(true, false)).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        for (int i = 0; i < 10; ++i) {
            this.assertAuthenticationAndAuthorization("plainUser", securityDomain);
            org.junit.Assert.assertEquals((long)1L, (long)this.realmHitCount.get());
            org.junit.Assert.assertEquals((long)1L, (long)this.credentialHitCount.get());
            org.junit.Assert.assertEquals((long)1L, (long)this.attributesHitCount.get());
            org.junit.Assert.assertEquals((long)0L, (long)this.evidencesHitCount.get());
        }
        ExceptionSupplier<DirContext, NamingException> supplier = LdapTestSuite.dirContextFactory.create();
        DirContext dirContext = (DirContext)supplier.get();
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("sn", "Changed SN"))};
        dirContext.modifyAttributes("uid=plainUser,dc=elytron,dc=wildfly,dc=org", mods);
        this.waitServerNotification.await(5L, TimeUnit.SECONDS);
        this.assertAuthenticationAndAuthorization("plainUser", securityDomain);
        org.junit.Assert.assertEquals((long)2L, (long)this.realmHitCount.get());
        org.junit.Assert.assertEquals((long)2L, (long)this.credentialHitCount.get());
        org.junit.Assert.assertEquals((long)2L, (long)this.attributesHitCount.get());
        org.junit.Assert.assertEquals((long)0L, (long)this.evidencesHitCount.get());
        dirContext.close();
    }

    @Test
    public void testCacheUpdateAfterRemoveNotificationFromServer() throws Exception {
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)this.createSecurityRealm(true, false)).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        this.assertAuthenticationAndAuthorization("userToRemove", securityDomain);
        this.assertAuthenticationAndAuthorization("userToRemove", securityDomain);
        org.junit.Assert.assertEquals((long)1L, (long)this.realmHitCount.get());
        ExceptionSupplier<DirContext, NamingException> supplier = LdapTestSuite.dirContextFactory.create();
        DirContext dirContext = (DirContext)supplier.get();
        dirContext.destroySubcontext("uid=userToRemove,dc=elytron,dc=wildfly,dc=org");
        this.waitServerNotification.await(5L, TimeUnit.SECONDS);
        ServerAuthenticationContext sac = this.createServerAuthenticationContext("userToRemove", securityDomain);
        org.junit.Assert.assertFalse((boolean)sac.exists());
        dirContext.close();
    }

    @Test
    public void testDirectVerificationCaching() throws Exception {
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)this.createSecurityRealm(false, true)).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        for (int i = 0; i < 5; ++i) {
            ServerAuthenticationContext sac = this.createServerAuthenticationContext("plainUser", securityDomain);
            Assert.assertTrue((boolean)sac.verifyEvidence((Evidence)new PasswordGuessEvidence("plainPassword".toCharArray())));
            org.junit.Assert.assertEquals((long)1L, (long)this.realmHitCount.get());
            org.junit.Assert.assertEquals((long)1L, (long)this.credentialHitCount.get());
            org.junit.Assert.assertEquals((long)0L, (long)this.attributesHitCount.get());
            org.junit.Assert.assertEquals((long)1L, (long)this.evidencesHitCount.get());
        }
    }

    private void assertAuthenticationAndAuthorization(String username, SecurityDomain securityDomain) throws RealmUnavailableException {
        ServerAuthenticationContext sac = this.createServerAuthenticationContext(username, securityDomain);
        Assert.assertTrue((boolean)sac.verifyEvidence((Evidence)new PasswordGuessEvidence("plainPassword".toCharArray())));
        org.junit.Assert.assertEquals((Object)SupportLevel.SUPPORTED, (Object)sac.getCredentialAcquireSupport(PasswordCredential.class, "clear"));
        org.junit.Assert.assertEquals((Object)"plainPassword", (Object)new String(((ClearPassword)((PasswordCredential)sac.getCredential(PasswordCredential.class)).getPassword().castAs(ClearPassword.class, "clear")).getPassword()));
        Assert.assertTrue((boolean)sac.verifyEvidence((Evidence)new PasswordGuessEvidence("plainPassword".toCharArray())));
        Assert.assertTrue((boolean)sac.authorize(username));
        SecurityIdentity securityIdentity = sac.getAuthorizedIdentity();
        Assert.assertNotNull((Object)securityIdentity);
        Assert.assertNotNull((Object)securityIdentity.getAttributes());
        org.junit.Assert.assertEquals((Object)username, (Object)securityIdentity.getPrincipal().getName());
    }

    private ServerAuthenticationContext createServerAuthenticationContext(String username, SecurityDomain securityDomain) throws RealmUnavailableException {
        ServerAuthenticationContext sac = securityDomain.createNewAuthenticationContext();
        sac.setAuthenticationName(username);
        return sac;
    }

    private ModifiableSecurityRealm createSecurityRealm(boolean credentialLoader, boolean directVerification) {
        LdapSecurityRealmBuilder builder = LdapSecurityRealmBuilder.builder().setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS).setDirContextSupplier(LdapTestSuite.dirContextFactory.create()).identityMapping().setSearchDn("dc=elytron,dc=wildfly,dc=org").setRdnIdentifier("uid").build();
        if (credentialLoader) {
            builder.userPasswordCredentialLoader().build();
        }
        if (directVerification) {
            builder.addDirectEvidenceVerification();
        }
        return new CachingModifiableSecurityRealm((CacheableSecurityRealm)new MockCacheableModifiableSecurityRealm(builder.build()), this.createRealmIdentitySimpleJavaMapCache(), ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
    }

    private RealmIdentityCache createRealmIdentitySimpleJavaMapCache() {
        return new RealmIdentityCache(){
            private Map<Principal, RealmIdentity> cache = new HashMap<Principal, RealmIdentity>();

            public void put(Principal principal, RealmIdentity realmIdentity) {
                this.cache.put(principal, realmIdentity);
            }

            public RealmIdentity get(Principal principal) {
                return this.cache.get(principal);
            }

            public void remove(Principal principal) {
                this.cache.remove(principal);
            }

            public void clear() {
                this.cache.clear();
            }
        };
    }

    private class MockCacheableModifiableSecurityRealm
    implements ModifiableSecurityRealm,
    CacheableSecurityRealm {
        private final ModifiableSecurityRealm realm;

        public MockCacheableModifiableSecurityRealm(ModifiableSecurityRealm realm) {
            this.realm = realm;
        }

        public void registerIdentityChangeListener(Consumer<Principal> listener) {
            ((CacheableSecurityRealm)this.realm).registerIdentityChangeListener(principal -> {
                listener.accept((Principal)principal);
                LdapSecurityRealmIdentityCacheSuiteChild.this.waitServerNotification.countDown();
            });
        }

        public RealmIdentity getRealmIdentity(final Principal principal) throws RealmUnavailableException {
            LdapSecurityRealmIdentityCacheSuiteChild.this.realmHitCount.incrementAndGet();
            return new RealmIdentity(){
                RealmIdentity identity;
                {
                    this.identity = MockCacheableModifiableSecurityRealm.this.realm.getRealmIdentity(principal);
                }

                public Principal getRealmIdentityPrincipal() {
                    return this.identity.getRealmIdentityPrincipal();
                }

                public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                    LdapSecurityRealmIdentityCacheSuiteChild.this.credentialHitCount.incrementAndGet();
                    return this.identity.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
                }

                public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                    LdapSecurityRealmIdentityCacheSuiteChild.this.credentialHitCount.incrementAndGet();
                    return (C)this.identity.getCredential(credentialType);
                }

                public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                    LdapSecurityRealmIdentityCacheSuiteChild.this.evidencesHitCount.incrementAndGet();
                    return this.identity.getEvidenceVerifySupport(evidenceType, algorithmName);
                }

                public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                    LdapSecurityRealmIdentityCacheSuiteChild.this.evidencesHitCount.incrementAndGet();
                    return this.identity.verifyEvidence(evidence);
                }

                public boolean exists() throws RealmUnavailableException {
                    return this.identity.exists();
                }

                public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
                    LdapSecurityRealmIdentityCacheSuiteChild.this.attributesHitCount.incrementAndGet();
                    return this.identity.getAuthorizationIdentity();
                }

                public Attributes getAttributes() throws RealmUnavailableException {
                    LdapSecurityRealmIdentityCacheSuiteChild.this.attributesHitCount.incrementAndGet();
                    return this.identity.getAttributes();
                }
            };
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return this.realm.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.realm.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        public ModifiableRealmIdentity getRealmIdentityForUpdate(Principal principal) throws RealmUnavailableException {
            return this.realm.getRealmIdentityForUpdate(principal);
        }

        public ModifiableRealmIdentityIterator getRealmIdentityIterator() throws RealmUnavailableException {
            return this.realm.getRealmIdentityIterator();
        }
    }
}

