/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.jboss.logging.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.spec.DigestPasswordSpec;
import org.wildfly.security.sasl.digest.DigestCallbackHandlerUtils;
import org.wildfly.security.sasl.digest.DigestSaslServer;
import org.wildfly.security.sasl.digest.DigestServerFactory;
import org.wildfly.security.sasl.digest.WildFlyElytronSaslDigestProvider;
import org.wildfly.security.sasl.test.SaslServerBuilder;
import org.wildfly.security.sasl.test.SaslTestUtil;
import org.wildfly.security.sasl.util.UsernamePasswordHashUtil;

public class DigestTest {
    private static Logger log = Logger.getLogger(DigestTest.class);
    private static final String DIGEST = "DIGEST-MD5";
    private static final String REALM_PROPERTY = "com.sun.security.sasl.digest.realm";
    private static final String PRE_DIGESTED_PROPERTY = "org.wildfly.security.sasl.digest.pre_digested";
    private static final String QOP_PROPERTY = "javax.security.sasl.qop";
    private static final Provider[] providers = new Provider[]{WildFlyElytronSaslDigestProvider.getInstance(), WildFlyElytronPasswordProvider.getInstance()};

    @BeforeClass
    public static void registerPasswordProvider() {
        for (Provider provider : providers) {
            Security.insertProviderAt(provider, 1);
        }
    }

    @AfterClass
    public static void removePasswordProvider() {
        for (Provider provider : providers) {
            Security.removeProvider(provider.getName());
        }
    }

    @Test
    public void testPolicyIndirect_Server() throws Exception {
        HashMap props = new HashMap();
        CallbackHandler serverCallback = new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            }
        };
        SaslServer server = Sasl.createSaslServer(DIGEST, "TestProtocol", "TestServer", props, serverCallback);
        Assert.assertEquals(DigestSaslServer.class, server.getClass());
    }

    @Test
    public void testPolicyDirect_Server() {
        SaslServerFactory factory = SaslTestUtil.obtainSaslServerFactory(DigestServerFactory.class);
        Assert.assertNotNull((String)"SaslServerFactory not registered", (Object)factory);
        HashMap props = new HashMap();
        String[] mechanisms = factory.getMechanismNames(props);
        Assert.assertTrue((mechanisms.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSuccessfulExchange() throws Exception {
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("gpwd".toCharArray()).setProtocol("TestProtocol").setServerName("TestServer").addMechanismRealm("TestRealm").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createClearPwdClientCallbackHandler("George", "gpwd", "TestRealm");
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        this.assertExchange(server, client);
    }

    @Test
    public void testSuccessfulExchange_DefaultRealm() throws Exception {
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("gpwd".toCharArray()).setProtocol("TestProtocol").setServerName("TestServer").addMechanismRealm("TestServer").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createClearPwdClientCallbackHandler("George", "gpwd", null);
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        this.assertExchange(server, client);
    }

    @Test
    @Ignore(value="ELY-91")
    public void testSuccessfulExchange_AlternativeProtocol() throws Exception {
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put("org.wildfly.security.sasl.digest.alternative_protocols", "OtherProtocol DifferentProtocol");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("gpwd".toCharArray()).setProperties(serverProps).setProtocol("TestProtocol").setServerName("TestServer").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createClearPwdClientCallbackHandler("George", "gpwd", null);
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "OtherProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        this.assertExchange(server, client);
    }

    @Test
    public void testBadPassword() throws Exception {
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(REALM_PROPERTY, "TestRealm");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("bad".toCharArray()).setProperties(serverProps).setProtocol("TestProtocol").setServerName("TestServer").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createClearPwdClientCallbackHandler("George", "gpwd", null);
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)client.hasInitialResponse());
        byte[] message = server.evaluateResponse(new byte[0]);
        message = client.evaluateChallenge(message);
        try {
            server.evaluateResponse(message);
            Assert.fail((String)"Expection exception not thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testBadUsername() throws Exception {
        HashMap<String, String> serverProps = new HashMap<String, String>();
        serverProps.put(REALM_PROPERTY, "TestRealm");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("Borris").setPassword("gpwd".toCharArray()).setProtocol("TestProtocol").setServerName("TestServer").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createClearPwdClientCallbackHandler("George", "gpwd", null);
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)client.hasInitialResponse());
        byte[] message = server.evaluateResponse(new byte[0]);
        message = client.evaluateChallenge(message);
        try {
            server.evaluateResponse(message);
            Assert.fail((String)"Expection exception not thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testBadRealm() throws Exception {
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(REALM_PROPERTY, "TestRealm");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("gpwd".toCharArray()).setProperties(serverProps).setProtocol("TestProtocol").setServerName("TestServer").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createClearPwdClientCallbackHandler("George", "gpwd", "BadRealm");
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)client.hasInitialResponse());
        byte[] message = server.evaluateResponse(new byte[0]);
        message = client.evaluateChallenge(message);
        try {
            server.evaluateResponse(message);
            Assert.fail((String)"Expection exception not thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRealmSelection() throws Exception {
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("gpwd".toCharArray()).setProtocol("TestProtocol").setServerName("TestServer").addMechanismRealm("realm1").addMechanismRealm("second realm").addMechanismRealm("last\\ ").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createClearPwdClientCallbackHandler("George", "gpwd", "last\\ ");
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        this.assertExchange(server, client);
    }

    @Test
    public void testSuccessfulExchange_PreHashedServer() throws Exception {
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(PRE_DIGESTED_PROPERTY, "true");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("digest-md5", this.getDigestKeySpec("George", "gpwd", "TestRealm")).setProperties(serverProps).setProtocol("TestProtocol").addMechanismRealm("TestRealm").setServerName("TestServer").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createClearPwdClientCallbackHandler("George", "gpwd", null);
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)client.hasInitialResponse());
        byte[] message = server.evaluateResponse(new byte[0]);
        log.debug((Object)("Challenge:" + new String(message, StandardCharsets.ISO_8859_1)));
        message = client.evaluateChallenge(message);
        log.debug((Object)("Client response:" + new String(message, StandardCharsets.ISO_8859_1)));
        message = server.evaluateResponse(message);
        log.debug((Object)("Server response:" + new String(message, StandardCharsets.ISO_8859_1)));
        client.evaluateChallenge(message);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertEquals((Object)"George", (Object)server.getAuthorizationID());
    }

    @Test
    public void testSuccessfulExchange_DefaultRealm_PreHashedServer() throws Exception {
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(PRE_DIGESTED_PROPERTY, "true");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("digest-md5", this.getDigestKeySpec("George", "gpwd", "TestServer")).setProperties(serverProps).setProtocol("TestProtocol").addMechanismRealm("TestServer").setServerName("TestServer").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createClearPwdClientCallbackHandler("George", "gpwd", "TestServer");
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)client.hasInitialResponse());
        byte[] message = server.evaluateResponse(new byte[0]);
        log.debug((Object)("Challenge:" + new String(message, StandardCharsets.ISO_8859_1)));
        message = client.evaluateChallenge(message);
        log.debug((Object)("Client response:" + new String(message, StandardCharsets.ISO_8859_1)));
        message = server.evaluateResponse(message);
        log.debug((Object)("Server response:" + new String(message, StandardCharsets.ISO_8859_1)));
        client.evaluateChallenge(message);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertEquals((Object)"George", (Object)server.getAuthorizationID());
    }

    @Test
    public void testBadPassword_PreHashedServer() throws Exception {
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(REALM_PROPERTY, "TestRealm");
        serverProps.put(PRE_DIGESTED_PROPERTY, "true");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("digest-md5", this.getDigestKeySpec("George", "gpwd", "TestRealm")).setProperties(serverProps).setProtocol("TestProtocol").setServerName("TestServer").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createClearPwdClientCallbackHandler("George", "bad", null);
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)client.hasInitialResponse());
        byte[] message = server.evaluateResponse(new byte[0]);
        log.debug((Object)("Challenge:" + new String(message, StandardCharsets.ISO_8859_1)));
        message = client.evaluateChallenge(message);
        log.debug((Object)("Client response:" + new String(message, StandardCharsets.ISO_8859_1)));
        try {
            server.evaluateResponse(message);
            Assert.fail((String)"Expection exception not thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testBadUsername_PreHashedServer() throws Exception {
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(PRE_DIGESTED_PROPERTY, "true");
        serverProps.put(REALM_PROPERTY, "TestRealm");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("Borris").setPassword("digest-md5", this.getDigestKeySpec("George", "gpwd", "TestRealm")).setProperties(serverProps).setProtocol("TestProtocol").setServerName("TestServer").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createClearPwdClientCallbackHandler("George", "bad", null);
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)client.hasInitialResponse());
        byte[] message = server.evaluateResponse(new byte[0]);
        log.debug((Object)("Challenge:" + new String(message, StandardCharsets.ISO_8859_1)));
        message = client.evaluateChallenge(message);
        log.debug((Object)("Client response:" + new String(message, StandardCharsets.ISO_8859_1)));
        try {
            server.evaluateResponse(message);
            Assert.fail((String)"Expection exception not thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testBadRealm_PreHashedServer() throws Exception {
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(REALM_PROPERTY, "TestRealm");
        serverProps.put(PRE_DIGESTED_PROPERTY, "true");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("digest-md5", this.getDigestKeySpec("George", "gpwd", "TestRealm")).setProperties(serverProps).setProtocol("TestProtocol").setServerName("TestServer").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createClearPwdClientCallbackHandler("George", "gpwd", "BadRealm");
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)client.hasInitialResponse());
        byte[] message = server.evaluateResponse(new byte[0]);
        log.debug((Object)("Challenge:" + new String(message, StandardCharsets.ISO_8859_1)));
        message = client.evaluateChallenge(message);
        log.debug((Object)("Client response:" + new String(message, StandardCharsets.ISO_8859_1)));
        try {
            server.evaluateResponse(message);
            Assert.fail((String)"Expection exception not thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testSuccessfulExchange_PreHashedClient() throws Exception {
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("digest-md5", this.getDigestKeySpec("George", "gpwd", "TestRealm")).setProtocol("TestProtocol").setServerName("TestServer").addMechanismRealm("TestRealm").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createDigestPwdClientCallbackHandler("George", "gpwd", "TestRealm", null, "George");
        HashMap<String, String> clientProps = new HashMap<String, String>();
        clientProps.put(PRE_DIGESTED_PROPERTY, "true");
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", clientProps, clientCallback);
        this.assertExchange(server, client);
    }

    @Test
    public void testSuccessfulExchange_DefaultRealm_PreHashedClient() throws Exception {
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("digest-md5", this.getDigestKeySpec("George", "gpwd", "TestServer")).setProtocol("TestProtocol").setServerName("TestServer").addMechanismRealm("TestServer").addMechanismRealm("TestRealm").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createDigestPwdClientCallbackHandler("George", "gpwd", "TestServer", null, "George");
        HashMap<String, String> clientProps = new HashMap<String, String>();
        clientProps.put(PRE_DIGESTED_PROPERTY, "true");
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", clientProps, clientCallback);
        this.assertExchange(server, client);
    }

    @Test
    public void testBadPassword_PreHashedClient() throws Exception {
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(REALM_PROPERTY, "TestRealm");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("digest-md5", this.getDigestKeySpec("George", "gpwd", "TestRealm")).setProperties(serverProps).setProtocol("TestProtocol").setServerName("TestServer").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createDigestPwdClientCallbackHandler("George", "bad", "TestRealm", null, "George");
        HashMap<String, String> clientProps = new HashMap<String, String>();
        clientProps.put(PRE_DIGESTED_PROPERTY, "true");
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", clientProps, clientCallback);
        Assert.assertFalse((boolean)client.hasInitialResponse());
        byte[] message = server.evaluateResponse(new byte[0]);
        message = client.evaluateChallenge(message);
        try {
            server.evaluateResponse(message);
            Assert.fail((String)"Expection exception not thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testBadUsername_PreHashedClient() throws Exception {
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(REALM_PROPERTY, "TestRealm");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("digest-md5", this.getDigestKeySpec("George", "gpwd", "TestRealm")).setProperties(serverProps).setProtocol("TestProtocol").setServerName("TestServer").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createDigestPwdClientCallbackHandler("Borris", "gpwd", "TestRealm", null, "George");
        HashMap<String, String> clientProps = new HashMap<String, String>();
        clientProps.put(PRE_DIGESTED_PROPERTY, "true");
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", clientProps, clientCallback);
        Assert.assertFalse((boolean)client.hasInitialResponse());
        byte[] message = server.evaluateResponse(new byte[0]);
        try {
            client.evaluateChallenge(message);
            Assert.fail((String)"Expection exception not thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testBadRealm_PreHashedClient() throws Exception {
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(REALM_PROPERTY, "TestRealm");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("digest-md5", this.getDigestKeySpec("George", "gpwd", "TestRealm")).setProperties(serverProps).setProtocol("TestProtocol").setServerName("TestServer").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createDigestPwdClientCallbackHandler("George", "gpwd", "BadRealm", "TestRealm", "George");
        HashMap<String, String> clientProps = new HashMap<String, String>();
        clientProps.put(PRE_DIGESTED_PROPERTY, "true");
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", clientProps, clientCallback);
        Assert.assertFalse((boolean)client.hasInitialResponse());
        byte[] message = server.evaluateResponse(new byte[0]);
        try {
            client.evaluateChallenge(message);
            Assert.fail((String)"Expection exception not thrown.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testSuccessfulExchangeWithIntegrityCheck() throws Exception {
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(QOP_PROPERTY, "auth-int");
        serverProps.put("wildfly.security.sasl.digest.ciphers", "des,3des,rc4,rc4-40,rc4-56");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("gpwd".toCharArray()).setProperties(serverProps).setProtocol("TestProtocol").setServerName("TestServer").addMechanismRealm("TestServer").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createClearPwdClientCallbackHandler("George", "gpwd", null);
        HashMap<String, String> clientProps = new HashMap<String, String>();
        clientProps.put(QOP_PROPERTY, "auth-int");
        clientProps.put("wildfly.security.sasl.digest.ciphers", "des,3des,rc4,rc4-40,rc4-56");
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", clientProps, clientCallback);
        Assert.assertFalse((boolean)client.hasInitialResponse());
        byte[] message = new byte[]{};
        message = server.evaluateResponse(message);
        message = client.evaluateChallenge(message);
        message = server.evaluateResponse(message);
        message = client.evaluateChallenge(message);
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertEquals((Object)"George", (Object)server.getAuthorizationID());
        message = server.wrap(new byte[]{18, 52, 86}, 0, 3);
        Assert.assertArrayEquals((byte[])new byte[]{18, 52, 86}, (byte[])client.unwrap(message, 0, message.length));
        message = client.wrap(new byte[]{-85, -51, -17}, 0, 3);
        Assert.assertArrayEquals((byte[])new byte[]{-85, -51, -17}, (byte[])server.unwrap(message, 0, message.length));
    }

    @Test
    public void testSuccessfulExchangeWithPrivacyProtection() throws Exception {
        this.testSuccessfulExchangeWithPrivacyProtection("3des");
        this.testSuccessfulExchangeWithPrivacyProtection("des");
        this.testSuccessfulExchangeWithPrivacyProtection("rc4");
        this.testSuccessfulExchangeWithPrivacyProtection("rc4-40");
        this.testSuccessfulExchangeWithPrivacyProtection("rc4-56");
    }

    private void testSuccessfulExchangeWithPrivacyProtection(String clientCipher) throws Exception {
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        serverProps.put(QOP_PROPERTY, "auth-conf");
        serverProps.put("wildfly.security.sasl.digest.ciphers", "des,3des,rc4,rc4-40,rc4-56");
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("gpwd".toCharArray()).setProperties(serverProps).setProtocol("TestProtocol").setServerName("TestServer").addMechanismRealm("TestServer").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createClearPwdClientCallbackHandler("George", "gpwd", null);
        HashMap<String, String> clientProps = new HashMap<String, String>();
        clientProps.put(QOP_PROPERTY, "auth-conf");
        clientProps.put("wildfly.security.sasl.digest.ciphers", clientCipher);
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer", clientProps, clientCallback);
        Assert.assertFalse((boolean)client.hasInitialResponse());
        byte[] message = new byte[]{};
        message = server.evaluateResponse(message);
        message = client.evaluateChallenge(message);
        message = server.evaluateResponse(message);
        message = client.evaluateChallenge(message);
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertEquals((Object)"George", (Object)server.getAuthorizationID());
        message = server.wrap(new byte[]{18, 52, 86}, 0, 3);
        Assert.assertArrayEquals((byte[])new byte[]{18, 52, 86}, (byte[])client.unwrap(message, 0, message.length));
        message = client.wrap(new byte[]{-85, -51, -17}, 0, 3);
        Assert.assertArrayEquals((byte[])new byte[]{-85, -51, -17}, (byte[])server.unwrap(message, 0, message.length));
    }

    @Test
    public void testSuccessfulExchangeNullAuthorizationId() throws Exception {
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("gpwd".toCharArray()).setProtocol("TestProtocol").setServerName("TestServer").addMechanismRealm("TestRealm").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createClearPwdClientCallbackHandler("George", "gpwd", "TestRealm");
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, null, "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        this.assertExchange(server, client);
    }

    @Test
    public void testSuccessfulExchangeEmptyAuthorizationId() throws Exception {
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("gpwd".toCharArray()).setProtocol("TestProtocol").setServerName("TestServer").addMechanismRealm("TestRealm").build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createClearPwdClientCallbackHandler("George", "gpwd", "TestRealm");
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        this.assertExchange(server, client);
    }

    private KeySpec getDigestKeySpec(String username, String password, String realm) throws NoSuchAlgorithmException {
        byte[] urpHash = new UsernamePasswordHashUtil().generateHashedURP(username, realm, password.toCharArray());
        return new DigestPasswordSpec(username, realm, urpHash);
    }

    @Test
    public void testUnboundServerName() throws Exception {
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        SaslServer server = new SaslServerBuilder(DigestServerFactory.class, DIGEST).setUserName("George").setPassword("digest-md5", this.getDigestKeySpec("George", "gpwd", "TestRealm")).setProperties(serverProps).setProtocol("TestProtocol").addMechanismRealm("TestRealm").setServerName(null).build();
        CallbackHandler clientCallback = DigestCallbackHandlerUtils.createClearPwdClientCallbackHandler("George", "gpwd", null);
        SaslClient client = Sasl.createSaslClient(new String[]{DIGEST}, "George", "TestProtocol", "TestServer5", Collections.emptyMap(), clientCallback);
        Assert.assertFalse((boolean)client.hasInitialResponse());
        byte[] message = server.evaluateResponse(new byte[0]);
        log.debug((Object)("Challenge:" + new String(message, StandardCharsets.ISO_8859_1)));
        message = client.evaluateChallenge(message);
        log.debug((Object)("Client response:" + new String(message, StandardCharsets.ISO_8859_1)));
        message = server.evaluateResponse(message);
        log.debug((Object)("Server response:" + new String(message, StandardCharsets.ISO_8859_1)));
        client.evaluateChallenge(message);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertEquals((Object)"George", (Object)server.getAuthorizationID());
        Assert.assertEquals((Object)"TestServer5", (Object)server.getNegotiatedProperty("javax.security.sasl.bound.server.name"));
    }

    private void assertExchange(SaslServer server, SaslClient client) throws SaslException {
        Assert.assertFalse((boolean)client.hasInitialResponse());
        byte[] message = server.evaluateResponse(new byte[0]);
        log.debug((Object)("Challenge:" + new String(message, StandardCharsets.ISO_8859_1)));
        message = client.evaluateChallenge(message);
        log.debug((Object)("Client response:" + new String(message, StandardCharsets.ISO_8859_1)));
        server.evaluateResponse(message);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertEquals((Object)"George", (Object)server.getAuthorizationID());
    }
}

