/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.test;

import java.io.File;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.ClientUtils;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.sasl.SaslMechanismSelector;
import org.wildfly.security.sasl.localuser.LocalUserServerFactory;
import org.wildfly.security.sasl.localuser.WildFlyElytronSaslLocalUserProvider;
import org.wildfly.security.sasl.test.SaslServerBuilder;

public class LocalUserTest {
    private static final String LOCAL_USER = "JBOSS-LOCAL-USER";
    private static final Provider provider = WildFlyElytronSaslLocalUserProvider.getInstance();

    @BeforeClass
    public static void registerPasswordProvider() {
        Security.insertProviderAt(provider, 1);
    }

    @AfterClass
    public static void removePasswordProvider() {
        Security.removeProvider(provider.getName());
    }

    @Test
    public void testSuccessfulExchange_CF() throws Exception {
        SaslServer server = new SaslServerBuilder(LocalUserServerFactory.class, LOCAL_USER).setUserName("George").build();
        CallbackHandler clientCallback = this.createClientCallbackHandler("George");
        SaslClient client = Sasl.createSaslClient(new String[]{LOCAL_USER}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] response = client.evaluateChallenge(new byte[0]);
        byte[] challenge = server.evaluateResponse(response);
        response = client.evaluateChallenge(challenge);
        challenge = server.evaluateResponse(response);
        Assert.assertNull((Object)challenge);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertEquals((Object)"George", (Object)server.getAuthorizationID());
        server.dispose();
    }

    @Test
    public void testSuccessfulQuietExchange_CF() throws Exception {
        HashMap<String, Object> serverOptions = new HashMap<String, Object>();
        serverOptions.put("wildfly.sasl.local-user.default-user", "$local");
        HashMap<String, String> passwordMap = new HashMap<String, String>();
        passwordMap.put("$local", null);
        passwordMap.put("George", null);
        SaslServer server = new SaslServerBuilder(LocalUserServerFactory.class, LOCAL_USER).setPasswordMap(passwordMap).setProperties(serverOptions).build();
        CallbackHandler clientCallback = this.createClientCallbackHandler("George");
        HashMap<String, String> clientOptions = new HashMap<String, String>();
        clientOptions.put("wildfly.sasl.local-user.quiet-auth", "true");
        SaslClient client = Sasl.createSaslClient(new String[]{LOCAL_USER}, null, "TestProtocol", "TestServer", clientOptions, clientCallback);
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] response = client.evaluateChallenge(new byte[0]);
        byte[] challenge = server.evaluateResponse(response);
        response = client.evaluateChallenge(challenge);
        challenge = server.evaluateResponse(response);
        Assert.assertNull((Object)challenge);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertEquals((Object)"$local", (Object)server.getAuthorizationID());
        server.dispose();
    }

    @Test
    public void testBadExchange_CF() throws Exception {
        SaslServer server = new SaslServerBuilder(LocalUserServerFactory.class, LOCAL_USER).setUserName("George").build();
        CallbackHandler clientCallback = this.createClientCallbackHandler("George");
        SaslClient client = Sasl.createSaslClient(new String[]{LOCAL_USER}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] response = client.evaluateChallenge(new byte[0]);
        byte[] challenge = server.evaluateResponse(response);
        response = client.evaluateChallenge(challenge);
        for (int i = 0; i < 8; ++i) {
            response[i] = 0;
        }
        try {
            challenge = server.evaluateResponse(response);
            Assert.fail((String)"Expected SaslException not thrown.");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)server.isComplete());
        try {
            server.getAuthorizationID();
            Assert.fail((String)"Expected IllegalStateException not thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        server.dispose();
    }

    @Test
    public void testBadFile_CF() throws Exception {
        SaslServer server = new SaslServerBuilder(LocalUserServerFactory.class, LOCAL_USER).setUserName("George").build();
        CallbackHandler clientCallback = this.createClientCallbackHandler("George");
        SaslClient client = Sasl.createSaslClient(new String[]{LOCAL_USER}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] response = client.evaluateChallenge(new byte[0]);
        byte[] challenge = server.evaluateResponse(response);
        File nonExistant = new File("nonExistant.txt");
        String path = nonExistant.getAbsolutePath();
        challenge = CodePointIterator.ofString((String)path).asUtf8(true).drain();
        try {
            response = client.evaluateChallenge(challenge);
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)server.isComplete());
        try {
            server.getAuthorizationID();
            Assert.fail((String)"Expected IllegalStateException not thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        server.dispose();
    }

    @Test
    public void testNoAuthorizationId_CF() throws Exception {
        SaslServer server = new SaslServerBuilder(LocalUserServerFactory.class, LOCAL_USER).setUserName("George").build();
        CallbackHandler clientCallback = this.createClientCallbackHandler("George");
        SaslClient client = Sasl.createSaslClient(new String[]{LOCAL_USER}, null, "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] response = client.evaluateChallenge(new byte[0]);
        byte[] challenge = server.evaluateResponse(response);
        response = client.evaluateChallenge(challenge);
        challenge = server.evaluateResponse(response);
        Assert.assertNull((Object)challenge);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertEquals((Object)"George", (Object)server.getAuthorizationID());
        server.dispose();
    }

    @Test
    public void testSuccessfulExchange_SF() throws Exception {
        SaslServer server = new SaslServerBuilder(LocalUserServerFactory.class, LOCAL_USER).setUserName("George").build();
        CallbackHandler clientCallback = this.createClientCallbackHandler("George");
        SaslClient client = Sasl.createSaslClient(new String[]{LOCAL_USER}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        byte[] challenge = server.evaluateResponse(new byte[0]);
        byte[] response = client.evaluateChallenge(challenge);
        challenge = server.evaluateResponse(response);
        response = client.evaluateChallenge(challenge);
        challenge = server.evaluateResponse(response);
        Assert.assertNull((Object)challenge);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertEquals((Object)"George", (Object)server.getAuthorizationID());
        server.dispose();
    }

    @Test
    public void testSuccessfulQuietExchange_SF() throws Exception {
        HashMap<String, Object> serverOptions = new HashMap<String, Object>();
        serverOptions.put("wildfly.sasl.local-user.default-user", "$local");
        SaslServer server = new SaslServerBuilder(LocalUserServerFactory.class, LOCAL_USER).setUserName("$local").setProperties(serverOptions).build();
        CallbackHandler clientCallback = this.createClientCallbackHandler("George");
        HashMap<String, String> clientOptions = new HashMap<String, String>();
        clientOptions.put("wildfly.sasl.local-user.quiet-auth", "true");
        SaslClient client = Sasl.createSaslClient(new String[]{LOCAL_USER}, null, "TestProtocol", "TestServer", clientOptions, clientCallback);
        byte[] challenge = server.evaluateResponse(new byte[0]);
        byte[] response = client.evaluateChallenge(challenge);
        challenge = server.evaluateResponse(response);
        response = client.evaluateChallenge(challenge);
        challenge = server.evaluateResponse(response);
        Assert.assertNull((Object)challenge);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertEquals((Object)"$local", (Object)server.getAuthorizationID());
        server.dispose();
    }

    @Test
    public void testBadExchange_SF() throws Exception {
        SaslServer server = new SaslServerBuilder(LocalUserServerFactory.class, LOCAL_USER).setUserName("George").build();
        CallbackHandler clientCallback = this.createClientCallbackHandler("George");
        SaslClient client = Sasl.createSaslClient(new String[]{LOCAL_USER}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        byte[] challenge = server.evaluateResponse(new byte[0]);
        byte[] response = client.evaluateChallenge(challenge);
        challenge = server.evaluateResponse(response);
        response = client.evaluateChallenge(challenge);
        for (int i = 0; i < 8; ++i) {
            response[i] = 0;
        }
        try {
            challenge = server.evaluateResponse(response);
            Assert.fail((String)"Expected SaslException not thrown.");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)server.isComplete());
        try {
            server.getAuthorizationID();
            Assert.fail((String)"Expected IllegalStateException not thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        server.dispose();
    }

    @Test
    public void testBadFile_SF() throws Exception {
        SaslServer server = new SaslServerBuilder(LocalUserServerFactory.class, LOCAL_USER).setUserName("George").build();
        CallbackHandler clientCallback = this.createClientCallbackHandler("George");
        SaslClient client = Sasl.createSaslClient(new String[]{LOCAL_USER}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        byte[] challenge = server.evaluateResponse(new byte[0]);
        byte[] response = client.evaluateChallenge(challenge);
        challenge = server.evaluateResponse(response);
        File nonExistant = new File("nonExistant.txt");
        String path = nonExistant.getAbsolutePath();
        challenge = CodePointIterator.ofString((String)path).asUtf8(true).drain();
        try {
            response = client.evaluateChallenge(challenge);
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)server.isComplete());
        try {
            server.getAuthorizationID();
            Assert.fail((String)"Expected IllegalStateException not thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        server.dispose();
    }

    @Test
    public void testNoAuthorizationId_SF() throws Exception {
        SaslServer server = new SaslServerBuilder(LocalUserServerFactory.class, LOCAL_USER).setUserName("George").build();
        CallbackHandler clientCallback = this.createClientCallbackHandler("George");
        SaslClient client = Sasl.createSaslClient(new String[]{LOCAL_USER}, null, "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        byte[] challenge = server.evaluateResponse(new byte[0]);
        byte[] response = client.evaluateChallenge(challenge);
        challenge = server.evaluateResponse(response);
        response = client.evaluateChallenge(challenge);
        challenge = server.evaluateResponse(response);
        Assert.assertNull((Object)challenge);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertEquals((Object)"George", (Object)server.getAuthorizationID());
        server.dispose();
    }

    @Test
    public void testTmpFileDeleted_SF() throws Exception {
        SaslServer server = new SaslServerBuilder(LocalUserServerFactory.class, LOCAL_USER).setUserName("George").build();
        byte[] challenge = server.evaluateResponse(new byte[0]);
        challenge = server.evaluateResponse(new byte[]{0});
        String path = new String(challenge, StandardCharsets.UTF_8);
        File file = new File(path);
        Assert.assertTrue((String)"Temporary file was created.", (boolean)file.exists());
        server.dispose();
        Assert.assertFalse((String)"Temporary file was deleted.", (boolean)file.exists());
    }

    @Test
    public void testMinimalCallbackHandler() throws Exception {
        SaslServer server = new SaslServerBuilder(LocalUserServerFactory.class, LOCAL_USER).setUserName("George").build();
        CallbackHandler clientCallback = callbacks -> {
            throw new UnsupportedCallbackException(null);
        };
        SaslClient client = Sasl.createSaslClient(new String[]{LOCAL_USER}, "George", "TestProtocol", "TestServer", Collections.emptyMap(), clientCallback);
        Assert.assertTrue((boolean)client.hasInitialResponse());
        byte[] response = client.evaluateChallenge(new byte[0]);
        byte[] challenge = server.evaluateResponse(response);
        response = client.evaluateChallenge(challenge);
        challenge = server.evaluateResponse(response);
        Assert.assertNull((Object)challenge);
        Assert.assertTrue((boolean)server.isComplete());
        Assert.assertTrue((boolean)client.isComplete());
        Assert.assertEquals((Object)"George", (Object)server.getAuthorizationID());
        server.dispose();
    }

    private CallbackHandler createClientCallbackHandler(String expectedUsername) throws Exception {
        AuthenticationContext context = AuthenticationContext.empty().with(MatchRule.ALL, AuthenticationConfiguration.empty().useName(expectedUsername).useRealm("mainRealm").setSaslMechanismSelector(SaslMechanismSelector.NONE.addMechanism(LOCAL_USER)));
        return ClientUtils.getCallbackHandler(new URI("doesnot://matter?"), context);
    }
}

