/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.security.AccessController;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.WildFlyElytronProvider;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.realm.KeyStoreBackedSecurityRealm;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.permission.PermissionVerifier;
import org.wildfly.security.ssl.Protocol;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLAuthenticationTest;
import org.wildfly.security.ssl.SSLContextBuilder;
import org.wildfly.security.x500.cert.BasicConstraintsExtension;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;
import org.wildfly.security.x500.cert.X509CertificateBuilder;
import org.wildfly.security.x500.cert.X509CertificateExtension;
import org.wildfly.security.x500.principal.X500AttributePrincipalDecoder;

public class SSLv2HelloAuthenticationTest {
    private static final String CLIENT_CONFIG = "sslv2-hello-authentication-config.xml";
    private static final char[] PASSWORD = "Elytron".toCharArray();
    private static final String CA_JKS_LOCATION = "./target/test-classes/ca/pkcs12";
    private static File ladybirdFile = null;
    private static File scarabFile = null;
    private static File beetlesFile = null;
    private static File trustFile = null;
    private static File workingDirCA = null;
    private static SecurityRealm securityRealm = null;
    private static SecurityDomain securityDomain = null;
    public static String disabledAlgorithms;

    @BeforeClass
    public static void setUp() throws Exception {
        disabledAlgorithms = Security.getProperty("jdk.tls.disabledAlgorithms");
        if (disabledAlgorithms != null && (disabledAlgorithms.contains("TLSv1") || disabledAlgorithms.contains("TLSv1.1"))) {
            Security.setProperty("jdk.tls.disabledAlgorithms", "");
        }
        if (!(workingDirCA = new File(CA_JKS_LOCATION)).exists()) {
            workingDirCA.mkdirs();
        }
        ladybirdFile = new File(workingDirCA, "ladybird.keystore");
        scarabFile = new File(workingDirCA, "scarab.keystore");
        beetlesFile = new File(workingDirCA, "beetles.keystore");
        trustFile = new File(workingDirCA, "ca.truststore");
        SSLv2HelloAuthenticationTest.createKeyStores(ladybirdFile, scarabFile, beetlesFile, trustFile);
        securityRealm = new KeyStoreBackedSecurityRealm(SSLv2HelloAuthenticationTest.loadKeyStore("/ca/pkcs12/beetles.keystore"));
        securityDomain = SecurityDomain.builder().addRealm("KeystoreRealm", securityRealm).build().setDefaultRealmName("KeystoreRealm").setPrincipalDecoder((PrincipalDecoder)new X500AttributePrincipalDecoder("2.5.4.3", 1)).setPreRealmRewriter(s -> s.toLowerCase(Locale.ENGLISH)).setPermissionMapper((permissionMappable, roles) -> PermissionVerifier.ALL).build();
    }

    @AfterClass
    public static void cleanUp() {
        ladybirdFile.delete();
        ladybirdFile = null;
        scarabFile.delete();
        scarabFile = null;
        beetlesFile.delete();
        beetlesFile = null;
        trustFile.delete();
        trustFile = null;
        workingDirCA.delete();
        workingDirCA = null;
        if (disabledAlgorithms != null) {
            Security.setProperty("jdk.tls.disabledAlgorithms", disabledAlgorithms);
        }
    }

    @Test
    public void testOneWaySSLv2HelloProtocolMatch() throws Exception {
        ArrayList<Protocol> list = new ArrayList<Protocol>();
        list.add(Protocol.forName((String)"SSLv2Hello"));
        list.add(Protocol.forName((String)"TLSv1"));
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(securityDomain).setKeyManager(SSLv2HelloAuthenticationTest.getKeyManager("/ca/pkcs12/scarab.keystore")).setProtocolSelector(ProtocolSelector.empty().add(EnumSet.copyOf(list))).build().create();
        String[] enabledProtocols = new String[]{"SSLv2Hello", "TLSv1"};
        SecurityIdentity identity = this.performConnectionTest(serverContext, "protocol://one-way-sslv2hello.org", CLIENT_CONFIG, enabledProtocols, "TLSv1");
    }

    @Test
    public void testTwoWaySSLv2HelloProtocolMatch() throws Exception {
        ArrayList<Protocol> list = new ArrayList<Protocol>();
        list.add(Protocol.forName((String)"SSLv2Hello"));
        list.add(Protocol.forName((String)"TLSv1"));
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(securityDomain).setKeyManager(SSLv2HelloAuthenticationTest.getKeyManager("/ca/pkcs12/scarab.keystore")).setTrustManager(SSLv2HelloAuthenticationTest.getCATrustManager()).setNeedClientAuth(true).setProtocolSelector(ProtocolSelector.empty().add(EnumSet.copyOf(list))).build().create();
        String[] enabledProtocols = new String[]{"SSLv2Hello", "TLSv1"};
        SecurityIdentity identity = this.performConnectionTest(serverContext, "protocol://test-two-way-sslv2hello.org", CLIENT_CONFIG, enabledProtocols, "TLSv1");
        Assert.assertNotNull((Object)identity);
        Assert.assertEquals((String)"Principal Name", (Object)"ladybird", (Object)identity.getPrincipal().getName());
    }

    @Test
    public void testTwoWaySSLv2HelloNotEnabled() throws Exception {
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(securityDomain).setKeyManager(SSLv2HelloAuthenticationTest.getKeyManager("/ca/pkcs12/scarab.keystore")).setTrustManager(SSLv2HelloAuthenticationTest.getCATrustManager()).setNeedClientAuth(true).build().create();
        String[] enabledProtocols = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"};
        SecurityIdentity identity = this.performConnectionTest(serverContext, "protocol://two-way-no-sslv2hello.org", CLIENT_CONFIG, enabledProtocols, "TLSv1.2");
        Assert.assertNotNull((Object)identity);
        Assert.assertEquals((String)"Principal Name", (Object)"ladybird", (Object)identity.getPrincipal().getName());
    }

    @Test
    public void testTwoWaySSLv2HelloNoClientSupport() throws Exception {
        ArrayList<Protocol> list = new ArrayList<Protocol>();
        list.add(Protocol.forName((String)"SSLv2Hello"));
        list.add(Protocol.forName((String)"TLSv1"));
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(securityDomain).setKeyManager(SSLv2HelloAuthenticationTest.getKeyManager("/ca/pkcs12/scarab.keystore")).setTrustManager(SSLv2HelloAuthenticationTest.getCATrustManager()).setNeedClientAuth(true).setProtocolSelector(ProtocolSelector.empty().add(EnumSet.copyOf(list))).build().create();
        String[] enabledServerProtocols = new String[]{"SSLv2Hello", "TLSv1"};
        String[] enabledClientProtocols = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"};
        SecurityIdentity identity = this.performConnectionTest(serverContext, "protocol://two-way-no-sslv2hello.org", CLIENT_CONFIG, enabledClientProtocols, enabledServerProtocols, "TLSv1");
        Assert.assertNotNull((Object)identity);
        Assert.assertEquals((String)"Principal Name", (Object)"ladybird", (Object)identity.getPrincipal().getName());
    }

    @Test
    public void testTwoWaySSlv2HelloNoServerSupport() throws Exception {
        ArrayList<Protocol> list = new ArrayList<Protocol>();
        list.add(Protocol.forName((String)"TLSv1.1"));
        SSLContext serverContext = (SSLContext)new SSLContextBuilder().setSecurityDomain(securityDomain).setKeyManager(SSLv2HelloAuthenticationTest.getKeyManager("/ca/pkcs12/scarab.keystore")).setTrustManager(SSLv2HelloAuthenticationTest.getCATrustManager()).setNeedClientAuth(true).setProtocolSelector(ProtocolSelector.empty().add(EnumSet.copyOf(list))).build().create();
        String[] serverEnabledProtocols = new String[]{"TLSv1.1"};
        String[] clientEnabledProtocols = new String[]{"SSLv2Hello", "TLSv1"};
        SecurityIdentity identity = this.performConnectionTest(serverContext, "protocol://test-two-way-sslv2hello.org", CLIENT_CONFIG, clientEnabledProtocols, serverEnabledProtocols, "NONE");
        Assert.assertNull((Object)identity);
    }

    private SecurityIdentity performConnectionTest(SSLContext serverContext, String clientUri, String clientConfigFileName, String[] enabledProtocols, String negotiatedProtocol) throws Exception {
        return this.performConnectionTest(serverContext, clientUri, clientConfigFileName, enabledProtocols, enabledProtocols, negotiatedProtocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityIdentity performConnectionTest(SSLContext serverContext, String clientUri, String clientConfigFileName, String[] enabledClientProtocols, String[] enabledServerProtocols, String negotiatedProtocol) throws Exception {
        System.setProperty("wildfly.config.url", SSLAuthenticationTest.class.getResource(clientConfigFileName).toExternalForm());
        AccessController.doPrivileged(() -> Security.insertProviderAt((Provider)new WildFlyElytronProvider(), 1));
        AuthenticationContext context = (AuthenticationContext)AuthenticationContext.getContextManager().get();
        AuthenticationContextConfigurationClient contextConfigurationClient = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
        SSLContext clientContext = contextConfigurationClient.getSSLContext(URI.create(clientUri), context);
        SSLServerSocketFactory sslServerSocketFactory = serverContext.getServerSocketFactory();
        SSLServerSocket sslServerSocket = (SSLServerSocket)sslServerSocketFactory.createServerSocket(1111, 10, InetAddress.getLoopbackAddress());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<SSLSocket> socketFuture = executorService.submit(() -> {
            try {
                System.out.println("About to connect client");
                SSLSocket sslSocket = (SSLSocket)clientContext.getSocketFactory().createSocket(InetAddress.getLoopbackAddress(), 1111);
                sslSocket.getSession();
                SSLSocket sSLSocket = sslSocket;
                return sSLSocket;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                System.out.println("Client connected");
            }
        });
        SSLSocket serverSocket = (SSLSocket)sslServerSocket.accept();
        SSLSession serverSession = serverSocket.getSession();
        SSLSocket clientSocket = socketFuture.get();
        SSLSession clientSession = clientSocket.getSession();
        try {
            HashSet<String> serverProtocols = new HashSet<String>(Arrays.asList(serverSocket.getEnabledProtocols()));
            HashSet<String> clientProtocols = new HashSet<String>(Arrays.asList(clientSocket.getEnabledProtocols()));
            HashSet<String> enabledServer = new HashSet<String>(Arrays.asList(enabledServerProtocols));
            HashSet<String> enabledClient = new HashSet<String>(Arrays.asList(enabledClientProtocols));
            Assert.assertTrue((boolean)enabledServer.equals(serverProtocols));
            Assert.assertTrue((boolean)enabledClient.equals(clientProtocols));
            Assert.assertEquals((Object)negotiatedProtocol, (Object)serverSession.getProtocol());
            Assert.assertEquals((Object)negotiatedProtocol, (Object)clientSession.getProtocol());
            SecurityIdentity securityIdentity = (SecurityIdentity)serverSession.getValue("org.wildfly.security.ssl.identity");
            return securityIdentity;
        }
        finally {
            this.safeClose(serverSocket);
            this.safeClose(clientSocket);
            this.safeClose(sslServerSocket);
        }
    }

    private static X509ExtendedKeyManager getKeyManager(String keystorePath) throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(SSLv2HelloAuthenticationTest.loadKeyStore(keystorePath), PASSWORD);
        for (KeyManager current : keyManagerFactory.getKeyManagers()) {
            if (!(current instanceof X509ExtendedKeyManager)) continue;
            return (X509ExtendedKeyManager)current;
        }
        throw new IllegalStateException("Unable to obtain X509ExtendedKeyManager.");
    }

    private static X509TrustManager getCATrustManager() throws Exception {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(SSLv2HelloAuthenticationTest.loadKeyStore("/ca/pkcs12/ca.truststore"));
        for (TrustManager current : trustManagerFactory.getTrustManagers()) {
            if (!(current instanceof X509TrustManager)) continue;
            return (X509TrustManager)current;
        }
        throw new IllegalStateException("Unable to obtain X509TrustManager.");
    }

    private static KeyStore loadKeyStore() throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(null, null);
        return ks;
    }

    private static KeyStore loadKeyStore(String path) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        try (InputStream caTrustStoreFile = SSLAuthenticationTest.class.getResourceAsStream(path);){
            keyStore.load(caTrustStoreFile, PASSWORD);
        }
        return keyStore;
    }

    private static void createTemporaryKeyStoreFile(KeyStore keyStore, File outputFile, char[] password) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            keyStore.store(fos, password);
        }
    }

    private static void createKeyStores(File ladybirdFile, File scarabFile, File beetlesFile, File trustFile) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        Security.addProvider((Provider)new BouncyCastleProvider());
        X500Principal issuerDN = new X500Principal("CN=Elytron CA, ST=Elytron, C=UK, EMAILADDRESS=elytron@wildfly.org, O=Root Certificate Authority");
        X500Principal intermediateIssuerDN = new X500Principal("CN=Elytron ICA, ST=Elytron, C=UK, O=Intermediate Certificate Authority");
        X500Principal ladybirdDN = new X500Principal("OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=Ladybird");
        X500Principal scarabDN = new X500Principal("OU=Elytron, O=Elytron, C=UK, ST=Elytron, CN=Scarab");
        KeyStore ladybirdKeyStore = SSLv2HelloAuthenticationTest.loadKeyStore();
        KeyStore scarabKeyStore = SSLv2HelloAuthenticationTest.loadKeyStore();
        KeyStore beetlesKeyStore = SSLv2HelloAuthenticationTest.loadKeyStore();
        KeyStore trustStore = SSLv2HelloAuthenticationTest.loadKeyStore();
        SelfSignedX509CertificateAndSigningKey issuerSelfSignedX509CertificateAndSigningKey = SelfSignedX509CertificateAndSigningKey.builder().setDn(issuerDN).setKeyAlgorithmName("RSA").setSignatureAlgorithmName("SHA256withRSA").addExtension(false, "BasicConstraints", "CA:true,pathlen:2147483647").build();
        X509Certificate issuerCertificate = issuerSelfSignedX509CertificateAndSigningKey.getSelfSignedCertificate();
        ladybirdKeyStore.setCertificateEntry("ca", issuerCertificate);
        scarabKeyStore.setCertificateEntry("ca", issuerCertificate);
        trustStore.setCertificateEntry("mykey", issuerCertificate);
        KeyPair intermediateIssuerKeys = keyPairGenerator.generateKeyPair();
        PrivateKey intermediateIssuerSigningKey = intermediateIssuerKeys.getPrivate();
        PublicKey intermediateIssuerPublicKey = intermediateIssuerKeys.getPublic();
        X509Certificate intermediateIssuerCertificate = new X509CertificateBuilder().setIssuerDn(issuerDN).setSubjectDn(intermediateIssuerDN).setSignatureAlgorithmName("SHA256withRSA").setSigningKey(issuerSelfSignedX509CertificateAndSigningKey.getSigningKey()).setPublicKey(intermediateIssuerPublicKey).setSerialNumber(new BigInteger("6")).addExtension((X509CertificateExtension)new BasicConstraintsExtension(false, true, 0)).build();
        KeyPair ladybirdKeys = keyPairGenerator.generateKeyPair();
        PrivateKey ladybirdSigningKey = ladybirdKeys.getPrivate();
        PublicKey ladybirdPublicKey = ladybirdKeys.getPublic();
        X509Certificate ladybirdCertificate = new X509CertificateBuilder().setIssuerDn(issuerDN).setSubjectDn(ladybirdDN).setSignatureAlgorithmName("SHA256withRSA").setSigningKey(issuerSelfSignedX509CertificateAndSigningKey.getSigningKey()).setPublicKey(ladybirdPublicKey).setSerialNumber(new BigInteger("3")).addExtension((X509CertificateExtension)new BasicConstraintsExtension(false, false, -1)).build();
        ladybirdKeyStore.setKeyEntry("ladybird", ladybirdSigningKey, PASSWORD, new X509Certificate[]{ladybirdCertificate, issuerCertificate});
        KeyPair scarabKeys = keyPairGenerator.generateKeyPair();
        PrivateKey scarabSigningKey = scarabKeys.getPrivate();
        PublicKey scarabPublicKey = scarabKeys.getPublic();
        X509Certificate scarabCertificate = new X509CertificateBuilder().setIssuerDn(issuerDN).setSubjectDn(scarabDN).setSignatureAlgorithmName("SHA256withRSA").setSigningKey(issuerSelfSignedX509CertificateAndSigningKey.getSigningKey()).setPublicKey(scarabPublicKey).setSerialNumber(new BigInteger("4")).addExtension((X509CertificateExtension)new BasicConstraintsExtension(false, false, -1)).build();
        scarabKeyStore.setKeyEntry("scarab", scarabSigningKey, PASSWORD, new X509Certificate[]{scarabCertificate, issuerCertificate});
        beetlesKeyStore.setCertificateEntry("ladybird", ladybirdCertificate);
        beetlesKeyStore.setCertificateEntry("scarab", scarabCertificate);
        SSLv2HelloAuthenticationTest.createTemporaryKeyStoreFile(ladybirdKeyStore, ladybirdFile, PASSWORD);
        SSLv2HelloAuthenticationTest.createTemporaryKeyStoreFile(scarabKeyStore, scarabFile, PASSWORD);
        SSLv2HelloAuthenticationTest.createTemporaryKeyStoreFile(beetlesKeyStore, beetlesFile, PASSWORD);
        SSLv2HelloAuthenticationTest.createTemporaryKeyStoreFile(trustStore, trustFile, PASSWORD);
    }

    private void safeClose(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

