/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.runtime.invocation;

import java.lang.reflect.Method;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.wildfly.swarm.config.runtime.invocation.IndexFactory;

class SubresourceFilter {
    private final Comparator<Method> comparator;
    private final Class<?> parentClass;
    private final Index index;

    public SubresourceFilter(Class<?> parentClass) {
        this.parentClass = parentClass;
        this.index = IndexFactory.createIndex(parentClass);
        String name = this.parentClass.getName();
        this.comparator = name.startsWith("org.wildfly.swarm.config.Logging") || name.startsWith("org.wildfly.swarm.config.logging") ? new LoggingComparator() : new DefaultComparator();
    }

    public List<Method> invoke() throws NoSuchMethodException {
        return SubresourceFilter.__invoke(this.parentClass, this.index, this.comparator);
    }

    private static List<Method> __invoke(Class<?> clazz, Index index, Comparator<Method> comparator) throws NoSuchMethodException {
        ArrayList<Method> methods = new ArrayList<Method>();
        ClassInfo clazzInfo = index.getClassByName(DotName.createSimple((String)clazz.getName()));
        for (MethodInfo method : clazzInfo.methods()) {
            if (!method.hasAnnotation(IndexFactory.SUBRESOURCE_META)) continue;
            methods.add(clazz.getMethod(method.name(), new Class[0]));
        }
        if (clazzInfo.superName() != null && clazz.getSuperclass() != Object.class) {
            index = IndexFactory.createIndex(clazz.getSuperclass());
            return SubresourceFilter.__invoke(clazz.getSuperclass(), index, comparator);
        }
        Collections.sort(methods, comparator);
        return methods;
    }

    private class DefaultComparator
    implements Comparator<Method> {
        private DefaultComparator() {
        }

        @Override
        public int compare(Method o1, Method o2) {
            return Collator.getInstance().compare(o1.getName(), o2.getName());
        }
    }

    private class LoggingComparator
    implements Comparator<Method> {
        private LoggingComparator() {
        }

        @Override
        public int compare(Method o1, Method o2) {
            if (o1.getName().contains("Formatter")) {
                return -1;
            }
            if (o1.getName().equals("loggers") || o1.getName().equals("rootLogger")) {
                return 1;
            }
            return -1;
        }
    }
}

