/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.ClassicVault;
import org.wildfly.swarm.config.security.ClassicVaultConsumer;
import org.wildfly.swarm.config.security.ClassicVaultSupplier;
import org.wildfly.swarm.config.security.SecurityDomain;
import org.wildfly.swarm.config.security.SecurityDomainConsumer;
import org.wildfly.swarm.config.security.SecurityDomainSupplier;

@Address(value="/subsystem=security")
@ResourceType(value="subsystem")
@Implicit
public class Security<T extends Security<T>>
extends HashMap {
    private String key = "security";
    private PropertyChangeSupport pcs;
    private SecurityResources subresources = new SecurityResources();
    private Boolean deepCopySubjectMode;

    public Security() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public SecurityResources subresources() {
        return this.subresources;
    }

    public T securityDomains(List<SecurityDomain> value) {
        this.subresources.securityDomains = value;
        return (T)this;
    }

    public T securityDomain(SecurityDomain value) {
        this.subresources.securityDomains.add(value);
        return (T)this;
    }

    public T securityDomain(String childKey, SecurityDomainConsumer consumer) {
        SecurityDomain child = new SecurityDomain(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.securityDomain(child);
        return (T)this;
    }

    public T securityDomain(String childKey) {
        this.securityDomain(childKey, null);
        return (T)this;
    }

    public T securityDomain(SecurityDomainSupplier supplier) {
        this.securityDomain(supplier.get());
        return (T)this;
    }

    public T classicVault(ClassicVault value) {
        this.subresources.classicVault = value;
        return (T)this;
    }

    public T classicVault(ClassicVaultConsumer consumer) {
        ClassicVault child = new ClassicVault();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.classicVault = child;
        return (T)this;
    }

    public T classicVault() {
        ClassicVault child = new ClassicVault();
        this.subresources.classicVault = child;
        return (T)this;
    }

    public T classicVault(ClassicVaultSupplier supplier) {
        this.subresources.classicVault = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="deep-copy-subject-mode")
    public Boolean deepCopySubjectMode() {
        return this.deepCopySubjectMode;
    }

    public T deepCopySubjectMode(Boolean value) {
        Boolean oldValue = this.deepCopySubjectMode;
        this.deepCopySubjectMode = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("deepCopySubjectMode", oldValue, value);
        }
        return (T)this;
    }

    public static class SecurityResources {
        private List<SecurityDomain> securityDomains = new ArrayList<SecurityDomain>();
        private ClassicVault classicVault;

        @Subresource
        public List<SecurityDomain> securityDomains() {
            return this.securityDomains;
        }

        public SecurityDomain securityDomain(String key) {
            return this.securityDomains.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public ClassicVault classicVault() {
            return this.classicVault;
        }
    }
}

