/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.jca;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.swarm.config.jca.LongRunningThreads;
import org.wildfly.swarm.config.jca.LongRunningThreadsConsumer;
import org.wildfly.swarm.config.jca.LongRunningThreadsSupplier;
import org.wildfly.swarm.config.jca.ShortRunningThreads;
import org.wildfly.swarm.config.jca.ShortRunningThreadsConsumer;
import org.wildfly.swarm.config.jca.ShortRunningThreadsSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/subsystem=jca/distributed-workmanager=*")
@ResourceType(value="distributed-workmanager")
public class DistributedWorkmanager<T extends DistributedWorkmanager<T>>
extends HashMap {
    private String key;
    private PropertyChangeSupport pcs;
    private DistributedWorkmanagerResources subresources = new DistributedWorkmanagerResources();
    private String name;
    private Policy policy;
    private Map policyOptions;
    private Selector selector;
    private Map selectorOptions;

    public DistributedWorkmanager(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public DistributedWorkmanagerResources subresources() {
        return this.subresources;
    }

    public T longRunningThreads(List<LongRunningThreads> value) {
        this.subresources.longRunningThreads = value;
        return (T)this;
    }

    public T longRunningThreads(LongRunningThreads value) {
        this.subresources.longRunningThreads.add(value);
        return (T)this;
    }

    public T longRunningThreads(String childKey, LongRunningThreadsConsumer consumer) {
        LongRunningThreads child = new LongRunningThreads(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.longRunningThreads(child);
        return (T)this;
    }

    public T longRunningThreads(String childKey) {
        this.longRunningThreads(childKey, null);
        return (T)this;
    }

    public T longRunningThreads(LongRunningThreadsSupplier supplier) {
        this.longRunningThreads(supplier.get());
        return (T)this;
    }

    public T shortRunningThreads(List<ShortRunningThreads> value) {
        this.subresources.shortRunningThreads = value;
        return (T)this;
    }

    public T shortRunningThreads(ShortRunningThreads value) {
        this.subresources.shortRunningThreads.add(value);
        return (T)this;
    }

    public T shortRunningThreads(String childKey, ShortRunningThreadsConsumer consumer) {
        ShortRunningThreads child = new ShortRunningThreads(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.shortRunningThreads(child);
        return (T)this;
    }

    public T shortRunningThreads(String childKey) {
        this.shortRunningThreads(childKey, null);
        return (T)this;
    }

    public T shortRunningThreads(ShortRunningThreadsSupplier supplier) {
        this.shortRunningThreads(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="name")
    public String name() {
        return this.name;
    }

    public T name(String value) {
        String oldValue = this.name;
        this.name = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("name", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="policy")
    public Policy policy() {
        return this.policy;
    }

    public T policy(Policy value) {
        Policy oldValue = this.policy;
        this.policy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("policy", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="policy-options")
    public Map policyOptions() {
        return this.policyOptions;
    }

    public T policyOptions(Map value) {
        Map oldValue = this.policyOptions;
        this.policyOptions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("policyOptions", oldValue, value);
        }
        return (T)this;
    }

    public T policyOption(String key, Object value) {
        if (this.policyOptions == null) {
            this.policyOptions = new HashMap();
        }
        this.policyOptions.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="selector")
    public Selector selector() {
        return this.selector;
    }

    public T selector(Selector value) {
        Selector oldValue = this.selector;
        this.selector = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("selector", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="selector-options")
    public Map selectorOptions() {
        return this.selectorOptions;
    }

    public T selectorOptions(Map value) {
        Map oldValue = this.selectorOptions;
        this.selectorOptions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("selectorOptions", oldValue, value);
        }
        return (T)this;
    }

    public T selectorOption(String key, Object value) {
        if (this.selectorOptions == null) {
            this.selectorOptions = new HashMap();
        }
        this.selectorOptions.put(key, value);
        return (T)this;
    }

    public static enum Selector {
        FIRST_AVAILABLE("FIRST_AVAILABLE"),
        PING_TIME("PING_TIME"),
        MAX_FREE_THREADS("MAX_FREE_THREADS");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Selector(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum Policy {
        NEVER("NEVER"),
        ALWAYS("ALWAYS"),
        WATERMARK("WATERMARK");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Policy(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static class DistributedWorkmanagerResources {
        private List<LongRunningThreads> longRunningThreads = new ArrayList<LongRunningThreads>();
        private List<ShortRunningThreads> shortRunningThreads = new ArrayList<ShortRunningThreads>();

        @Subresource
        public List<LongRunningThreads> longRunningThreads() {
            return this.longRunningThreads;
        }

        public LongRunningThreads longRunningThreads(String key) {
            return this.longRunningThreads.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ShortRunningThreads> shortRunningThreads() {
            return this.shortRunningThreads;
        }

        public ShortRunningThreads shortRunningThreads(String key) {
            return this.shortRunningThreads.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

