/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.service;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jboss.dmr.Property;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/core-service=management/service=management-operations/active-operation=*")
@ResourceType(value="active-operation")
public class ActiveOperation<T extends ActiveOperation<T>>
extends HashMap {
    private String key;
    private PropertyChangeSupport pcs;
    private AccessMechanism accessMechanism;
    private List<Property> address;
    private String callerThread;
    private Boolean cancelled;
    private Long exclusiveRunningTime;
    private ExecutionStatus executionStatus;
    private String operation;
    private Long runningTime;

    public ActiveOperation(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="access-mechanism")
    public AccessMechanism accessMechanism() {
        return this.accessMechanism;
    }

    public T accessMechanism(AccessMechanism value) {
        AccessMechanism oldValue = this.accessMechanism;
        this.accessMechanism = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("accessMechanism", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="address")
    public List<Property> address() {
        return this.address;
    }

    public T address(List<Property> value) {
        List<Property> oldValue = this.address;
        this.address = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("address", oldValue, value);
        }
        return (T)this;
    }

    public T address(Property value) {
        if (this.address == null) {
            this.address = new ArrayList<Property>();
        }
        this.address.add(value);
        return (T)this;
    }

    public T address(Property ... args) {
        this.address(Arrays.asList(args));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="caller-thread")
    public String callerThread() {
        return this.callerThread;
    }

    public T callerThread(String value) {
        String oldValue = this.callerThread;
        this.callerThread = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("callerThread", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cancelled")
    public Boolean cancelled() {
        return this.cancelled;
    }

    public T cancelled(Boolean value) {
        Boolean oldValue = this.cancelled;
        this.cancelled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cancelled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="exclusive-running-time")
    public Long exclusiveRunningTime() {
        return this.exclusiveRunningTime;
    }

    public T exclusiveRunningTime(Long value) {
        Long oldValue = this.exclusiveRunningTime;
        this.exclusiveRunningTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("exclusiveRunningTime", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="execution-status")
    public ExecutionStatus executionStatus() {
        return this.executionStatus;
    }

    public T executionStatus(ExecutionStatus value) {
        ExecutionStatus oldValue = this.executionStatus;
        this.executionStatus = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("executionStatus", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="operation")
    public String operation() {
        return this.operation;
    }

    public T operation(String value) {
        String oldValue = this.operation;
        this.operation = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("operation", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="running-time")
    public Long runningTime() {
        return this.runningTime;
    }

    public T runningTime(Long value) {
        Long oldValue = this.runningTime;
        this.runningTime = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("runningTime", oldValue, value);
        }
        return (T)this;
    }

    public static enum ExecutionStatus {
        EXECUTING("executing"),
        AWAITING_OTHER_OPERATION("awaiting-other-operation"),
        AWAITING_STABILITY("awaiting-stability"),
        COMPLETING("completing"),
        ROLLING_BACK("rolling-back");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private ExecutionStatus(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum AccessMechanism {
        NATIVE("NATIVE"),
        HTTP("HTTP"),
        JMX("JMX");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private AccessMechanism(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

