package org.wildfly.swarm.config.microprofile.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * Config Source
 */
@Address("/subsystem=microprofile-config/config-source=*")
@ResourceType("config-source")
public class ConfigSource<T extends ConfigSource<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Class of the config source to load")
	private Map attributeClass;
	@AttributeDocumentation("Directory that is scanned to config properties for this config source (file names are key, file content are value)")
	private String dir;
	@AttributeDocumentation("Ordinal value for the config source")
	private Integer ordinal;
	@AttributeDocumentation("Properties configured for this config source")
	private Map properties;

	public ConfigSource(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Class of the config source to load
	 */
	@ModelNodeBinding(detypedName = "class")
	public Map attributeClass() {
		return this.attributeClass;
	}

	/**
	 * Class of the config source to load
	 */
	@SuppressWarnings("unchecked")
	public T attributeClass(java.util.Map value) {
		Object oldValue = this.attributeClass;
		this.attributeClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attributeClass", oldValue, value);
		return (T) this;
	}

	/**
	 * Class of the config source to load
	 */
	@SuppressWarnings("unchecked")
	public T attributeClass(java.lang.String key, java.lang.Object value) {
		if (this.attributeClass == null) {
			this.attributeClass = new java.util.HashMap<>();
		}
		this.attributeClass.put(key, value);
		return (T) this;
	}

	/**
	 * Directory that is scanned to config properties for this config source
	 * (file names are key, file content are value)
	 */
	@ModelNodeBinding(detypedName = "dir")
	public String dir() {
		return this.dir;
	}

	/**
	 * Directory that is scanned to config properties for this config source
	 * (file names are key, file content are value)
	 */
	@SuppressWarnings("unchecked")
	public T dir(java.lang.String value) {
		Object oldValue = this.dir;
		this.dir = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("dir", oldValue, value);
		return (T) this;
	}

	/**
	 * Ordinal value for the config source
	 */
	@ModelNodeBinding(detypedName = "ordinal")
	public Integer ordinal() {
		return this.ordinal;
	}

	/**
	 * Ordinal value for the config source
	 */
	@SuppressWarnings("unchecked")
	public T ordinal(java.lang.Integer value) {
		Object oldValue = this.ordinal;
		this.ordinal = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("ordinal", oldValue, value);
		return (T) this;
	}

	/**
	 * Properties configured for this config source
	 */
	@ModelNodeBinding(detypedName = "properties")
	public Map properties() {
		return this.properties;
	}

	/**
	 * Properties configured for this config source
	 */
	@SuppressWarnings("unchecked")
	public T properties(java.util.Map value) {
		Object oldValue = this.properties;
		this.properties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("properties", oldValue, value);
		return (T) this;
	}

	/**
	 * Properties configured for this config source
	 */
	@SuppressWarnings("unchecked")
	public T property(java.lang.String key, java.lang.Object value) {
		if (this.properties == null) {
			this.properties = new java.util.HashMap<>();
		}
		this.properties.put(key, value);
		return (T) this;
	}
}