/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.modules.MavenArtifactUtil;
import org.jboss.modules.ModuleLoadException;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.wildfly.swarm.container.Container;
import org.wildfly.swarm.container.Deployment;

public class WarDeployment
implements Deployment {
    private static final String JBOSS_WEB_CONTENTS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<jboss-web>\n    <context-root>${CONTEXT_PATH}</context-root>\n</jboss-web>";
    protected final WebArchive archive;
    protected boolean webInfLibAdded;
    protected String contextPath;
    protected Set<String> structureModules = new HashSet<String>();
    protected Map<String, String> staticResources = new HashMap<String, String>();
    private static final String JBOSS_DEPLOYMENT_STRUCTURE_CONTENTS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>  \n<jboss-deployment-structure>  \n    <deployment>  \n         <dependencies>  \n              ${MODULES}\n        </dependencies>  \n    </deployment>  \n</jboss-deployment-structure>\n";

    public WarDeployment(Container container) throws IOException, ModuleLoadException {
        this(container, null);
    }

    public WarDeployment(Container container, String contextPath) throws IOException, ModuleLoadException {
        this.archive = (WebArchive)container.getShrinkWrapDomain().getArchiveFactory().create(WebArchive.class);
        this.contextPath = contextPath;
        if (this.contextPath == null) {
            this.contextPath = System.getProperty("wildfly.swarm.context.path");
        }
        if (this.contextPath == null) {
            this.contextPath = "/";
        }
    }

    public WarDeployment staticContent() {
        return this.staticContent("/", ".");
    }

    public WarDeployment staticContent(String context) {
        return this.staticContent(context, ".");
    }

    public WarDeployment staticContent(String context, String base) {
        this.staticResources.put(context, base);
        this.structureModules.add("org.wildfly.swarm.runtime.undertow");
        return this;
    }

    protected void ensureJBossWebXml() {
        if (this.archive.contains("WEB-INF/jboss-web.xml")) {
            return;
        }
        this.archive.add((Asset)new StringAsset(JBOSS_WEB_CONTENTS.replace("${CONTEXT_PATH}", this.contextPath)), "WEB-INF/jboss-web.xml");
    }

    protected void addJavaClassPathToWebInfLib() {
        String classpath = System.getProperty("java.class.path");
        String javaHome = System.getProperty("java.home");
        if (classpath != null) {
            String[] elements = classpath.split(File.pathSeparator);
            for (int i = 0; i < elements.length; ++i) {
                File file;
                if (elements[i].startsWith(javaHome) || !(file = new File(elements[i])).isFile()) continue;
                this.archive.add((Asset)new FileAsset(file), "WEB-INF/lib/" + file.getName());
            }
        }
    }

    protected void ensureWebInfLib() {
        if (this.webInfLibAdded) {
            return;
        }
        this.webInfLibAdded = true;
        InputStream depsTxt = ClassLoader.getSystemClassLoader().getResourceAsStream("META-INF/wildfly-swarm-dependencies.txt");
        if (depsTxt != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(depsTxt));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    File artifact = MavenArtifactUtil.resolveJarArtifact((String)line);
                    FileInputStream artifactIn = new FileInputStream(artifact);
                    Throwable throwable = null;
                    try {
                        this.archive.addAsLibrary((Asset)new ByteArrayAsset((InputStream)artifactIn), artifact.getName());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (artifactIn == null) continue;
                        if (throwable != null) {
                            try {
                                artifactIn.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        artifactIn.close();
                    }
                }
                depsTxt.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void setupStaticResources() {
        StringBuilder modules = new StringBuilder();
        for (String each : this.structureModules) {
            modules.append("              <module name=\"" + each + "\"/>\n");
        }
        String structureContents = JBOSS_DEPLOYMENT_STRUCTURE_CONTENTS.replace("${MODULES}", modules.toString().trim());
        this.archive.addAsWebInfResource((Asset)new StringAsset(structureContents), "jboss-deployment-structure.xml");
        if (this.staticResources.isEmpty()) {
            return;
        }
        this.archive.addAsServiceProvider("io.undertow.server.handlers.builder.HandlerBuilder", new String[]{"org.wildfly.swarm.runtime.undertow.StaticHandlerBuilder"});
        Set<Map.Entry<String, String>> entries = this.staticResources.entrySet();
        StringBuilder conf = new StringBuilder();
        for (Map.Entry<String, String> each : entries) {
            conf.append("path-prefix['" + each.getKey() + "'] -> static-content[base='" + each.getValue() + "']\n");
        }
        this.archive.addAsWebInfResource((Asset)new StringAsset(conf.toString()), "undertow-handlers.conf");
    }

    public WebArchive getArchive() {
        return this.getArchive(false);
    }

    public WebArchive getArchive(boolean finalize) {
        if (finalize) {
            this.ensureJBossWebXml();
            this.ensureWebInfLib();
            this.setupStaticResources();
        }
        return this.archive;
    }
}

