/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.UUID;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.impl.base.importer.zip.ZipImporterImpl;
import org.wildfly.swarm.container.Container;
import org.wildfly.swarm.container.DefaultDeploymentFactory;
import org.wildfly.swarm.container.DependenciesContainer;
import org.wildfly.swarm.container.JARArchive;

public class DefaultJarDeploymentFactory
implements DefaultDeploymentFactory {
    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public String getType() {
        return "jar";
    }

    @Override
    public Archive create(Container container) throws Exception {
        JARArchive archive = (JARArchive)ShrinkWrap.create(JARArchive.class, (String)this.determineName());
        this.setup(archive);
        return archive;
    }

    protected String determineName() {
        String prop = System.getProperty("wildfly.swarm.app.path");
        if (prop != null) {
            File file = new File(prop);
            String name = file.getName();
            if (name.endsWith(".jar")) {
                return name;
            }
            return name + ".jar";
        }
        prop = System.getProperty("wildfly.swarm.app.artifact");
        if (prop != null) {
            return prop;
        }
        return UUID.randomUUID().toString() + ".jar";
    }

    protected void setup(DependenciesContainer<?> archive) throws Exception {
        boolean result = this.setupUsingAppPath(archive) || this.setupUsingAppArtifact(archive) || this.setupUsingMaven(archive);
    }

    protected boolean setupUsingAppPath(final DependenciesContainer<?> archive) throws IOException {
        String appPath = System.getProperty("wildfly.swarm.app.path");
        if (appPath != null) {
            final Path path = Paths.get(System.getProperty("wildfly.swarm.app.path"), new String[0]);
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path simple = path.relativize(file);
                        archive.add((Asset)new FileAsset(file.toFile()), DefaultJarDeploymentFactory.this.convertSeparators(simple));
                        return super.visitFile(file, attrs);
                    }
                });
            } else {
                ZipImporterImpl importer = new ZipImporterImpl(archive);
                importer.importFrom(new File(System.getProperty("wildfly.swarm.app.path")));
            }
            return true;
        }
        return false;
    }

    protected boolean setupUsingAppArtifact(DependenciesContainer<?> archive) throws IOException {
        String appArtifact = System.getProperty("wildfly.swarm.app.artifact");
        if (appArtifact != null) {
            try (InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream("_bootstrap/" + appArtifact);){
                ZipImporterImpl importer = new ZipImporterImpl(archive);
                importer.importFrom(in);
            }
            return true;
        }
        return false;
    }

    protected boolean setupUsingMaven(final DependenciesContainer<?> archive) throws Exception {
        Path pwd = Paths.get(System.getProperty("user.dir"), new String[0]);
        final Path classes = pwd.resolve("target").resolve("classes");
        boolean success = false;
        if (Files.exists(classes, new LinkOption[0])) {
            success = true;
            Files.walkFileTree(classes, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path simple = classes.relativize(file);
                    archive.add((Asset)new FileAsset(file.toFile()), DefaultJarDeploymentFactory.this.convertSeparators(simple));
                    return super.visitFile(file, attrs);
                }
            });
        }
        archive.addAllDependencies();
        return success;
    }

    protected String convertSeparators(Path path) {
        String convertedPath = path.toString();
        if (convertedPath.contains(File.separator)) {
            convertedPath = convertedPath.replace(File.separator, "/");
        }
        return convertedPath;
    }
}

