/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jaxrs;

import java.io.IOException;
import javax.ws.rs.core.Application;
import org.jboss.modules.ModuleLoadException;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.wildfly.swarm.container.Container;
import org.wildfly.swarm.container.WarDeployment;
import org.wildfly.swarm.jaxrs.ApplicationFactory;

public class JAXRSDeployment
extends WarDeployment {
    private boolean hasApplication;

    public JAXRSDeployment(Container container) throws IOException, ModuleLoadException {
        super((WebArchive)container.getShrinkWrapDomain().getArchiveFactory().create(WebArchive.class));
        this.setup();
    }

    protected void setup() {
        boolean result = this.setupUsingAppPath() || this.setupUsingAppArtifact() || this.setupUsingMaven();
    }

    protected boolean setupUsingAppPath() {
        if (System.getProperty("wildfly.swarm.app.path") != null) {
            this.addJavaClassPathToWebInfLib();
            return true;
        }
        return false;
    }

    protected boolean setupUsingAppArtifact() {
        return false;
    }

    protected boolean setupUsingMaven() {
        this.addJavaClassPathToWebInfLib();
        return true;
    }

    public void setApplication(Class<? extends Application> application) {
        this.hasApplication = true;
        this.archive.addClass(application);
    }

    public void addResource(Class<?> resourceClass) {
        this.archive.addClass(resourceClass);
    }

    protected void ensureApplication() {
        if (!this.hasApplication) {
            String name = "org.wildfly.swarm.generated.WildFlySwarmDefaultJAXRSApplication";
            this.archive.add((Asset)new ByteArrayAsset(ApplicationFactory.create(name, "/")), "WEB-INF/classes/" + name.replace('.', '/') + ".class");
            this.hasApplication = true;
        }
    }

    public WebArchive getArchive() {
        this.ensureApplication();
        return super.getArchive();
    }
}

