/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.messaging.runtime;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.swarm.container.JARArchive;
import org.wildfly.swarm.container.runtime.AbstractServerConfiguration;
import org.wildfly.swarm.messaging.MessagingFraction;
import org.wildfly.swarm.messaging.MessagingServer;

public class MessagingConfiguration
extends AbstractServerConfiguration<MessagingFraction> {
    private PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"messaging-activemq")});

    public MessagingConfiguration() {
        super(MessagingFraction.class);
    }

    public MessagingFraction defaultFraction() {
        return new MessagingFraction();
    }

    public void prepareArchive(Archive a) {
        ((JARArchive)a.as(JARArchive.class)).addModule("javax.jms.api");
    }

    public List<ModelNode> getList(MessagingFraction fraction) {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        ModelNode node = new ModelNode();
        node.get("address").set("extension", "org.wildfly.extension.messaging-activemq");
        node.get("operation").set("add");
        list.add(node);
        node = new ModelNode();
        node.get("address").set(this.address.toModelNode());
        node.get("operation").set("add");
        list.add(node);
        this.addServers(fraction, list);
        return list;
    }

    protected void addServers(MessagingFraction fraction, List<ModelNode> list) {
        List servers = fraction.servers();
        for (MessagingServer each : servers) {
            this.addServer(each, list);
        }
    }

    protected void addServer(MessagingServer server, List<ModelNode> list) {
        PathAddress serverAddress = this.address.append("server", server.name());
        ModelNode node = new ModelNode();
        node.get("address").set(serverAddress.toModelNode());
        node.get("operation").set("add");
        node.get("journal-file-size").set(102400L);
        list.add(node);
        if (server.inVMConnectorJNDIName() != null) {
            node = new ModelNode();
            node.get("address").set(serverAddress.append("in-vm-connector", "in-vm").toModelNode());
            node.get("operation").set("add");
            node.get("server-id").set(server.serverID());
            list.add(node);
            node = new ModelNode();
            node.get("address").set(serverAddress.append("in-vm-acceptor", "in-vm").toModelNode());
            node.get("operation").set("add");
            node.get("server-id").set(server.serverID());
            list.add(node);
            node = new ModelNode();
            node.get("address").set(serverAddress.append("connection-factory", "InVmConnectionFactory").toModelNode());
            node.get("operation").set("add");
            node.get("connectors").setEmptyList().add("in-vm");
            node.get("entries").setEmptyList().add(server.inVMConnectorJNDIName());
            list.add(node);
        }
        this.addTopics(server, list);
        this.addQueues(server, list);
    }

    protected void addTopics(MessagingServer server, List<ModelNode> list) {
        PathAddress serverAddress = this.address.append("server", server.name());
        for (String each : server.topics()) {
            ModelNode node = new ModelNode();
            node.get("address").set(serverAddress.append("jms-topic", each).toModelNode());
            node.get("operation").set("add");
            node.get("entries").setEmptyList().add("java:/jms/topic/" + each);
            list.add(node);
        }
    }

    protected void addQueues(MessagingServer server, List<ModelNode> list) {
        PathAddress serverAddress = this.address.append("server", server.name());
        for (String each : server.topics()) {
            ModelNode node = new ModelNode();
            node.get("address").set(serverAddress.append("jms-queue", each).toModelNode());
            node.get("operation").set("add");
            node.get("entries").setEmptyList().add("java:/jms/queue/" + each);
            list.add(node);
        }
    }
}

