/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.messaging;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;

public class MessagingServer {
    private final List<ModelNode> list = new ArrayList<ModelNode>();
    private final PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"messaging")}).append("hornetq-server", "default");

    public MessagingServer() {
        this("default");
    }

    public MessagingServer(String name) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.address.toModelNode());
        node.get("operation").set("add");
        node.get("journal-file-size").set(102400L);
        this.list.add(node);
    }

    public MessagingServer enableInVmConnector() {
        return this.enableInVmConnector("java:/ConnectionFactory");
    }

    public MessagingServer enableInVmConnector(String jndiName) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.address.append("in-vm-connector", "in-vm").toModelNode());
        node.get("operation").set("add");
        node.get("server-id").set(0);
        this.list.add(node);
        node = new ModelNode();
        node.get("address").set(this.address.append("in-vm-acceptor", "in-vm").toModelNode());
        node.get("operation").set("add");
        node.get("server-id").set(0);
        this.list.add(node);
        node = new ModelNode();
        node.get("address").set(this.address.append("connection-factory", "InVmConnectionFactory").toModelNode());
        node.get("operation").set("add");
        node.get("connector").set("in-vm", new ModelNode());
        node.get("entries").setEmptyList().add(jndiName);
        this.list.add(node);
        return this;
    }

    public MessagingServer topic(String name) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.address.append("jms-topic", name).toModelNode());
        node.get("operation").set("add");
        node.get("entries").setEmptyList().add("java:/jms/topic/" + name);
        this.list.add(node);
        return this;
    }

    public MessagingServer queue(String name) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.address.append("jms-queue", name).toModelNode());
        node.get("operation").set("add");
        node.get("entries").setEmptyList().add("java:/jms/queue/" + name);
        this.list.add(node);
        return this;
    }

    public MessagingServer enableHttpConnector(String jndiName) {
        return this;
    }

    List<ModelNode> getList() {
        return this.list;
    }
}

