/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.runtime.container;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.selfcontained.ContentProvider;
import org.jboss.as.server.SelfContainedContainer;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ValueExpression;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceContainer;
import org.wildfly.swarm.container.Container;
import org.wildfly.swarm.container.Deployer;
import org.wildfly.swarm.container.Fraction;
import org.wildfly.swarm.container.Interface;
import org.wildfly.swarm.container.RuntimeModuleProvider;
import org.wildfly.swarm.container.Server;
import org.wildfly.swarm.container.SocketBinding;
import org.wildfly.swarm.container.SocketBindingGroup;
import org.wildfly.swarm.runtime.container.RuntimeDeployer;
import org.wildfly.swarm.runtime.container.ServerConfiguration;
import org.wildfly.swarm.runtime.container.SimpleContentProvider;

public class RuntimeServer
implements Server {
    private SelfContainedContainer container = new SelfContainedContainer();
    private SimpleContentProvider contentProvider = new SimpleContentProvider();

    public Deployer start(Container config) throws Exception {
        this.applyDefaults(config);
        List<ModelNode> list = this.getList(config);
        Thread.currentThread().setContextClassLoader(RuntimeServer.class.getClassLoader());
        ServiceContainer serviceContainer = this.container.start(list, (ContentProvider)this.contentProvider);
        ModelController controller = (ModelController)serviceContainer.getService(Services.JBOSS_SERVER_CONTROLLER).getValue();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ModelControllerClient client = controller.createClient((Executor)executor);
        return new RuntimeDeployer(client, this.contentProvider);
    }

    private void applyDefaults(Container config) throws Exception {
        this.applyInterfaceDefaults(config);
        this.applySocketBindingGroupDefaults(config);
        this.applyFractionDefaults(config);
    }

    private void applyInterfaceDefaults(Container config) {
        if (config.ifaces().isEmpty()) {
            config.iface("public", "${jboss.bind.address:0.0.0.0}");
        }
    }

    private void applySocketBindingGroupDefaults(Container config) {
        if (config.socketBindingGroups().isEmpty()) {
            config.socketBindingGroup(new SocketBindingGroup("default-sockets", "public", "${jboss.socket.binding.port-offset:0}").socketBinding("http", "${jboss.http.port:8080}"));
        }
    }

    private void applyFractionDefaults(Container config) throws Exception {
        Module m1 = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.wildfly.swarm.bootstrap"));
        ServiceLoader<RuntimeModuleProvider> providerLoader = m1.loadService(RuntimeModuleProvider.class);
        Iterator<Object> providerIter = providerLoader.iterator();
        if (!providerIter.hasNext()) {
            providerLoader = ServiceLoader.load(RuntimeModuleProvider.class);
            providerIter = providerLoader.iterator();
        }
        while (providerIter.hasNext()) {
            RuntimeModuleProvider provider = (RuntimeModuleProvider)providerIter.next();
            Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)provider.getModuleName()));
            ServiceLoader configLoader = module.loadService(ServerConfiguration.class);
            for (ServerConfiguration each : configLoader) {
                boolean found = false;
                for (Fraction fraction : config.fractions()) {
                    if (!fraction.getClass().equals(each.getType())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                config.fraction(each.defaultFraction());
            }
        }
    }

    private List<ModelNode> getList(Container config) throws ModuleLoadException {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        this.configureInterfaces(config, list);
        this.configureSocketBindingGroups(config, list);
        this.configureFractions(config, list);
        return list;
    }

    private void configureInterfaces(Container config, List<ModelNode> list) {
        List ifaces = config.ifaces();
        for (Interface each : ifaces) {
            this.configureInterface(each, list);
        }
    }

    private void configureInterface(Interface iface, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set("interface", iface.getName());
        node.get("inet-address").set(new ValueExpression(iface.getExpression()));
        list.add(node);
    }

    private void configureSocketBindingGroups(Container config, List<ModelNode> list) {
        List groups = config.socketBindingGroups();
        for (SocketBindingGroup each : groups) {
            this.configureSocketBindingGroup(each, list);
        }
    }

    private void configureSocketBindingGroup(SocketBindingGroup group, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        PathAddress address = PathAddress.pathAddress((String)"socket-binding-group", (String)group.name());
        node.get("operation").set("add");
        node.get("address").set(address.toModelNode());
        node.get("default-interface").set(group.defaultInterface());
        node.get("port-offset").set(new ValueExpression(group.portOffsetExpression()));
        list.add(node);
        this.configureSocketBindings(address, group, list);
    }

    private void configureSocketBindings(PathAddress address, SocketBindingGroup group, List<ModelNode> list) {
        List bindings = group.socketBindings();
        for (SocketBinding each : bindings) {
            this.configureSocketBinding(address, each, list);
        }
    }

    private void configureSocketBinding(PathAddress address, SocketBinding binding, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(address.append("socket-binding", binding.name()).toModelNode());
        node.get("operation").set("add");
        node.get("port").set(new ValueExpression(binding.portExpression()));
        list.add(node);
    }

    private void configureFractions(Container config, List<ModelNode> list) throws ModuleLoadException {
        Module m1 = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.wildfly.swarm.bootstrap"));
        ServiceLoader<RuntimeModuleProvider> providerLoader = m1.loadService(RuntimeModuleProvider.class);
        Iterator<Object> providerIter = providerLoader.iterator();
        if (!providerIter.hasNext()) {
            providerLoader = ServiceLoader.load(RuntimeModuleProvider.class);
            providerIter = providerLoader.iterator();
        }
        while (providerIter.hasNext()) {
            RuntimeModuleProvider provider = (RuntimeModuleProvider)providerIter.next();
            Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)provider.getModuleName()));
            ServiceLoader configLoader = module.loadService(ServerConfiguration.class);
            block1: for (ServerConfiguration each : configLoader) {
                for (Fraction fraction : config.fractions()) {
                    if (!fraction.getClass().equals(each.getType())) continue;
                    list.addAll(each.getList(fraction));
                    continue block1;
                }
            }
        }
    }
}

