/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.runtime.container;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.impl.base.exporter.zip.ZipExporterImpl;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.wildfly.swarm.container.Deployer;
import org.wildfly.swarm.runtime.container.SimpleContentProvider;

public class RuntimeDeployer
implements Deployer {
    private final ModelControllerClient client;
    private final SimpleContentProvider contentProvider;
    private final ScheduledExecutorService executor;
    private final TempFileProvider tempFileProvider;
    private final List<Closeable> mountPoints = new ArrayList<Closeable>();

    public RuntimeDeployer(ModelControllerClient client, SimpleContentProvider contentProvider) throws IOException {
        this.client = client;
        this.contentProvider = contentProvider;
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.tempFileProvider = TempFileProvider.create((String)"wildfly-swarm", (ScheduledExecutorService)this.executor);
    }

    public void deploy(Archive deployment) throws IOException {
        VirtualFile mountPoint = VFS.getRootVirtualFile().getChild(deployment.getName());
        try (InputStream in = new ZipExporterImpl(deployment).exportAsInputStream();){
            Closeable closeable = VFS.mountZip((InputStream)in, (String)deployment.getName(), (VirtualFile)mountPoint, (TempFileProvider)this.tempFileProvider);
            this.mountPoints.add(closeable);
        }
        byte[] hash = this.contentProvider.addContent(mountPoint);
        ModelNode deploymentAdd = new ModelNode();
        deploymentAdd.get("operation").set("add");
        deploymentAdd.get("address").set("deployment", deployment.getName());
        deploymentAdd.get("runtime-name").set(deployment.getName());
        deploymentAdd.get("enabled").set(true);
        ModelNode content = deploymentAdd.get("content").add();
        content.get("hash").set(hash);
        System.setProperty("wildfly.swarm.current.deployment", deployment.getName());
        ModelNode result = this.client.execute(deploymentAdd);
    }

    void stop() {
        for (Closeable each : this.mountPoints) {
            try {
                each.close();
            }
            catch (IOException iOException) {}
        }
    }
}

