/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.runtime.container;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.selfcontained.ContentProvider;
import org.jboss.as.server.SelfContainedContainer;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ValueExpression;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceContainer;
import org.wildfly.swarm.container.Container;
import org.wildfly.swarm.container.Deployer;
import org.wildfly.swarm.container.Fraction;
import org.wildfly.swarm.container.Interface;
import org.wildfly.swarm.container.RuntimeModuleProvider;
import org.wildfly.swarm.container.Server;
import org.wildfly.swarm.container.SocketBinding;
import org.wildfly.swarm.container.SocketBindingGroup;
import org.wildfly.swarm.runtime.container.RuntimeDeployer;
import org.wildfly.swarm.runtime.container.ServerConfiguration;
import org.wildfly.swarm.runtime.container.SimpleContentProvider;

public class RuntimeServer
implements Server {
    private SelfContainedContainer container = new SelfContainedContainer();
    private SimpleContentProvider contentProvider = new SimpleContentProvider();
    private ServiceContainer serviceContainer;
    private ModelControllerClient client;
    private RuntimeDeployer deployer;
    private Map<Class<? extends Fraction>, ServerConfiguration> configByFractionType = new ConcurrentHashMap<Class<? extends Fraction>, ServerConfiguration>();
    private List<ServerConfiguration> configList = new ArrayList<ServerConfiguration>();

    public Deployer start(Container config) throws Exception {
        this.loadFractionConfigurations();
        this.applyDefaults(config);
        List<ModelNode> list = this.getList(config);
        list.sort(new ExtensionOpPriorityComparator());
        Thread.currentThread().setContextClassLoader(RuntimeServer.class.getClassLoader());
        this.serviceContainer = this.container.start(list, (ContentProvider)this.contentProvider);
        ModelController controller = (ModelController)this.serviceContainer.getService(Services.JBOSS_SERVER_CONTROLLER).getValue();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        this.client = controller.createClient((Executor)executor);
        this.deployer = new RuntimeDeployer(this.client, this.contentProvider);
        return this.deployer;
    }

    public void stop() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.serviceContainer.addTerminateListener(new ServiceContainer.TerminateListener(){

            public void handleTermination(ServiceContainer.TerminateListener.Info info) {
                latch.countDown();
            }
        });
        this.serviceContainer.shutdown();
        latch.await();
        this.deployer.stop();
        this.serviceContainer = null;
        this.client = null;
        this.deployer = null;
    }

    public Set<Class<? extends Fraction>> getFractionTypes() {
        return this.configByFractionType.keySet();
    }

    public Fraction createDefaultFor(Class<? extends Fraction> fractionClazz) {
        return this.configByFractionType.get(fractionClazz).defaultFraction();
    }

    private void applyDefaults(Container config) throws Exception {
        this.applyInterfaceDefaults(config);
        this.applySocketBindingGroupDefaults(config);
        config.applyFractionDefaults((Server)this);
    }

    private void applyInterfaceDefaults(Container config) {
        if (config.ifaces().isEmpty()) {
            config.iface("public", "${jboss.bind.address:0.0.0.0}");
        }
    }

    private void applySocketBindingGroupDefaults(Container config) {
        if (config.socketBindingGroups().isEmpty()) {
            config.socketBindingGroup(new SocketBindingGroup("default-sockets", "public", "${jboss.socket.binding.port-offset:0}").socketBinding("http", "${jboss.http.port:8080}"));
        }
    }

    private void loadFractionConfigurations() throws Exception {
        Module m1 = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.wildfly.swarm.bootstrap"));
        ServiceLoader<RuntimeModuleProvider> providerLoader = m1.loadService(RuntimeModuleProvider.class);
        Iterator<Object> providerIter = providerLoader.iterator();
        if (!providerIter.hasNext()) {
            providerLoader = ServiceLoader.load(RuntimeModuleProvider.class, ClassLoader.getSystemClassLoader());
            providerIter = providerLoader.iterator();
        }
        while (providerIter.hasNext()) {
            RuntimeModuleProvider provider = (RuntimeModuleProvider)providerIter.next();
            Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)provider.getModuleName()));
            ServiceLoader configLoaders = module.loadService(ServerConfiguration.class);
            for (ServerConfiguration serverConfig : configLoaders) {
                this.configByFractionType.put(serverConfig.getType(), serverConfig);
                this.configList.add(serverConfig);
            }
        }
    }

    private List<ModelNode> getList(Container config) throws ModuleLoadException {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        this.configureInterfaces(config, list);
        this.configureSocketBindingGroups(config, list);
        this.configureFractions(config, list);
        return list;
    }

    private void configureInterfaces(Container config, List<ModelNode> list) {
        List ifaces = config.ifaces();
        for (Interface each : ifaces) {
            this.configureInterface(each, list);
        }
    }

    private void configureInterface(Interface iface, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set("interface", iface.getName());
        node.get("inet-address").set(new ValueExpression(iface.getExpression()));
        list.add(node);
    }

    private void configureSocketBindingGroups(Container config, List<ModelNode> list) {
        List groups = config.socketBindingGroups();
        for (SocketBindingGroup each : groups) {
            this.configureSocketBindingGroup(each, list);
        }
    }

    private void configureSocketBindingGroup(SocketBindingGroup group, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        PathAddress address = PathAddress.pathAddress((String)"socket-binding-group", (String)group.name());
        node.get("operation").set("add");
        node.get("address").set(address.toModelNode());
        node.get("default-interface").set(group.defaultInterface());
        node.get("port-offset").set(new ValueExpression(group.portOffsetExpression()));
        list.add(node);
        this.configureSocketBindings(address, group, list);
    }

    private void configureSocketBindings(PathAddress address, SocketBindingGroup group, List<ModelNode> list) {
        List bindings = group.socketBindings();
        for (SocketBinding each : bindings) {
            this.configureSocketBinding(address, each, list);
        }
    }

    private void configureSocketBinding(PathAddress address, SocketBinding binding, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(address.append("socket-binding", binding.name()).toModelNode());
        node.get("operation").set("add");
        node.get("port").set(new ValueExpression(binding.portExpression()));
        list.add(node);
    }

    private void configureFractions(Container config, List<ModelNode> list) throws ModuleLoadException {
        for (ServerConfiguration eachConfig : this.configList) {
            boolean found = false;
            for (Fraction eachFraction : config.fractions()) {
                if (!eachConfig.getType().isAssignableFrom(eachFraction.getClass())) continue;
                found = true;
                list.addAll(eachConfig.getList(eachFraction));
                break;
            }
            if (found) continue;
            System.err.println("*** unable to find fraction for: " + eachConfig.getType());
        }
    }

    private static class ExtensionOpPriorityComparator
    implements Comparator<ModelNode> {
        private ExtensionOpPriorityComparator() {
        }

        @Override
        public int compare(ModelNode left, ModelNode right) {
            PathAddress leftAddr = PathAddress.pathAddress((ModelNode)left.get("address"));
            PathAddress rightAddr = PathAddress.pathAddress((ModelNode)right.get("address"));
            String leftOpName = left.require("operation").asString();
            String rightOpName = left.require("operation").asString();
            if (leftAddr.size() == 1 && leftAddr.getElement(0).getKey().equals("extension") && leftOpName.equals("add")) {
                return -1;
            }
            if (rightAddr.size() == 1 && rightAddr.getElement(0).getKey().equals("extension") && rightOpName.equals("add")) {
                return 1;
            }
            return 0;
        }
    }
}

